/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeJobStatus;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeJobSummariesCopier;
import software.amazon.awssdk.services.transcribe.model.MedicalScribeJobSummary;
import software.amazon.awssdk.services.transcribe.model.TranscribeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMedicalScribeJobsResponse
extends TranscribeResponse
implements ToCopyableBuilder<Builder, ListMedicalScribeJobsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListMedicalScribeJobsResponse.getter(ListMedicalScribeJobsResponse::statusAsString)).setter(ListMedicalScribeJobsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMedicalScribeJobsResponse.getter(ListMedicalScribeJobsResponse::nextToken)).setter(ListMedicalScribeJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MedicalScribeJobSummary>> MEDICAL_SCRIBE_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MedicalScribeJobSummaries").getter(ListMedicalScribeJobsResponse.getter(ListMedicalScribeJobsResponse::medicalScribeJobSummaries)).setter(ListMedicalScribeJobsResponse.setter(Builder::medicalScribeJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalScribeJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MedicalScribeJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, NEXT_TOKEN_FIELD, MEDICAL_SCRIBE_JOB_SUMMARIES_FIELD));
    private final String status;
    private final String nextToken;
    private final List<MedicalScribeJobSummary> medicalScribeJobSummaries;

    private ListMedicalScribeJobsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.medicalScribeJobSummaries = builder.medicalScribeJobSummaries;
    }

    public final MedicalScribeJobStatus status() {
        return MedicalScribeJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMedicalScribeJobSummaries() {
        return this.medicalScribeJobSummaries != null && !(this.medicalScribeJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<MedicalScribeJobSummary> medicalScribeJobSummaries() {
        return this.medicalScribeJobSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMedicalScribeJobSummaries() ? this.medicalScribeJobSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMedicalScribeJobsResponse)) {
            return false;
        }
        ListMedicalScribeJobsResponse other = (ListMedicalScribeJobsResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasMedicalScribeJobSummaries() == other.hasMedicalScribeJobSummaries() && Objects.equals(this.medicalScribeJobSummaries(), other.medicalScribeJobSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListMedicalScribeJobsResponse").add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).add("MedicalScribeJobSummaries", this.hasMedicalScribeJobSummaries() ? this.medicalScribeJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MedicalScribeJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.medicalScribeJobSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMedicalScribeJobsResponse, T> g) {
        return obj -> g.apply((ListMedicalScribeJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeResponse.BuilderImpl
    implements Builder {
        private String status;
        private String nextToken;
        private List<MedicalScribeJobSummary> medicalScribeJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMedicalScribeJobsResponse model) {
            super(model);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.medicalScribeJobSummaries(model.medicalScribeJobSummaries);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MedicalScribeJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MedicalScribeJobSummary.Builder> getMedicalScribeJobSummaries() {
            List<MedicalScribeJobSummary.Builder> result = MedicalScribeJobSummariesCopier.copyToBuilder(this.medicalScribeJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMedicalScribeJobSummaries(Collection<MedicalScribeJobSummary.BuilderImpl> medicalScribeJobSummaries) {
            this.medicalScribeJobSummaries = MedicalScribeJobSummariesCopier.copyFromBuilder(medicalScribeJobSummaries);
        }

        @Override
        public final Builder medicalScribeJobSummaries(Collection<MedicalScribeJobSummary> medicalScribeJobSummaries) {
            this.medicalScribeJobSummaries = MedicalScribeJobSummariesCopier.copy(medicalScribeJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medicalScribeJobSummaries(MedicalScribeJobSummary ... medicalScribeJobSummaries) {
            this.medicalScribeJobSummaries(Arrays.asList(medicalScribeJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medicalScribeJobSummaries(Consumer<MedicalScribeJobSummary.Builder> ... medicalScribeJobSummaries) {
            this.medicalScribeJobSummaries(Stream.of(medicalScribeJobSummaries).map(c -> (MedicalScribeJobSummary)((MedicalScribeJobSummary.Builder)MedicalScribeJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMedicalScribeJobsResponse build() {
            return new ListMedicalScribeJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMedicalScribeJobsResponse> {
        public Builder status(String var1);

        public Builder status(MedicalScribeJobStatus var1);

        public Builder nextToken(String var1);

        public Builder medicalScribeJobSummaries(Collection<MedicalScribeJobSummary> var1);

        public Builder medicalScribeJobSummaries(MedicalScribeJobSummary ... var1);

        public Builder medicalScribeJobSummaries(Consumer<MedicalScribeJobSummary.Builder> ... var1);
    }
}

