/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMedicalTranscriptionJobRequest extends TranscribeRequest implements
        ToCopyableBuilder<StartMedicalTranscriptionJobRequest.Builder, StartMedicalTranscriptionJobRequest> {
    private static final SdkField<String> MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MedicalTranscriptionJobName")
            .getter(getter(StartMedicalTranscriptionJobRequest::medicalTranscriptionJobName))
            .setter(setter(Builder::medicalTranscriptionJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalTranscriptionJobName")
                    .build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(StartMedicalTranscriptionJobRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MediaSampleRateHertz").getter(getter(StartMedicalTranscriptionJobRequest::mediaSampleRateHertz))
            .setter(setter(Builder::mediaSampleRateHertz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRateHertz").build())
            .build();

    private static final SdkField<String> MEDIA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaFormat").getter(getter(StartMedicalTranscriptionJobRequest::mediaFormatAsString))
            .setter(setter(Builder::mediaFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaFormat").build()).build();

    private static final SdkField<Media> MEDIA_FIELD = SdkField.<Media> builder(MarshallingType.SDK_POJO).memberName("Media")
            .getter(getter(StartMedicalTranscriptionJobRequest::media)).setter(setter(Builder::media))
            .constructor(Media::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build()).build();

    private static final SdkField<String> OUTPUT_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputBucketName").getter(getter(StartMedicalTranscriptionJobRequest::outputBucketName))
            .setter(setter(Builder::outputBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucketName").build()).build();

    private static final SdkField<String> OUTPUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputKey").getter(getter(StartMedicalTranscriptionJobRequest::outputKey))
            .setter(setter(Builder::outputKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKey").build()).build();

    private static final SdkField<String> OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputEncryptionKMSKeyId").getter(getter(StartMedicalTranscriptionJobRequest::outputEncryptionKMSKeyId))
            .setter(setter(Builder::outputEncryptionKMSKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputEncryptionKMSKeyId").build())
            .build();

    private static final SdkField<Map<String, String>> KMS_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KMSEncryptionContext")
            .getter(getter(StartMedicalTranscriptionJobRequest::kmsEncryptionContext))
            .setter(setter(Builder::kmsEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncryptionContext").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MedicalTranscriptionSetting> SETTINGS_FIELD = SdkField
            .<MedicalTranscriptionSetting> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(StartMedicalTranscriptionJobRequest::settings)).setter(setter(Builder::settings))
            .constructor(MedicalTranscriptionSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentIdentificationType")
            .getter(getter(StartMedicalTranscriptionJobRequest::contentIdentificationTypeAsString))
            .setter(setter(Builder::contentIdentificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentIdentificationType").build())
            .build();

    private static final SdkField<String> SPECIALTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Specialty").getter(getter(StartMedicalTranscriptionJobRequest::specialtyAsString))
            .setter(setter(Builder::specialty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Specialty").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(StartMedicalTranscriptionJobRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartMedicalTranscriptionJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEDICAL_TRANSCRIPTION_JOB_NAME_FIELD, LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_FORMAT_FIELD,
            MEDIA_FIELD, OUTPUT_BUCKET_NAME_FIELD, OUTPUT_KEY_FIELD, OUTPUT_ENCRYPTION_KMS_KEY_ID_FIELD,
            KMS_ENCRYPTION_CONTEXT_FIELD, SETTINGS_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD, SPECIALTY_FIELD, TYPE_FIELD,
            TAGS_FIELD));

    private final String medicalTranscriptionJobName;

    private final String languageCode;

    private final Integer mediaSampleRateHertz;

    private final String mediaFormat;

    private final Media media;

    private final String outputBucketName;

    private final String outputKey;

    private final String outputEncryptionKMSKeyId;

    private final Map<String, String> kmsEncryptionContext;

    private final MedicalTranscriptionSetting settings;

    private final String contentIdentificationType;

    private final String specialty;

    private final String type;

    private final List<Tag> tags;

    private StartMedicalTranscriptionJobRequest(BuilderImpl builder) {
        super(builder);
        this.medicalTranscriptionJobName = builder.medicalTranscriptionJobName;
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaFormat = builder.mediaFormat;
        this.media = builder.media;
        this.outputBucketName = builder.outputBucketName;
        this.outputKey = builder.outputKey;
        this.outputEncryptionKMSKeyId = builder.outputEncryptionKMSKeyId;
        this.kmsEncryptionContext = builder.kmsEncryptionContext;
        this.settings = builder.settings;
        this.contentIdentificationType = builder.contentIdentificationType;
        this.specialty = builder.specialty;
        this.type = builder.type;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique name, chosen by you, for your medical transcription job. The name that you specify is also used as the
     * default name of your transcription output file. If you want to specify a different name for your transcription
     * output, use the <code>OutputKey</code> parameter.
     * </p>
     * <p>
     * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If
     * you try to create a new job with the same name as an existing job, you get a <code>ConflictException</code>
     * error.
     * </p>
     * 
     * @return A unique name, chosen by you, for your medical transcription job. The name that you specify is also used
     *         as the default name of your transcription output file. If you want to specify a different name for your
     *         transcription output, use the <code>OutputKey</code> parameter.</p>
     *         <p>
     *         This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
     *         account. If you try to create a new job with the same name as an existing job, you get a
     *         <code>ConflictException</code> error.
     */
    public final String medicalTranscriptionJobName() {
        return medicalTranscriptionJobName;
    }

    /**
     * <p>
     * The language code that represents the language spoken in the input media file. US English (<code>en-US</code>) is
     * the only valid value for medical transcription jobs. Any other value you enter for language code results in a
     * <code>BadRequestException</code> error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code that represents the language spoken in the input media file. US English (
     *         <code>en-US</code>) is the only valid value for medical transcription jobs. Any other value you enter for
     *         language code results in a <code>BadRequestException</code> error.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code that represents the language spoken in the input media file. US English (<code>en-US</code>) is
     * the only valid value for medical transcription jobs. Any other value you enter for language code results in a
     * <code>BadRequestException</code> error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code that represents the language spoken in the input media file. US English (
     *         <code>en-US</code>) is the only valid value for medical transcription jobs. Any other value you enter for
     *         language code results in a <code>BadRequestException</code> error.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The sample rate, in hertz, of the audio track in your input media file.
     * </p>
     * <p>
     * If you do not specify the media sample rate, Amazon Transcribe Medical determines it for you. If you specify the
     * sample rate, it must match the rate detected by Amazon Transcribe Medical; if there's a mismatch between the
     * value that you specify and the value detected, your job fails. Therefore, in most cases, it's advised to omit
     * <code>MediaSampleRateHertz</code> and let Amazon Transcribe Medical determine the sample rate.
     * </p>
     * 
     * @return The sample rate, in hertz, of the audio track in your input media file.</p>
     *         <p>
     *         If you do not specify the media sample rate, Amazon Transcribe Medical determines it for you. If you
     *         specify the sample rate, it must match the rate detected by Amazon Transcribe Medical; if there's a
     *         mismatch between the value that you specify and the value detected, your job fails. Therefore, in most
     *         cases, it's advised to omit <code>MediaSampleRateHertz</code> and let Amazon Transcribe Medical determine
     *         the sample rate.
     */
    public final Integer mediaSampleRateHertz() {
        return mediaSampleRateHertz;
    }

    /**
     * <p>
     * Specify the format of your input media file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaFormat} will
     * return {@link MediaFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaFormatAsString}.
     * </p>
     * 
     * @return Specify the format of your input media file.
     * @see MediaFormat
     */
    public final MediaFormat mediaFormat() {
        return MediaFormat.fromValue(mediaFormat);
    }

    /**
     * <p>
     * Specify the format of your input media file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaFormat} will
     * return {@link MediaFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaFormatAsString}.
     * </p>
     * 
     * @return Specify the format of your input media file.
     * @see MediaFormat
     */
    public final String mediaFormatAsString() {
        return mediaFormat;
    }

    /**
     * Returns the value of the Media property for this object.
     * 
     * @return The value of the Media property for this object.
     */
    public final Media media() {
        return media;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where you want your medical transcription output stored. Do not include the
     * <code>S3://</code> prefix of the specified bucket.
     * </p>
     * <p>
     * If you want your output to go to a sub-folder of this bucket, specify it using the <code>OutputKey</code>
     * parameter; <code>OutputBucketName</code> only accepts the name of a bucket.
     * </p>
     * <p>
     * For example, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET</code>, set
     * <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code>. However, if you want your output stored in
     * <code>S3://DOC-EXAMPLE-BUCKET/test-files/</code>, set <code>OutputBucketName</code> to
     * <code>DOC-EXAMPLE-BUCKET</code> and <code>OutputKey</code> to <code>test-files/</code>.
     * </p>
     * <p>
     * Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon S3
     * permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>. See
     * also <a href=
     * "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
     * >Permissions Required for IAM User Roles</a>.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket where you want your medical transcription output stored. Do not include
     *         the <code>S3://</code> prefix of the specified bucket.</p>
     *         <p>
     *         If you want your output to go to a sub-folder of this bucket, specify it using the <code>OutputKey</code>
     *         parameter; <code>OutputBucketName</code> only accepts the name of a bucket.
     *         </p>
     *         <p>
     *         For example, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET</code>, set
     *         <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code>. However, if you want your output stored
     *         in <code>S3://DOC-EXAMPLE-BUCKET/test-files/</code>, set <code>OutputBucketName</code> to
     *         <code>DOC-EXAMPLE-BUCKET</code> and <code>OutputKey</code> to <code>test-files/</code>.
     *         </p>
     *         <p>
     *         Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon S3
     *         permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management
     *         Console</a>. See also <a href=
     *         "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
     *         >Permissions Required for IAM User Roles</a>.
     */
    public final String outputBucketName() {
        return outputBucketName;
    }

    /**
     * <p>
     * Use in combination with <code>OutputBucketName</code> to specify the output location of your transcript and,
     * optionally, a unique name for your output file. The default name for your transcription output is the same as the
     * name you specified for your medical transcription job (<code>MedicalTranscriptionJobName</code>).
     * </p>
     * <p>
     * Here are some examples of how you can use <code>OutputKey</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'my-transcript.json' as the
     * <code>OutputKey</code>, your transcription output path is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript.json</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify 'my-first-transcription' as the <code>MedicalTranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET' as
     * the <code>OutputBucketName</code>, and 'my-transcript' as the <code>OutputKey</code>, your transcription output
     * path is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'test-files/my-transcript.json' as
     * the <code>OutputKey</code>, your transcription output path is
     * <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify 'my-first-transcription' as the <code>MedicalTranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET' as
     * the <code>OutputBucketName</code>, and 'test-files/my-transcript' as the <code>OutputKey</code>, your
     * transcription output path is
     * <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist, one is created for you.
     * </p>
     * 
     * @return Use in combination with <code>OutputBucketName</code> to specify the output location of your transcript
     *         and, optionally, a unique name for your output file. The default name for your transcription output is
     *         the same as the name you specified for your medical transcription job (
     *         <code>MedicalTranscriptionJobName</code>).</p>
     *         <p>
     *         Here are some examples of how you can use <code>OutputKey</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'my-transcript.json' as the
     *         <code>OutputKey</code>, your transcription output path is
     *         <code>s3://DOC-EXAMPLE-BUCKET/my-transcript.json</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify 'my-first-transcription' as the <code>MedicalTranscriptionJobName</code>,
     *         'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code>, and 'my-transcript' as the
     *         <code>OutputKey</code>, your transcription output path is
     *         <code>s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and
     *         'test-files/my-transcript.json' as the <code>OutputKey</code>, your transcription output path is
     *         <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify 'my-first-transcription' as the <code>MedicalTranscriptionJobName</code>,
     *         'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code>, and 'test-files/my-transcript' as the
     *         <code>OutputKey</code>, your transcription output path is
     *         <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist, one is created for you.
     */
    public final String outputKey() {
        return outputKey;
    }

    /**
     * <p>
     * The KMS key you want to use to encrypt your medical transcription output.
     * </p>
     * <p>
     * If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of
     * four ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
     * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services
     * account, you can specify your KMS key in one of two ways:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use the ARN for the KMS key ID. For example,
     * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
     * </p>
     * <p>
     * If you specify a KMS key to encrypt your output, you must also specify an output location using the
     * <code>OutputLocation</code> parameter.
     * </p>
     * <p>
     * Note that the role making the request must have permission to use the specified KMS key.
     * </p>
     * 
     * @return The KMS key you want to use to encrypt your medical transcription output.</p>
     *         <p>
     *         If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in
     *         one of four ways:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
     *         <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key alias. For example,
     *         <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web
     *         Services account, you can specify your KMS key in one of two ways:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key ID. For example,
     *         <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key alias. For example,
     *         <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         </ol>
     *         <p>
     *         If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key
     *         (SSE-S3).
     *         </p>
     *         <p>
     *         If you specify a KMS key to encrypt your output, you must also specify an output location using the
     *         <code>OutputLocation</code> parameter.
     *         </p>
     *         <p>
     *         Note that the role making the request must have permission to use the specified KMS key.
     */
    public final String outputEncryptionKMSKeyId() {
        return outputEncryptionKMSKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the KMSEncryptionContext property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKmsEncryptionContext() {
        return kmsEncryptionContext != null && !(kmsEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer
     * of security for your data. For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
     * context</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric
     * keys in KMS</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKmsEncryptionContext} method.
     * </p>
     * 
     * @return A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added
     *         layer of security for your data. For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
     *         context</a> and <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in
     *         KMS</a>.
     */
    public final Map<String, String> kmsEncryptionContext() {
        return kmsEncryptionContext;
    }

    /**
     * <p>
     * Specify additional optional settings in your request, including channel identification, alternative
     * transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your transcription
     * job.
     * </p>
     * 
     * @return Specify additional optional settings in your request, including channel identification, alternative
     *         transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your
     *         transcription job.
     */
    public final MedicalTranscriptionSetting settings() {
        return settings;
    }

    /**
     * <p>
     * Labels all personal health information (PHI) identified in your transcript. For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information (PHI)
     * in a transcription</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link MedicalContentIdentificationType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Labels all personal health information (PHI) identified in your transcript. For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health
     *         information (PHI) in a transcription</a>.
     * @see MedicalContentIdentificationType
     */
    public final MedicalContentIdentificationType contentIdentificationType() {
        return MedicalContentIdentificationType.fromValue(contentIdentificationType);
    }

    /**
     * <p>
     * Labels all personal health information (PHI) identified in your transcript. For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information (PHI)
     * in a transcription</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentIdentificationType} will return {@link MedicalContentIdentificationType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #contentIdentificationTypeAsString}.
     * </p>
     * 
     * @return Labels all personal health information (PHI) identified in your transcript. For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health
     *         information (PHI) in a transcription</a>.
     * @see MedicalContentIdentificationType
     */
    public final String contentIdentificationTypeAsString() {
        return contentIdentificationType;
    }

    /**
     * <p>
     * Specify the predominant medical specialty represented in your media. For batch transcriptions,
     * <code>PRIMARYCARE</code> is the only valid value. If you require additional specialties, refer to .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialty} will
     * return {@link Specialty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specialtyAsString}.
     * </p>
     * 
     * @return Specify the predominant medical specialty represented in your media. For batch transcriptions,
     *         <code>PRIMARYCARE</code> is the only valid value. If you require additional specialties, refer to .
     * @see Specialty
     */
    public final Specialty specialty() {
        return Specialty.fromValue(specialty);
    }

    /**
     * <p>
     * Specify the predominant medical specialty represented in your media. For batch transcriptions,
     * <code>PRIMARYCARE</code> is the only valid value. If you require additional specialties, refer to .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialty} will
     * return {@link Specialty#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specialtyAsString}.
     * </p>
     * 
     * @return Specify the predominant medical specialty represented in your media. For batch transcriptions,
     *         <code>PRIMARYCARE</code> is the only valid value. If you require additional specialties, refer to .
     * @see Specialty
     */
    public final String specialtyAsString() {
        return specialty;
    }

    /**
     * <p>
     * Specify whether your input media contains only one person (<code>DICTATION</code>) or contains a conversation
     * between two people (<code>CONVERSATION</code>).
     * </p>
     * <p>
     * For example, <code>DICTATION</code> could be used for a medical professional wanting to transcribe voice memos;
     * <code>CONVERSATION</code> could be used for transcribing the doctor-patient dialogue during the patient's office
     * visit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specify whether your input media contains only one person (<code>DICTATION</code>) or contains a
     *         conversation between two people (<code>CONVERSATION</code>).</p>
     *         <p>
     *         For example, <code>DICTATION</code> could be used for a medical professional wanting to transcribe voice
     *         memos; <code>CONVERSATION</code> could be used for transcribing the doctor-patient dialogue during the
     *         patient's office visit.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * Specify whether your input media contains only one person (<code>DICTATION</code>) or contains a conversation
     * between two people (<code>CONVERSATION</code>).
     * </p>
     * <p>
     * For example, <code>DICTATION</code> could be used for a medical professional wanting to transcribe voice memos;
     * <code>CONVERSATION</code> could be used for transcribing the doctor-patient dialogue during the patient's office
     * visit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specify whether your input media contains only one person (<code>DICTATION</code>) or contains a
     *         conversation between two people (<code>CONVERSATION</code>).</p>
     *         <p>
     *         For example, <code>DICTATION</code> could be used for a medical professional wanting to transcribe voice
     *         memos; <code>CONVERSATION</code> could be used for transcribing the doctor-patient dialogue during the
     *         patient's office visit.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Adds one or more custom tags, each in the form of a key:value pair, to a new medical transcription job at the
     * time you start this new job.
     * </p>
     * <p>
     * To learn more about using tags with Amazon Transcribe, refer to <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds one or more custom tags, each in the form of a key:value pair, to a new medical transcription job at
     *         the time you start this new job.</p>
     *         <p>
     *         To learn more about using tags with Amazon Transcribe, refer to <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(medicalTranscriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(mediaFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(media());
        hashCode = 31 * hashCode + Objects.hashCode(outputBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(outputEncryptionKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasKmsEncryptionContext() ? kmsEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        hashCode = 31 * hashCode + Objects.hashCode(contentIdentificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(specialtyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMedicalTranscriptionJobRequest)) {
            return false;
        }
        StartMedicalTranscriptionJobRequest other = (StartMedicalTranscriptionJobRequest) obj;
        return Objects.equals(medicalTranscriptionJobName(), other.medicalTranscriptionJobName())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(mediaSampleRateHertz(), other.mediaSampleRateHertz())
                && Objects.equals(mediaFormatAsString(), other.mediaFormatAsString()) && Objects.equals(media(), other.media())
                && Objects.equals(outputBucketName(), other.outputBucketName()) && Objects.equals(outputKey(), other.outputKey())
                && Objects.equals(outputEncryptionKMSKeyId(), other.outputEncryptionKMSKeyId())
                && hasKmsEncryptionContext() == other.hasKmsEncryptionContext()
                && Objects.equals(kmsEncryptionContext(), other.kmsEncryptionContext())
                && Objects.equals(settings(), other.settings())
                && Objects.equals(contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString())
                && Objects.equals(specialtyAsString(), other.specialtyAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMedicalTranscriptionJobRequest")
                .add("MedicalTranscriptionJobName", medicalTranscriptionJobName()).add("LanguageCode", languageCodeAsString())
                .add("MediaSampleRateHertz", mediaSampleRateHertz()).add("MediaFormat", mediaFormatAsString())
                .add("Media", media()).add("OutputBucketName", outputBucketName()).add("OutputKey", outputKey())
                .add("OutputEncryptionKMSKeyId", outputEncryptionKMSKeyId())
                .add("KMSEncryptionContext", hasKmsEncryptionContext() ? kmsEncryptionContext() : null)
                .add("Settings", settings()).add("ContentIdentificationType", contentIdentificationTypeAsString())
                .add("Specialty", specialtyAsString()).add("Type", typeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MedicalTranscriptionJobName":
            return Optional.ofNullable(clazz.cast(medicalTranscriptionJobName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "MediaSampleRateHertz":
            return Optional.ofNullable(clazz.cast(mediaSampleRateHertz()));
        case "MediaFormat":
            return Optional.ofNullable(clazz.cast(mediaFormatAsString()));
        case "Media":
            return Optional.ofNullable(clazz.cast(media()));
        case "OutputBucketName":
            return Optional.ofNullable(clazz.cast(outputBucketName()));
        case "OutputKey":
            return Optional.ofNullable(clazz.cast(outputKey()));
        case "OutputEncryptionKMSKeyId":
            return Optional.ofNullable(clazz.cast(outputEncryptionKMSKeyId()));
        case "KMSEncryptionContext":
            return Optional.ofNullable(clazz.cast(kmsEncryptionContext()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "ContentIdentificationType":
            return Optional.ofNullable(clazz.cast(contentIdentificationTypeAsString()));
        case "Specialty":
            return Optional.ofNullable(clazz.cast(specialtyAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMedicalTranscriptionJobRequest, T> g) {
        return obj -> g.apply((StartMedicalTranscriptionJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMedicalTranscriptionJobRequest> {
        /**
         * <p>
         * A unique name, chosen by you, for your medical transcription job. The name that you specify is also used as
         * the default name of your transcription output file. If you want to specify a different name for your
         * transcription output, use the <code>OutputKey</code> parameter.
         * </p>
         * <p>
         * This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.
         * If you try to create a new job with the same name as an existing job, you get a
         * <code>ConflictException</code> error.
         * </p>
         * 
         * @param medicalTranscriptionJobName
         *        A unique name, chosen by you, for your medical transcription job. The name that you specify is also
         *        used as the default name of your transcription output file. If you want to specify a different name
         *        for your transcription output, use the <code>OutputKey</code> parameter.</p>
         *        <p>
         *        This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services
         *        account. If you try to create a new job with the same name as an existing job, you get a
         *        <code>ConflictException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalTranscriptionJobName(String medicalTranscriptionJobName);

        /**
         * <p>
         * The language code that represents the language spoken in the input media file. US English (<code>en-US</code>
         * ) is the only valid value for medical transcription jobs. Any other value you enter for language code results
         * in a <code>BadRequestException</code> error.
         * </p>
         * 
         * @param languageCode
         *        The language code that represents the language spoken in the input media file. US English (
         *        <code>en-US</code>) is the only valid value for medical transcription jobs. Any other value you enter
         *        for language code results in a <code>BadRequestException</code> error.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code that represents the language spoken in the input media file. US English (<code>en-US</code>
         * ) is the only valid value for medical transcription jobs. Any other value you enter for language code results
         * in a <code>BadRequestException</code> error.
         * </p>
         * 
         * @param languageCode
         *        The language code that represents the language spoken in the input media file. US English (
         *        <code>en-US</code>) is the only valid value for medical transcription jobs. Any other value you enter
         *        for language code results in a <code>BadRequestException</code> error.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * The sample rate, in hertz, of the audio track in your input media file.
         * </p>
         * <p>
         * If you do not specify the media sample rate, Amazon Transcribe Medical determines it for you. If you specify
         * the sample rate, it must match the rate detected by Amazon Transcribe Medical; if there's a mismatch between
         * the value that you specify and the value detected, your job fails. Therefore, in most cases, it's advised to
         * omit <code>MediaSampleRateHertz</code> and let Amazon Transcribe Medical determine the sample rate.
         * </p>
         * 
         * @param mediaSampleRateHertz
         *        The sample rate, in hertz, of the audio track in your input media file.</p>
         *        <p>
         *        If you do not specify the media sample rate, Amazon Transcribe Medical determines it for you. If you
         *        specify the sample rate, it must match the rate detected by Amazon Transcribe Medical; if there's a
         *        mismatch between the value that you specify and the value detected, your job fails. Therefore, in most
         *        cases, it's advised to omit <code>MediaSampleRateHertz</code> and let Amazon Transcribe Medical
         *        determine the sample rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSampleRateHertz(Integer mediaSampleRateHertz);

        /**
         * <p>
         * Specify the format of your input media file.
         * </p>
         * 
         * @param mediaFormat
         *        Specify the format of your input media file.
         * @see MediaFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaFormat
         */
        Builder mediaFormat(String mediaFormat);

        /**
         * <p>
         * Specify the format of your input media file.
         * </p>
         * 
         * @param mediaFormat
         *        Specify the format of your input media file.
         * @see MediaFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaFormat
         */
        Builder mediaFormat(MediaFormat mediaFormat);

        /**
         * Sets the value of the Media property for this object.
         *
         * @param media
         *        The new value for the Media property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder media(Media media);

        /**
         * Sets the value of the Media property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Media.Builder} avoiding the need to
         * create one manually via {@link Media#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Media.Builder#build()} is called immediately and its result is
         * passed to {@link #media(Media)}.
         * 
         * @param media
         *        a consumer that will call methods on {@link Media.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #media(Media)
         */
        default Builder media(Consumer<Media.Builder> media) {
            return media(Media.builder().applyMutation(media).build());
        }

        /**
         * <p>
         * The name of the Amazon S3 bucket where you want your medical transcription output stored. Do not include the
         * <code>S3://</code> prefix of the specified bucket.
         * </p>
         * <p>
         * If you want your output to go to a sub-folder of this bucket, specify it using the <code>OutputKey</code>
         * parameter; <code>OutputBucketName</code> only accepts the name of a bucket.
         * </p>
         * <p>
         * For example, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET</code>, set
         * <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code>. However, if you want your output stored in
         * <code>S3://DOC-EXAMPLE-BUCKET/test-files/</code>, set <code>OutputBucketName</code> to
         * <code>DOC-EXAMPLE-BUCKET</code> and <code>OutputKey</code> to <code>test-files/</code>.
         * </p>
         * <p>
         * Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon S3
         * permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>.
         * See also <a href=
         * "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
         * >Permissions Required for IAM User Roles</a>.
         * </p>
         * 
         * @param outputBucketName
         *        The name of the Amazon S3 bucket where you want your medical transcription output stored. Do not
         *        include the <code>S3://</code> prefix of the specified bucket.</p>
         *        <p>
         *        If you want your output to go to a sub-folder of this bucket, specify it using the
         *        <code>OutputKey</code> parameter; <code>OutputBucketName</code> only accepts the name of a bucket.
         *        </p>
         *        <p>
         *        For example, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET</code>, set
         *        <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code>. However, if you want your output
         *        stored in <code>S3://DOC-EXAMPLE-BUCKET/test-files/</code>, set <code>OutputBucketName</code> to
         *        <code>DOC-EXAMPLE-BUCKET</code> and <code>OutputKey</code> to <code>test-files/</code>.
         *        </p>
         *        <p>
         *        Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon
         *        S3 permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management
         *        Console</a>. See also <a href=
         *        "https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user"
         *        >Permissions Required for IAM User Roles</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBucketName(String outputBucketName);

        /**
         * <p>
         * Use in combination with <code>OutputBucketName</code> to specify the output location of your transcript and,
         * optionally, a unique name for your output file. The default name for your transcription output is the same as
         * the name you specified for your medical transcription job (<code>MedicalTranscriptionJobName</code>).
         * </p>
         * <p>
         * Here are some examples of how you can use <code>OutputKey</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'my-transcript.json' as the
         * <code>OutputKey</code>, your transcription output path is
         * <code>s3://DOC-EXAMPLE-BUCKET/my-transcript.json</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify 'my-first-transcription' as the <code>MedicalTranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET'
         * as the <code>OutputBucketName</code>, and 'my-transcript' as the <code>OutputKey</code>, your transcription
         * output path is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'test-files/my-transcript.json'
         * as the <code>OutputKey</code>, your transcription output path is
         * <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify 'my-first-transcription' as the <code>MedicalTranscriptionJobName</code>, 'DOC-EXAMPLE-BUCKET'
         * as the <code>OutputBucketName</code>, and 'test-files/my-transcript' as the <code>OutputKey</code>, your
         * transcription output path is
         * <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist, one is created for you.
         * </p>
         * 
         * @param outputKey
         *        Use in combination with <code>OutputBucketName</code> to specify the output location of your
         *        transcript and, optionally, a unique name for your output file. The default name for your
         *        transcription output is the same as the name you specified for your medical transcription job (
         *        <code>MedicalTranscriptionJobName</code>).</p>
         *        <p>
         *        Here are some examples of how you can use <code>OutputKey</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and 'my-transcript.json' as
         *        the <code>OutputKey</code>, your transcription output path is
         *        <code>s3://DOC-EXAMPLE-BUCKET/my-transcript.json</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify 'my-first-transcription' as the <code>MedicalTranscriptionJobName</code>,
         *        'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code>, and 'my-transcript' as the
         *        <code>OutputKey</code>, your transcription output path is
         *        <code>s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify 'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code> and
         *        'test-files/my-transcript.json' as the <code>OutputKey</code>, your transcription output path is
         *        <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify 'my-first-transcription' as the <code>MedicalTranscriptionJobName</code>,
         *        'DOC-EXAMPLE-BUCKET' as the <code>OutputBucketName</code>, and 'test-files/my-transcript' as the
         *        <code>OutputKey</code>, your transcription output path is
         *        <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist, one is created for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputKey(String outputKey);

        /**
         * <p>
         * The KMS key you want to use to encrypt your medical transcription output.
         * </p>
         * <p>
         * If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one
         * of four ways:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
         * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>
         * .
         * </p>
         * </li>
         * </ol>
         * <p>
         * If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services
         * account, you can specify your KMS key in one of two ways:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Use the ARN for the KMS key ID. For example,
         * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>
         * .
         * </p>
         * </li>
         * </ol>
         * <p>
         * If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
         * </p>
         * <p>
         * If you specify a KMS key to encrypt your output, you must also specify an output location using the
         * <code>OutputLocation</code> parameter.
         * </p>
         * <p>
         * Note that the role making the request must have permission to use the specified KMS key.
         * </p>
         * 
         * @param outputEncryptionKMSKeyId
         *        The KMS key you want to use to encrypt your medical transcription output.</p>
         *        <p>
         *        If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key
         *        in one of four ways:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
         *        <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key alias. For example,
         *        <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web
         *        Services account, you can specify your KMS key in one of two ways:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key ID. For example,
         *        <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key alias. For example,
         *        <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        </ol>
         *        <p>
         *        If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key
         *        (SSE-S3).
         *        </p>
         *        <p>
         *        If you specify a KMS key to encrypt your output, you must also specify an output location using the
         *        <code>OutputLocation</code> parameter.
         *        </p>
         *        <p>
         *        Note that the role making the request must have permission to use the specified KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId);

        /**
         * <p>
         * A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added
         * layer of security for your data. For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
         * context</a> and <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS</a>.
         * </p>
         * 
         * @param kmsEncryptionContext
         *        A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an
         *        added layer of security for your data. For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption
         *        context</a> and <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in
         *        KMS</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext);

        /**
         * <p>
         * Specify additional optional settings in your request, including channel identification, alternative
         * transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your transcription
         * job.
         * </p>
         * 
         * @param settings
         *        Specify additional optional settings in your request, including channel identification, alternative
         *        transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your
         *        transcription job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(MedicalTranscriptionSetting settings);

        /**
         * <p>
         * Specify additional optional settings in your request, including channel identification, alternative
         * transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your transcription
         * job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MedicalTranscriptionSetting.Builder}
         * avoiding the need to create one manually via {@link MedicalTranscriptionSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MedicalTranscriptionSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #settings(MedicalTranscriptionSetting)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link MedicalTranscriptionSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(MedicalTranscriptionSetting)
         */
        default Builder settings(Consumer<MedicalTranscriptionSetting.Builder> settings) {
            return settings(MedicalTranscriptionSetting.builder().applyMutation(settings).build());
        }

        /**
         * <p>
         * Labels all personal health information (PHI) identified in your transcript. For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information
         * (PHI) in a transcription</a>.
         * </p>
         * 
         * @param contentIdentificationType
         *        Labels all personal health information (PHI) identified in your transcript. For more information, see
         *        <a href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health
         *        information (PHI) in a transcription</a>.
         * @see MedicalContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalContentIdentificationType
         */
        Builder contentIdentificationType(String contentIdentificationType);

        /**
         * <p>
         * Labels all personal health information (PHI) identified in your transcript. For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information
         * (PHI) in a transcription</a>.
         * </p>
         * 
         * @param contentIdentificationType
         *        Labels all personal health information (PHI) identified in your transcript. For more information, see
         *        <a href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health
         *        information (PHI) in a transcription</a>.
         * @see MedicalContentIdentificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalContentIdentificationType
         */
        Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType);

        /**
         * <p>
         * Specify the predominant medical specialty represented in your media. For batch transcriptions,
         * <code>PRIMARYCARE</code> is the only valid value. If you require additional specialties, refer to .
         * </p>
         * 
         * @param specialty
         *        Specify the predominant medical specialty represented in your media. For batch transcriptions,
         *        <code>PRIMARYCARE</code> is the only valid value. If you require additional specialties, refer to .
         * @see Specialty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Specialty
         */
        Builder specialty(String specialty);

        /**
         * <p>
         * Specify the predominant medical specialty represented in your media. For batch transcriptions,
         * <code>PRIMARYCARE</code> is the only valid value. If you require additional specialties, refer to .
         * </p>
         * 
         * @param specialty
         *        Specify the predominant medical specialty represented in your media. For batch transcriptions,
         *        <code>PRIMARYCARE</code> is the only valid value. If you require additional specialties, refer to .
         * @see Specialty
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Specialty
         */
        Builder specialty(Specialty specialty);

        /**
         * <p>
         * Specify whether your input media contains only one person (<code>DICTATION</code>) or contains a conversation
         * between two people (<code>CONVERSATION</code>).
         * </p>
         * <p>
         * For example, <code>DICTATION</code> could be used for a medical professional wanting to transcribe voice
         * memos; <code>CONVERSATION</code> could be used for transcribing the doctor-patient dialogue during the
         * patient's office visit.
         * </p>
         * 
         * @param type
         *        Specify whether your input media contains only one person (<code>DICTATION</code>) or contains a
         *        conversation between two people (<code>CONVERSATION</code>).</p>
         *        <p>
         *        For example, <code>DICTATION</code> could be used for a medical professional wanting to transcribe
         *        voice memos; <code>CONVERSATION</code> could be used for transcribing the doctor-patient dialogue
         *        during the patient's office visit.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * Specify whether your input media contains only one person (<code>DICTATION</code>) or contains a conversation
         * between two people (<code>CONVERSATION</code>).
         * </p>
         * <p>
         * For example, <code>DICTATION</code> could be used for a medical professional wanting to transcribe voice
         * memos; <code>CONVERSATION</code> could be used for transcribing the doctor-patient dialogue during the
         * patient's office visit.
         * </p>
         * 
         * @param type
         *        Specify whether your input media contains only one person (<code>DICTATION</code>) or contains a
         *        conversation between two people (<code>CONVERSATION</code>).</p>
         *        <p>
         *        For example, <code>DICTATION</code> could be used for a medical professional wanting to transcribe
         *        voice memos; <code>CONVERSATION</code> could be used for transcribing the doctor-patient dialogue
         *        during the patient's office visit.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to a new medical transcription job at the
         * time you start this new job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * 
         * @param tags
         *        Adds one or more custom tags, each in the form of a key:value pair, to a new medical transcription job
         *        at the time you start this new job.</p>
         *        <p>
         *        To learn more about using tags with Amazon Transcribe, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to a new medical transcription job at the
         * time you start this new job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * 
         * @param tags
         *        Adds one or more custom tags, each in the form of a key:value pair, to a new medical transcription job
         *        at the time you start this new job.</p>
         *        <p>
         *        To learn more about using tags with Amazon Transcribe, refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Adds one or more custom tags, each in the form of a key:value pair, to a new medical transcription job at the
         * time you start this new job.
         * </p>
         * <p>
         * To learn more about using tags with Amazon Transcribe, refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.transcribe.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranscribeRequest.BuilderImpl implements Builder {
        private String medicalTranscriptionJobName;

        private String languageCode;

        private Integer mediaSampleRateHertz;

        private String mediaFormat;

        private Media media;

        private String outputBucketName;

        private String outputKey;

        private String outputEncryptionKMSKeyId;

        private Map<String, String> kmsEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private MedicalTranscriptionSetting settings;

        private String contentIdentificationType;

        private String specialty;

        private String type;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMedicalTranscriptionJobRequest model) {
            super(model);
            medicalTranscriptionJobName(model.medicalTranscriptionJobName);
            languageCode(model.languageCode);
            mediaSampleRateHertz(model.mediaSampleRateHertz);
            mediaFormat(model.mediaFormat);
            media(model.media);
            outputBucketName(model.outputBucketName);
            outputKey(model.outputKey);
            outputEncryptionKMSKeyId(model.outputEncryptionKMSKeyId);
            kmsEncryptionContext(model.kmsEncryptionContext);
            settings(model.settings);
            contentIdentificationType(model.contentIdentificationType);
            specialty(model.specialty);
            type(model.type);
            tags(model.tags);
        }

        public final String getMedicalTranscriptionJobName() {
            return medicalTranscriptionJobName;
        }

        public final void setMedicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
        }

        @Override
        public final Builder medicalTranscriptionJobName(String medicalTranscriptionJobName) {
            this.medicalTranscriptionJobName = medicalTranscriptionJobName;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaFormat() {
            return mediaFormat;
        }

        public final void setMediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
        }

        @Override
        public final Builder mediaFormat(String mediaFormat) {
            this.mediaFormat = mediaFormat;
            return this;
        }

        @Override
        public final Builder mediaFormat(MediaFormat mediaFormat) {
            this.mediaFormat(mediaFormat == null ? null : mediaFormat.toString());
            return this;
        }

        public final Media.Builder getMedia() {
            return media != null ? media.toBuilder() : null;
        }

        public final void setMedia(Media.BuilderImpl media) {
            this.media = media != null ? media.build() : null;
        }

        @Override
        public final Builder media(Media media) {
            this.media = media;
            return this;
        }

        public final String getOutputBucketName() {
            return outputBucketName;
        }

        public final void setOutputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
        }

        @Override
        public final Builder outputBucketName(String outputBucketName) {
            this.outputBucketName = outputBucketName;
            return this;
        }

        public final String getOutputKey() {
            return outputKey;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final String getOutputEncryptionKMSKeyId() {
            return outputEncryptionKMSKeyId;
        }

        public final void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
        }

        @Override
        public final Builder outputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
            this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
            return this;
        }

        public final Map<String, String> getKmsEncryptionContext() {
            if (kmsEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return kmsEncryptionContext;
        }

        public final void setKmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KMSEncryptionContextMapCopier.copy(kmsEncryptionContext);
        }

        @Override
        public final Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = KMSEncryptionContextMapCopier.copy(kmsEncryptionContext);
            return this;
        }

        public final MedicalTranscriptionSetting.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(MedicalTranscriptionSetting.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(MedicalTranscriptionSetting settings) {
            this.settings = settings;
            return this;
        }

        public final String getContentIdentificationType() {
            return contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        public final Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        public final String getSpecialty() {
            return specialty;
        }

        public final void setSpecialty(String specialty) {
            this.specialty = specialty;
        }

        @Override
        public final Builder specialty(String specialty) {
            this.specialty = specialty;
            return this;
        }

        @Override
        public final Builder specialty(Specialty specialty) {
            this.specialty(specialty == null ? null : specialty.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMedicalTranscriptionJobRequest build() {
            return new StartMedicalTranscriptionJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
