/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMedicalTranscriptionJobsResponse extends TranscribeResponse implements
        ToCopyableBuilder<ListMedicalTranscriptionJobsResponse.Builder, ListMedicalTranscriptionJobsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListMedicalTranscriptionJobsResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMedicalTranscriptionJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<MedicalTranscriptionJobSummary>> MEDICAL_TRANSCRIPTION_JOB_SUMMARIES_FIELD = SdkField
            .<List<MedicalTranscriptionJobSummary>> builder(MarshallingType.LIST)
            .memberName("MedicalTranscriptionJobSummaries")
            .getter(getter(ListMedicalTranscriptionJobsResponse::medicalTranscriptionJobSummaries))
            .setter(setter(Builder::medicalTranscriptionJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedicalTranscriptionJobSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MedicalTranscriptionJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MedicalTranscriptionJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            NEXT_TOKEN_FIELD, MEDICAL_TRANSCRIPTION_JOB_SUMMARIES_FIELD));

    private final String status;

    private final String nextToken;

    private final List<MedicalTranscriptionJobSummary> medicalTranscriptionJobSummaries;

    private ListMedicalTranscriptionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.medicalTranscriptionJobSummaries = builder.medicalTranscriptionJobSummaries;
    }

    /**
     * <p>
     * Lists all medical transcription jobs that have the status specified in your request. Jobs are ordered by creation
     * date, with the newest job first.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Lists all medical transcription jobs that have the status specified in your request. Jobs are ordered by
     *         creation date, with the newest job first.
     * @see TranscriptionJobStatus
     */
    public final TranscriptionJobStatus status() {
        return TranscriptionJobStatus.fromValue(status);
    }

    /**
     * <p>
     * Lists all medical transcription jobs that have the status specified in your request. Jobs are ordered by creation
     * date, with the newest job first.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TranscriptionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Lists all medical transcription jobs that have the status specified in your request. Jobs are ordered by
     *         creation date, with the newest job first.
     * @see TranscriptionJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view
     * the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results
     * output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat
     * as needed to view all your results.
     * </p>
     * 
     * @return If <code>NextToken</code> is present in your response, it indicates that not all results are displayed.
     *         To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in
     *         your results output, then run your request again including <code>NextToken</code> with the value of the
     *         copied string. Repeat as needed to view all your results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MedicalTranscriptionJobSummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasMedicalTranscriptionJobSummaries() {
        return medicalTranscriptionJobSummaries != null && !(medicalTranscriptionJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a summary of information about each result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMedicalTranscriptionJobSummaries}
     * method.
     * </p>
     * 
     * @return Provides a summary of information about each result.
     */
    public final List<MedicalTranscriptionJobSummary> medicalTranscriptionJobSummaries() {
        return medicalTranscriptionJobSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMedicalTranscriptionJobSummaries() ? medicalTranscriptionJobSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMedicalTranscriptionJobsResponse)) {
            return false;
        }
        ListMedicalTranscriptionJobsResponse other = (ListMedicalTranscriptionJobsResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(nextToken(), other.nextToken())
                && hasMedicalTranscriptionJobSummaries() == other.hasMedicalTranscriptionJobSummaries()
                && Objects.equals(medicalTranscriptionJobSummaries(), other.medicalTranscriptionJobSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListMedicalTranscriptionJobsResponse")
                .add("Status", statusAsString())
                .add("NextToken", nextToken())
                .add("MedicalTranscriptionJobSummaries",
                        hasMedicalTranscriptionJobSummaries() ? medicalTranscriptionJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MedicalTranscriptionJobSummaries":
            return Optional.ofNullable(clazz.cast(medicalTranscriptionJobSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMedicalTranscriptionJobsResponse, T> g) {
        return obj -> g.apply((ListMedicalTranscriptionJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranscribeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMedicalTranscriptionJobsResponse> {
        /**
         * <p>
         * Lists all medical transcription jobs that have the status specified in your request. Jobs are ordered by
         * creation date, with the newest job first.
         * </p>
         * 
         * @param status
         *        Lists all medical transcription jobs that have the status specified in your request. Jobs are ordered
         *        by creation date, with the newest job first.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Lists all medical transcription jobs that have the status specified in your request. Jobs are ordered by
         * creation date, with the newest job first.
         * </p>
         * 
         * @param status
         *        Lists all medical transcription jobs that have the status specified in your request. Jobs are ordered
         *        by creation date, with the newest job first.
         * @see TranscriptionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TranscriptionJobStatus
         */
        Builder status(TranscriptionJobStatus status);

        /**
         * <p>
         * If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To
         * view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your
         * results output, then run your request again including <code>NextToken</code> with the value of the copied
         * string. Repeat as needed to view all your results.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> is present in your response, it indicates that not all results are
         *        displayed. To view the next set of results, copy the string associated with the <code>NextToken</code>
         *        parameter in your results output, then run your request again including <code>NextToken</code> with
         *        the value of the copied string. Repeat as needed to view all your results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Provides a summary of information about each result.
         * </p>
         * 
         * @param medicalTranscriptionJobSummaries
         *        Provides a summary of information about each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalTranscriptionJobSummaries(Collection<MedicalTranscriptionJobSummary> medicalTranscriptionJobSummaries);

        /**
         * <p>
         * Provides a summary of information about each result.
         * </p>
         * 
         * @param medicalTranscriptionJobSummaries
         *        Provides a summary of information about each result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medicalTranscriptionJobSummaries(MedicalTranscriptionJobSummary... medicalTranscriptionJobSummaries);

        /**
         * <p>
         * Provides a summary of information about each result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #medicalTranscriptionJobSummaries(List<MedicalTranscriptionJobSummary>)}.
         * 
         * @param medicalTranscriptionJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribe.model.MedicalTranscriptionJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #medicalTranscriptionJobSummaries(java.util.Collection<MedicalTranscriptionJobSummary>)
         */
        Builder medicalTranscriptionJobSummaries(
                Consumer<MedicalTranscriptionJobSummary.Builder>... medicalTranscriptionJobSummaries);
    }

    static final class BuilderImpl extends TranscribeResponse.BuilderImpl implements Builder {
        private String status;

        private String nextToken;

        private List<MedicalTranscriptionJobSummary> medicalTranscriptionJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMedicalTranscriptionJobsResponse model) {
            super(model);
            status(model.status);
            nextToken(model.nextToken);
            medicalTranscriptionJobSummaries(model.medicalTranscriptionJobSummaries);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TranscriptionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MedicalTranscriptionJobSummary.Builder> getMedicalTranscriptionJobSummaries() {
            List<MedicalTranscriptionJobSummary.Builder> result = MedicalTranscriptionJobSummariesCopier
                    .copyToBuilder(this.medicalTranscriptionJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMedicalTranscriptionJobSummaries(
                Collection<MedicalTranscriptionJobSummary.BuilderImpl> medicalTranscriptionJobSummaries) {
            this.medicalTranscriptionJobSummaries = MedicalTranscriptionJobSummariesCopier
                    .copyFromBuilder(medicalTranscriptionJobSummaries);
        }

        @Override
        public final Builder medicalTranscriptionJobSummaries(
                Collection<MedicalTranscriptionJobSummary> medicalTranscriptionJobSummaries) {
            this.medicalTranscriptionJobSummaries = MedicalTranscriptionJobSummariesCopier.copy(medicalTranscriptionJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medicalTranscriptionJobSummaries(MedicalTranscriptionJobSummary... medicalTranscriptionJobSummaries) {
            medicalTranscriptionJobSummaries(Arrays.asList(medicalTranscriptionJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medicalTranscriptionJobSummaries(
                Consumer<MedicalTranscriptionJobSummary.Builder>... medicalTranscriptionJobSummaries) {
            medicalTranscriptionJobSummaries(Stream.of(medicalTranscriptionJobSummaries)
                    .map(c -> MedicalTranscriptionJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMedicalTranscriptionJobsResponse build() {
            return new ListMedicalTranscriptionJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
