/*
 * Decompiled with CFR 0.152.
 */
package com.virtuslab.using_directives.reporter;

import com.virtuslab.using_directives.custom.utils.Position;
import com.virtuslab.using_directives.reporter.Reporter;
import java.util.ArrayList;
import java.util.Optional;

public class PersistentReporter
implements Reporter {
    private ArrayList<Diagnostic> diagnostics = new ArrayList();

    @Override
    public void error(String msg) {
        this.diagnostics.add(new Diagnostic(msg, true));
    }

    @Override
    public void warning(String msg) {
        this.diagnostics.add(new Diagnostic(msg, false));
    }

    @Override
    public void error(Position position, String msg) {
        this.diagnostics.add(new Diagnostic(msg, true, position));
    }

    @Override
    public void warning(Position position, String msg) {
        this.diagnostics.add(new Diagnostic(msg, false, position));
    }

    @Override
    public boolean hasErrors() {
        return this.diagnostics.stream().filter(d -> ((Diagnostic)d).isError).count() > 0L;
    }

    @Override
    public boolean hasWarnings() {
        return this.diagnostics.stream().filter(d -> !((Diagnostic)d).isError).count() > 0L;
    }

    @Override
    public void reset() {
        this.diagnostics = new ArrayList();
    }

    public ArrayList<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public static class Diagnostic {
        private Optional<Position> position;
        private String message;
        private boolean isError;

        public Diagnostic(String message, Boolean isError, Position position) {
            this.position = Optional.of(position);
            this.isError = isError;
            this.message = message;
        }

        public Diagnostic(String message, Boolean isError) {
            this.position = Optional.empty();
            this.isError = isError;
            this.message = message;
        }

        public Optional<Position> getPosition() {
            return this.position;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

