/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import coursierapi.Dependency;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import mdoc.Reporter;
import mdoc.internal.cli.Context;
import mdoc.internal.cli.Feedback$;
import mdoc.internal.cli.Settings;
import mdoc.internal.io.ConsoleReporter$;
import mdoc.internal.markdown.MarkdownBuilder$;
import mdoc.internal.markdown.MarkdownCompiler;
import metaconfig.ConfError;
import metaconfig.ConfError$;
import metaconfig.Configured;
import metaconfig.Configured$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.deriving.Mirror;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;

public final class Context$
implements Mirror.Product,
Serializable {
    public static final Context$ MODULE$ = new Context$();

    private Context$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Context$.class);
    }

    public Context apply(Settings settings, Reporter reporter, MarkdownCompiler compiler, Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler> compilers) {
        return new Context(settings, reporter, compiler, compilers);
    }

    public Context unapply(Context x$1) {
        return x$1;
    }

    public Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler> $lessinit$greater$default$4() {
        return (Map)Map$.MODULE$.empty();
    }

    public Configured<Context> fromSettings(Settings settings, Reporter reporter) {
        if (settings.in().isEmpty()) {
            return Configured$.MODULE$.error(Feedback$.MODULE$.mustBeNonEmpty("in"));
        }
        if (settings.out().isEmpty()) {
            return Configured$.MODULE$.error(Feedback$.MODULE$.mustBeNonEmpty("out"));
        }
        if (settings.in().length() != settings.out().length()) {
            return Configured$.MODULE$.error(Feedback$.MODULE$.inputDifferentLengthOutput(settings.in(), settings.out()));
        }
        List errors = settings.outputByInput().iterator().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                AbsolutePath input = (AbsolutePath)tuple2._1();
                AbsolutePath output = (AbsolutePath)tuple2._2();
                return MODULE$.validateInputOutputPair(settings, input, output);
            }
            throw new MatchError((Object)tuple2);
        }).toList();
        List list = (List)errors.flatten(Predef$.MODULE$.$conforms());
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            Context context = this.fromOptions(settings, reporter);
            settings.onLoad(reporter);
            if (reporter.hasErrors()) {
                return Configured$.MODULE$.error("Failed to load modifiers");
            }
            return Configured$.MODULE$.ok((Object)context);
        }
        List errors2 = list;
        return ((ConfError)errors2.foldLeft((Object)ConfError$.MODULE$.empty(), (Function2 & Serializable)(_$2, _$3) -> _$2.combine(_$3))).notOk();
    }

    private boolean assumedRegularFile(Settings settings, AbsolutePath absPath) {
        String extension = PathIO$.MODULE$.extension(absPath.toNIO());
        return settings.markdownExtensions().toSet().contains((Object)extension);
    }

    private Option<ConfError> validateInputOutputPair(Settings settings, AbsolutePath input, AbsolutePath output) {
        if (!Files.exists(input.toNIO(), new LinkOption[0])) {
            return Some$.MODULE$.apply((Object)ConfError$.MODULE$.fileDoesNotExist(input.toNIO()));
        }
        AbsolutePath absolutePath = input;
        AbsolutePath absolutePath2 = output;
        if (!(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null)) {
            return Some$.MODULE$.apply((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.inputEqualOutput(input)));
        }
        if (output.toNIO().startsWith(input.toNIO()) && !this.assumedRegularFile(settings, output)) {
            return Some$.MODULE$.apply((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outSubdirectoryOfIn(input.toNIO(), output.toNIO())));
        }
        if (input.isFile() && output.isDirectory()) {
            return Some$.MODULE$.apply((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outputCannotBeDirectory(input, output)));
        }
        if (input.isDirectory() && output.isFile()) {
            return Some$.MODULE$.apply((Object)ConfError$.MODULE$.message(Feedback$.MODULE$.outputCannotBeRegularFile(input, output)));
        }
        return None$.MODULE$;
    }

    public Context fromCompiler(Settings options, Reporter reporter, MarkdownCompiler compiler) {
        return new Context(options, reporter, compiler, this.$lessinit$greater$default$4());
    }

    public Context fromOptions(Settings options, Reporter reporter) {
        MarkdownCompiler compiler = MarkdownBuilder$.MODULE$.fromClasspath(options.classpath(), options.scalacOptions());
        return this.fromCompiler(options, reporter, compiler);
    }

    public Reporter fromOptions$default$2() {
        return ConsoleReporter$.MODULE$.default();
    }

    public Context fromProduct(Product x$0) {
        return new Context((Settings)x$0.productElement(0), (Reporter)x$0.productElement(1), (MarkdownCompiler)x$0.productElement(2), (Map<Tuple2<Set<Dependency>, List<String>>, MarkdownCompiler>)((Map)x$0.productElement(3)));
    }
}

