/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import sbt.internal.FullScalaLoader;
import sbt.internal.JLineLoader;
import sbt.internal.SbtInterfaceLoader;
import sbt.internal.ScalaLibraryClassLoader;
import xsbti.AppProvider;
import xsbti.ScalaProvider;

public final class MetaBuildLoader
extends URLClassLoader {
    private final URLClassLoader fullScalaLoader;
    private final URLClassLoader libraryLoader;
    private final URLClassLoader interfaceLoader;
    private final URLClassLoader jlineLoader;

    MetaBuildLoader(URL[] urls, URLClassLoader fullScalaLoader, URLClassLoader libraryLoader, URLClassLoader interfaceLoader, URLClassLoader jlineLoader) {
        super(urls, (ClassLoader)fullScalaLoader);
        this.fullScalaLoader = fullScalaLoader;
        this.libraryLoader = libraryLoader;
        this.interfaceLoader = interfaceLoader;
        this.jlineLoader = jlineLoader;
    }

    public String toString() {
        return "SbtMetaBuildClassLoader";
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fullScalaLoader.close();
        this.libraryLoader.close();
        this.interfaceLoader.close();
        this.jlineLoader.close();
    }

    public static MetaBuildLoader makeLoader(AppProvider appProvider) throws IOException {
        String jlineJars = "jline-?[0-9.]+-sbt-.*|jline-terminal(-(jna|jansi))?-[0-9.]+";
        String testInterfaceJars = "test-interface(-.*)?";
        String compilerInterfaceJars = "compiler-interface(-.*)?";
        String utilInterfaceJars = "util-interface(-.*)?";
        String jansiJars = "jansi-[0-9.]+";
        String jnaJars = "jna-(platform-)?[0-9.]+";
        String fullPattern = String.format("^(%s|%s|%s|%s|%s|%s)\\.jar", "jline-?[0-9.]+-sbt-.*|jline-terminal(-(jna|jansi))?-[0-9.]+", "test-interface(-.*)?", "compiler-interface(-.*)?", "util-interface(-.*)?", "jansi-[0-9.]+", "jna-(platform-)?[0-9.]+");
        Pattern pattern = Pattern.compile(fullPattern);
        File[] cp = appProvider.mainClasspath();
        URL[] interfaceURLs = new URL[3];
        URL[] jlineURLs = new URL[7];
        File[] extra = appProvider.id().classpathExtra() == null ? new File[]{} : appProvider.id().classpathExtra();
        LinkedHashSet<File> bottomClasspath = new LinkedHashSet<File>();
        int interfaceIndex = 0;
        int jlineIndex = 0;
        for (File file : cp) {
            String name = file.getName();
            if ((name.contains("test-interface") || name.contains("compiler-interface") || name.contains("util-interface")) && pattern.matcher(name).find()) {
                interfaceURLs[interfaceIndex] = file.toURI().toURL();
                ++interfaceIndex;
                continue;
            }
            if (pattern.matcher(name).find()) {
                jlineURLs[jlineIndex] = file.toURI().toURL();
                ++jlineIndex;
                continue;
            }
            bottomClasspath.add(file);
        }
        for (File file : extra) {
            bottomClasspath.add(file);
        }
        URL[] rest = new URL[bottomClasspath.size()];
        int i = 0;
        for (File file : bottomClasspath) {
            rest[i] = file.toURI().toURL();
            ++i;
        }
        ScalaProvider scalaProvider = appProvider.scalaProvider();
        ClassLoader topLoader = scalaProvider.launcher().topLoader();
        boolean foundSBTLoader = false;
        while (!foundSBTLoader && topLoader != null) {
            if (topLoader instanceof URLClassLoader) {
                for (URL u : ((URLClassLoader)topLoader).getURLs()) {
                    if (!u.toString().contains("test-interface")) continue;
                    topLoader = topLoader.getParent();
                    foundSBTLoader = true;
                }
            }
            if (foundSBTLoader) continue;
            topLoader = topLoader.getParent();
        }
        if (topLoader == null) {
            topLoader = scalaProvider.launcher().topLoader();
        }
        topLoader = new ClassLoader(topLoader){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.startsWith("org.fusesource")) {
                    throw new ClassNotFoundException(name);
                }
                return super.loadClass(name, resolve);
            }

            public String toString() {
                return "JansiExclusionClassLoader";
            }
        };
        SbtInterfaceLoader interfaceLoader = new SbtInterfaceLoader(interfaceURLs, topLoader);
        JLineLoader jlineLoader = new JLineLoader(jlineURLs, (ClassLoader)interfaceLoader);
        File[] siJars = scalaProvider.jars();
        URL[] lib = new URL[1];
        int scalaRestCount = siJars.length - 1;
        for (File file : siJars) {
            if (!pattern.matcher(file.getName()).find()) continue;
            --scalaRestCount;
        }
        URL[] scalaRest = new URL[Math.max(0, scalaRestCount)];
        int j = 0;
        for (int i2 = 0; i2 < siJars.length; ++i2) {
            File file;
            file = siJars[i2];
            if (file.getName().equals("scala-library.jar")) {
                lib[0] = file.toURI().toURL();
                continue;
            }
            if (pattern.matcher(file.getName()).find()) continue;
            scalaRest[j] = file.toURI().toURL();
            ++j;
        }
        assert (lib[0] != null) : "no scala-library.jar";
        ScalaLibraryClassLoader libraryLoader = new ScalaLibraryClassLoader(lib, (ClassLoader)jlineLoader);
        FullScalaLoader fullScalaLoader = new FullScalaLoader(scalaRest, libraryLoader);
        return new MetaBuildLoader(rest, fullScalaLoader, libraryLoader, interfaceLoader, jlineLoader);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

