/*
 * Decompiled with CFR 0.152.
 */
package play;

import com.typesafe.config.Config;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Provider;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.CoordinatedShutdown;
import play.Application;
import play.ApplicationLoader;
import play.BuiltInComponents;
import play.Environment;
import play.api.ApplicationLoader;
import play.api.Configuration;
import play.api.DefaultApplication;
import play.api.OptionalDevContext;
import play.api.OptionalSourceMapper;
import play.api.http.DefaultFileMimeTypesProvider;
import play.api.http.JavaCompatibleHttpRequestHandler;
import play.api.i18n.DefaultLangsProvider;
import play.api.inject.NewInstanceInjector$;
import play.api.inject.SimpleInjector;
import play.api.libs.Files;
import play.api.libs.Files$TemporaryFileReaperConfiguration$;
import play.api.libs.concurrent.ActorSystemProvider;
import play.api.libs.concurrent.CoordinatedShutdownProvider;
import play.api.libs.crypto.DefaultCSRFTokenSigner;
import play.api.libs.crypto.DefaultCookieSigner;
import play.api.mvc.request.DefaultRequestFactory;
import play.api.routing.Router;
import play.core.DefaultWebCommands;
import play.core.SourceMapper;
import play.core.WebCommands;
import play.core.j.JavaHandlerComponents;
import play.core.j.JavaHttpErrorHandlerAdapter;
import play.core.j.MappedJavaHandlerComponents;
import play.http.DefaultHttpErrorHandler;
import play.http.DefaultHttpFilters;
import play.http.HttpErrorHandler;
import play.http.HttpRequestHandler;
import play.i18n.Langs;
import play.inject.ApplicationLifecycle;
import play.libs.F;
import play.libs.Files;
import play.libs.crypto.CSRFTokenSigner;
import play.libs.crypto.CookieSigner;
import play.mvc.BodyParser;
import play.mvc.FileMimeTypes;
import scala.Option;
import scala.collection.immutable.Map$;
import scala.jdk.javaapi.OptionConverters;

public abstract class ContextBasedBuiltInComponents
implements BuiltInComponents {
    private final Supplier<Application> _application = F.LazySupplier.lazy(this::createApplication);
    private final Supplier<Langs> _langs = F.LazySupplier.lazy(this::createLangs);
    private final Supplier<FileMimeTypes> _fileMimeTypes = F.LazySupplier.lazy(this::createFileMimeTypes);
    private final Supplier<HttpRequestHandler> _httpRequestHandler = F.LazySupplier.lazy(this::createHttpRequestHandler);
    private final Supplier<ActorSystem> _actorSystem = F.LazySupplier.lazy(this::createActorSystem);
    private final Supplier<CoordinatedShutdown> _coordinatedShutdown = F.LazySupplier.lazy(this::createCoordinatedShutdown);
    private final Supplier<CookieSigner> _cookieSigner = F.LazySupplier.lazy(this::createCookieSigner);
    private final Supplier<CSRFTokenSigner> _csrfTokenSigner = F.LazySupplier.lazy(this::createCsrfTokenSigner);
    private final Supplier<Files.TemporaryFileCreator> _tempFileCreator = F.LazySupplier.lazy(this::createTempFileCreator);
    private final Supplier<HttpErrorHandler> _httpErrorHandler = F.LazySupplier.lazy(this::createHttpErrorHandler);
    private final Supplier<MappedJavaHandlerComponents> _javaHandlerComponents = F.LazySupplier.lazy(this::createJavaHandlerComponents);
    private final Supplier<WebCommands> _webCommands = F.LazySupplier.lazy(this::createWebCommands);

    public abstract ApplicationLoader.Context context();

    @Override
    public Config config() {
        return this.context().initialConfig();
    }

    @Override
    public Environment environment() {
        return this.context().environment();
    }

    @Override
    public Optional<SourceMapper> sourceMapper() {
        return this.devContext().map(ApplicationLoader.DevContext::sourceMapper);
    }

    @Override
    public Optional<ApplicationLoader.DevContext> devContext() {
        return this.context().devContext();
    }

    @Override
    public ApplicationLifecycle applicationLifecycle() {
        return this.context().applicationLifecycle();
    }

    @Override
    public WebCommands webCommands() {
        return this._webCommands.get();
    }

    private WebCommands createWebCommands() {
        return new DefaultWebCommands();
    }

    @Override
    public Application application() {
        return this._application.get();
    }

    private Application createApplication() {
        DefaultRequestFactory defaultRequestFactory = new DefaultRequestFactory(this.httpConfiguration());
        SimpleInjector simpleInjector = new SimpleInjector(NewInstanceInjector$.MODULE$, Map$.MODULE$.empty());
        return new DefaultApplication(this.environment().asScala(), this.applicationLifecycle().asScala(), simpleInjector, this.configuration(), defaultRequestFactory, this.httpRequestHandler().asScala(), this.scalaHttpErrorHandler(), this.actorSystem(), this.materializer(), this.coordinatedShutdown()).asJava();
    }

    @Override
    public Langs langs() {
        return this._langs.get();
    }

    private Langs createLangs() {
        return new DefaultLangsProvider(this.configuration()).get().asJava();
    }

    @Override
    public FileMimeTypes fileMimeTypes() {
        return this._fileMimeTypes.get();
    }

    private FileMimeTypes createFileMimeTypes() {
        return new DefaultFileMimeTypesProvider(this.httpConfiguration().fileMimeTypes()).get().asJava();
    }

    @Override
    public MappedJavaHandlerComponents javaHandlerComponents() {
        return this._javaHandlerComponents.get();
    }

    private MappedJavaHandlerComponents createJavaHandlerComponents() {
        MappedJavaHandlerComponents mappedJavaHandlerComponents = new MappedJavaHandlerComponents(this.actionCreator(), this.httpConfiguration(), this.executionContext(), this.javaContextComponents());
        return mappedJavaHandlerComponents.addBodyParser(BodyParser.Default.class, this::defaultBodyParser).addBodyParser(BodyParser.AnyContent.class, this::anyContentBodyParser).addBodyParser(BodyParser.Json.class, this::jsonBodyParser).addBodyParser(BodyParser.TolerantJson.class, this::tolerantJsonBodyParser).addBodyParser(BodyParser.Xml.class, this::xmlBodyParser).addBodyParser(BodyParser.TolerantXml.class, this::tolerantXmlBodyParser).addBodyParser(BodyParser.Text.class, this::textBodyParser).addBodyParser(BodyParser.TolerantText.class, this::tolerantTextBodyParser).addBodyParser(BodyParser.Bytes.class, this::bytesBodyParser).addBodyParser(BodyParser.Raw.class, this::rawBodyParser).addBodyParser(BodyParser.FormUrlEncoded.class, this::formUrlEncodedBodyParser).addBodyParser(BodyParser.MultipartFormData.class, this::multipartFormDataBodyParser).addBodyParser(BodyParser.Empty.class, this::emptyBodyParser);
    }

    @Override
    public HttpErrorHandler httpErrorHandler() {
        return this._httpErrorHandler.get();
    }

    private HttpErrorHandler createHttpErrorHandler() {
        return new DefaultHttpErrorHandler(this.config(), this.environment(), new OptionalSourceMapper((Option<SourceMapper>)OptionConverters.toScala(this.sourceMapper())), (Provider<Router>)((Provider)() -> this.router().asScala()));
    }

    @Override
    public HttpRequestHandler httpRequestHandler() {
        return this._httpRequestHandler.get();
    }

    private HttpRequestHandler createHttpRequestHandler() {
        DefaultHttpFilters defaultHttpFilters = new DefaultHttpFilters(this.httpFilters());
        JavaHttpErrorHandlerAdapter javaHttpErrorHandlerAdapter = new JavaHttpErrorHandlerAdapter(this.httpErrorHandler());
        return new JavaCompatibleHttpRequestHandler(this.webCommands(), new OptionalDevContext((Option<ApplicationLoader.DevContext>)OptionConverters.toScala(this.devContext())), (Provider<Router>)((Provider)() -> this.router().asScala()), (play.api.http.HttpErrorHandler)javaHttpErrorHandlerAdapter, this.httpConfiguration(), defaultHttpFilters.asScala(), (JavaHandlerComponents)this.javaHandlerComponents()).asJava();
    }

    @Override
    public ActorSystem actorSystem() {
        return this._actorSystem.get();
    }

    private ActorSystem createActorSystem() {
        return new ActorSystemProvider(this.environment().asScala(), this.configuration()).get();
    }

    @Override
    public CoordinatedShutdown coordinatedShutdown() {
        return this._coordinatedShutdown.get();
    }

    private CoordinatedShutdown createCoordinatedShutdown() {
        return new CoordinatedShutdownProvider(this.actorSystem(), this.applicationLifecycle().asScala()).get();
    }

    @Override
    public CookieSigner cookieSigner() {
        return this._cookieSigner.get();
    }

    private CookieSigner createCookieSigner() {
        DefaultCookieSigner defaultCookieSigner = new DefaultCookieSigner(this.httpConfiguration().secret());
        return new play.libs.crypto.DefaultCookieSigner(defaultCookieSigner);
    }

    @Override
    public CSRFTokenSigner csrfTokenSigner() {
        return this._csrfTokenSigner.get();
    }

    private CSRFTokenSigner createCsrfTokenSigner() {
        DefaultCSRFTokenSigner defaultCSRFTokenSigner = new DefaultCSRFTokenSigner(this.cookieSigner().asScala(), this.clock());
        return new play.libs.crypto.DefaultCSRFTokenSigner(defaultCSRFTokenSigner);
    }

    @Override
    public Files.TemporaryFileCreator tempFileCreator() {
        return this._tempFileCreator.get();
    }

    private Files.TemporaryFileCreator createTempFileCreator() {
        Configuration configuration = this.configuration();
        Files.DefaultTemporaryFileReaper defaultTemporaryFileReaper = new Files.DefaultTemporaryFileReaper(this.actorSystem(), Files$TemporaryFileReaperConfiguration$.MODULE$.fromConfiguration(configuration));
        return new Files.DefaultTemporaryFileCreator(this.applicationLifecycle().asScala(), defaultTemporaryFileReaper, configuration).asJava();
    }
}

