/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Locale;
import play.api.libs.json.BigDecimalParser$;
import play.api.libs.json.EnvReads$ArrayNodeReads$;
import play.api.libs.json.EnvReads$IsoDateReads$;
import play.api.libs.json.EnvReads$JsonNodeReads$;
import play.api.libs.json.EnvReads$ObjectNodeReads$;
import play.api.libs.json.EnvReads$TemporalParser$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsString;
import play.api.libs.json.JsString$;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.json.JsonParserSettings$;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.JsonValidationError$;
import play.api.libs.json.KeyReads$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.jackson.JacksonJson$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface EnvReads {
    public static void $init$(EnvReads $this) {
        $this.play$api$libs$json$EnvReads$_setter_$DefaultDateReads_$eq($this.dateReads("yyyy-MM-dd", $this.dateReads$default$2()));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultSqlDateReads_$eq($this.sqlDateReads("yyyy-MM-dd", $this.sqlDateReads$default$2()));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultLocalDateTimeReads_$eq($this.localDateTimeReads(DateTimeFormatter.ISO_DATE_TIME, $this.localDateTimeReads$default$2(), (Function1 & Serializable)formatter -> this.TemporalParser().LocalDateTimeFormatterParser((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultOffsetDateTimeReads_$eq($this.offsetDateTimeReads(DateTimeFormatter.ISO_OFFSET_DATE_TIME, $this.offsetDateTimeReads$default$2(), (Function1 & Serializable)formatter -> this.TemporalParser().OffsetDateTimeFormatterParser((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultZonedDateTimeReads_$eq($this.zonedDateTimeReads(DateTimeFormatter.ISO_DATE_TIME, $this.zonedDateTimeReads$default$2(), (Function1 & Serializable)formatter -> this.TemporalParser().ZonedDateTimeFormatterParser((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultLocalDateReads_$eq($this.localDateReads(DateTimeFormatter.ISO_DATE, $this.localDateReads$default$2(), (Function1 & Serializable)formatter -> this.TemporalParser().DateFormatterParser((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultInstantReads_$eq($this.instantReads(DateTimeFormatter.ISO_DATE_TIME, $this.instantReads$default$2(), (Function1 & Serializable)formatter -> this.TemporalParser().InstantFormatterParser((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultLocalTimeReads_$eq($this.localTimeReads(DateTimeFormatter.ISO_TIME, $this.localTimeReads$default$2(), (Function1 & Serializable)formatter -> this.TemporalParser().LocalTimeFormatterParser((DateTimeFormatter)formatter)));
        $this.play$api$libs$json$EnvReads$_setter_$ZoneIdReads_$eq(Reads$.MODULE$.apply((Function1 & Serializable)x$1 -> {
            JsResult<Nothing$> jsResult;
            JsValue jsValue = x$1;
            if (jsValue instanceof JsString) {
                String string;
                JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
                String s = string = jsString._1();
                try {
                    jsResult = JsSuccess$.MODULE$.apply(ZoneId.of(s), JsSuccess$.MODULE$.$lessinit$greater$default$2());
                }
                catch (DateTimeException dateTimeException) {
                    jsResult = JsError$.MODULE$.apply(JsonValidationError$.MODULE$.apply("error.expected.timezone", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                }
            } else {
                jsResult = JsError$.MODULE$.apply(JsonValidationError$.MODULE$.apply("error.expected.jsstring", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
            }
            return jsResult;
        }));
        $this.play$api$libs$json$EnvReads$_setter_$localeReads_$eq(Reads$.MODULE$.apply((Function1 & Serializable)_$2 -> _$2.validate(Reads$.MODULE$.StringReads()).flatMap((Function1 & Serializable)_$3 -> KeyReads$.MODULE$.LanguageTagReads().readKey((String)_$3))));
        $this.play$api$libs$json$EnvReads$_setter_$localeObjectReads_$eq(Reads$.MODULE$.apply((Function1 & Serializable)json -> EnvReads.base$1(json).flatMap((Function1 & Serializable)baseLocale -> JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)json), "attributes").validateOpt(Reads$.MODULE$.traversableReads(Set$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.StringReads())).flatMap((Function1 & Serializable)ats -> JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)json), "keywords").validateOpt(Reads$.MODULE$.mapReads((Reads)Reads$.MODULE$.StringReads())).flatMap((Function1 & Serializable)kws -> JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)json), "script").validateOpt(Reads$.MODULE$.StringReads()).flatMap((Function1 & Serializable)spt -> JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup((JsValue)json), "extension").validateOpt(Reads$.MODULE$.mapReads((Function1 & Serializable)s -> StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(s)) == 1 ? JsSuccess$.MODULE$.apply(BoxesRunTime.boxToCharacter((char)s.charAt(0)), JsSuccess$.MODULE$.$lessinit$greater$default$2()) : JsError$.MODULE$.apply("error.invalid.character"), (Reads)Reads$.MODULE$.StringReads())).map((Function1 & Serializable)ext -> {
            Locale.Builder builder = new Locale.Builder();
            builder.setLocale((Locale)baseLocale);
            ats.foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.foreach((Function1 & Serializable)_$5 -> builder.addUnicodeLocaleAttribute((String)_$5)));
            kws.foreach((Function1)(JProcedure1 & Serializable)_$6 -> _$6.foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String typ = (String)tuple2._2();
                    return builder.setUnicodeLocaleKeyword(key, typ);
                }
                throw new MatchError((Object)tuple2);
            }));
            ext.foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    char key = BoxesRunTime.unboxToChar((Object)tuple2._1());
                    String value = (String)tuple2._2();
                    return builder.setExtension(key, value);
                }
                throw new MatchError((Object)tuple2);
            }));
            spt.foreach((Function1 & Serializable)_$8 -> builder.setScript((String)_$8));
            return builder.build();
        })))))));
        $this.play$api$libs$json$EnvReads$_setter_$javaDurationMillisReads_$eq($this.javaDurationNumberReads(ChronoUnit.MILLIS));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultJavaDurationReads_$eq(Reads$.MODULE$.apply((Function1 & Serializable)x$1 -> {
            JsValue jsValue = x$1;
            if (jsValue instanceof JsString) {
                JsResult<Nothing$> jsResult;
                String string;
                JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
                String repr = string = jsString._1();
                try {
                    jsResult = JsSuccess$.MODULE$.apply(Duration.parse(repr), JsSuccess$.MODULE$.$lessinit$greater$default$2());
                }
                catch (DateTimeParseException dateTimeParseException) {
                    jsResult = JsError$.MODULE$.apply("error.invalid.duration");
                }
                return jsResult;
            }
            JsValue js = jsValue;
            return this.javaDurationMillisReads().reads(js);
        }));
        $this.play$api$libs$json$EnvReads$_setter_$javaPeriodDaysReads_$eq(Reads$.MODULE$.IntReads().map((Function1 & Serializable)x$0 -> EnvReads.$init$$$anonfun$11(BoxesRunTime.unboxToInt((Object)x$0))));
        $this.play$api$libs$json$EnvReads$_setter_$javaPeriodWeeksReads_$eq(Reads$.MODULE$.IntReads().map((Function1 & Serializable)x$0 -> EnvReads.$init$$$anonfun$12(BoxesRunTime.unboxToInt((Object)x$0))));
        $this.play$api$libs$json$EnvReads$_setter_$javaPeriodMonthsReads_$eq(Reads$.MODULE$.IntReads().map((Function1 & Serializable)x$0 -> EnvReads.$init$$$anonfun$13(BoxesRunTime.unboxToInt((Object)x$0))));
        $this.play$api$libs$json$EnvReads$_setter_$javaPeriodYearsReads_$eq(Reads$.MODULE$.IntReads().map((Function1 & Serializable)x$0 -> EnvReads.$init$$$anonfun$14(BoxesRunTime.unboxToInt((Object)x$0))));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultJavaPeriodReads_$eq(Reads$.MODULE$.apply((Function1 & Serializable)x$1 -> {
            JsValue jsValue = x$1;
            if (jsValue instanceof JsString) {
                JsResult<Nothing$> jsResult;
                String string;
                JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
                String repr = string = jsString._1();
                try {
                    jsResult = JsSuccess$.MODULE$.apply(Period.parse(repr), JsSuccess$.MODULE$.$lessinit$greater$default$2());
                }
                catch (DateTimeParseException dateTimeParseException) {
                    jsResult = JsError$.MODULE$.apply("error.invalid.stringPeriod");
                }
                return jsResult;
            }
            JsValue js = jsValue;
            return this.javaPeriodDaysReads().reads(js);
        }));
    }

    public static EnvReads$JsonNodeReads$ JsonNodeReads$(EnvReads $this) {
        return $this.JsonNodeReads();
    }

    default public EnvReads$JsonNodeReads$ JsonNodeReads() {
        return new EnvReads$JsonNodeReads$(this);
    }

    public static EnvReads$ObjectNodeReads$ ObjectNodeReads$(EnvReads $this) {
        return $this.ObjectNodeReads();
    }

    default public EnvReads$ObjectNodeReads$ ObjectNodeReads() {
        return new EnvReads$ObjectNodeReads$(this);
    }

    public static EnvReads$ArrayNodeReads$ ArrayNodeReads$(EnvReads $this) {
        return $this.ArrayNodeReads();
    }

    default public EnvReads$ArrayNodeReads$ ArrayNodeReads() {
        return new EnvReads$ArrayNodeReads$(this);
    }

    public static Reads dateReads$(EnvReads $this, String pattern, Function1 corrector) {
        return $this.dateReads(pattern, (Function1<String, String>)corrector);
    }

    default public Reads<java.util.Date> dateReads(String pattern, Function1<String, String> corrector) {
        return new Reads<java.util.Date>(pattern, corrector, this){
            private final String pattern$1;
            private final Function1 corrector$1;
            private final /* synthetic */ EnvReads $outer;
            {
                this.pattern$1 = pattern$2;
                this.corrector$1 = corrector$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public JsResult reads(JsValue json) {
                JsValue jsValue = json;
                if (jsValue instanceof JsNumber) {
                    JsNumber n = (JsNumber)jsValue;
                    return n.validate((Reads)Reads$.MODULE$.LongReads()).map(EnvReads::play$api$libs$json$EnvReads$$anon$1$$_$reads$$anonfun$adapted$1);
                }
                if (jsValue instanceof JsString) {
                    JsResult<java.util.Date> jsResult;
                    JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
                    String string = jsString._1();
                    String s = string;
                    Option<java.util.Date> option = this.$outer.play$api$libs$json$EnvReads$$parseJDate(this.pattern$1, (String)this.corrector$1.apply((Object)s));
                    if (option instanceof Some) {
                        java.util.Date d = (java.util.Date)((Some)option).value();
                        jsResult = JsSuccess$.MODULE$.apply(d, JsSuccess$.MODULE$.$lessinit$greater$default$2());
                    } else if (None$.MODULE$.equals(option)) {
                        Object[] objectArray = new Tuple2[1];
                        JsPath$ jsPath$ = (JsPath$)Predef$.MODULE$.ArrowAssoc((Object)JsPath$.MODULE$);
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsPath$, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date.isoformat", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.pattern$1}))})));
                        jsResult = JsError$.MODULE$.apply((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
                    } else {
                        throw new MatchError(option);
                    }
                    return jsResult;
                }
                Object[] objectArray = new Tuple2[1];
                JsPath$ jsPath$ = (JsPath$)Predef$.MODULE$.ArrowAssoc((Object)JsPath$.MODULE$);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsPath$, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))})));
                return JsError$.MODULE$.apply((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$api$libs$json$EnvReads$$anon$1$$_$reads$$anonfun$adapted$1(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public static Function1 dateReads$default$2$(EnvReads $this) {
        return $this.dateReads$default$2();
    }

    default public Function1<String, String> dateReads$default$2() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public static Option play$api$libs$json$EnvReads$$parseJDate$(EnvReads $this, String pattern, String input) {
        return $this.play$api$libs$json$EnvReads$$parseJDate(pattern, input);
    }

    default public Option<java.util.Date> play$api$libs$json$EnvReads$$parseJDate(String pattern, String input) {
        None$ none$;
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setLenient(false);
        try {
            none$ = Some$.MODULE$.apply((Object)df.parse(input));
        }
        catch (ParseException x) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Reads<java.util.Date> DefaultDateReads();

    public void play$api$libs$json$EnvReads$_setter_$DefaultDateReads_$eq(Reads var1);

    public static EnvReads$IsoDateReads$ IsoDateReads$(EnvReads $this) {
        return $this.IsoDateReads();
    }

    default public EnvReads$IsoDateReads$ IsoDateReads() {
        return new EnvReads$IsoDateReads$(this);
    }

    public static Reads sqlDateReads$(EnvReads $this, String pattern, Function1 corrector) {
        return $this.sqlDateReads(pattern, (Function1<String, String>)corrector);
    }

    default public Reads<Date> sqlDateReads(String pattern, Function1<String, String> corrector) {
        return this.dateReads(pattern, corrector).map((Function1 & Serializable)d -> new Date(d.getTime()));
    }

    public static Function1 sqlDateReads$default$2$(EnvReads $this) {
        return $this.sqlDateReads$default$2();
    }

    default public Function1<String, String> sqlDateReads$default$2() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public Reads<Date> DefaultSqlDateReads();

    public void play$api$libs$json$EnvReads$_setter_$DefaultSqlDateReads_$eq(Reads var1);

    public static EnvReads$TemporalParser$ TemporalParser$(EnvReads $this) {
        return $this.TemporalParser();
    }

    default public EnvReads$TemporalParser$ TemporalParser() {
        return new EnvReads$TemporalParser$(this);
    }

    public static Reads localDateTimeReads$(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return $this.localDateTimeReads(parsing, (Function1<String, String>)corrector, p);
    }

    default public <T> Reads<LocalDateTime> localDateTimeReads(T parsing, Function1<String, String> corrector, Function1<T, TemporalParser<LocalDateTime>> p) {
        return new TemporalReads<T, LocalDateTime>(parsing, corrector, p, (Function1 & Serializable)millis -> EnvReads.localDateTimeReads$$anonfun$1(BoxesRunTime.unboxToLong((Object)millis)));
    }

    public static Function1 localDateTimeReads$default$2$(EnvReads $this) {
        return $this.localDateTimeReads$default$2();
    }

    default public <T> Function1<String, String> localDateTimeReads$default$2() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public Reads<LocalDateTime> DefaultLocalDateTimeReads();

    public void play$api$libs$json$EnvReads$_setter_$DefaultLocalDateTimeReads_$eq(Reads var1);

    public static Reads offsetDateTimeReads$(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return $this.offsetDateTimeReads(parsing, (Function1<String, String>)corrector, p);
    }

    default public <T> Reads<OffsetDateTime> offsetDateTimeReads(T parsing, Function1<String, String> corrector, Function1<T, TemporalParser<OffsetDateTime>> p) {
        return new Reads<OffsetDateTime>(p, parsing, corrector){
            private final Function1 p$1;
            private final Object parsing$1;
            private final Function1 corrector$2;
            {
                this.p$1 = p$4;
                this.parsing$1 = parsing$4;
                this.corrector$2 = corrector$6;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public JsResult reads(JsValue json) {
                JsResult<OffsetDateTime> jsResult;
                JsValue jsValue = json;
                if (jsValue instanceof JsString) {
                    String string;
                    JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
                    String s = string = jsString._1();
                    Option<T> option = ((TemporalParser)this.p$1.apply(this.parsing$1)).parse((String)this.corrector$2.apply((Object)s));
                    if (option instanceof Some) {
                        OffsetDateTime d = (OffsetDateTime)((Some)option).value();
                        jsResult = JsSuccess$.MODULE$.apply(d, JsSuccess$.MODULE$.$lessinit$greater$default$2());
                        return jsResult;
                    } else {
                        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        Object[] objectArray = new Tuple2[1];
                        JsPath$ jsPath$ = (JsPath$)Predef$.MODULE$.ArrowAssoc((Object)JsPath$.MODULE$);
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsPath$, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date.isoformat", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.parsing$1}))})));
                        jsResult = JsError$.MODULE$.apply((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
                    }
                    return jsResult;
                } else {
                    Object[] objectArray = new Tuple2[1];
                    JsPath$ jsPath$ = (JsPath$)Predef$.MODULE$.ArrowAssoc((Object)JsPath$.MODULE$);
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsPath$, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))})));
                    jsResult = JsError$.MODULE$.apply((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
                }
                return jsResult;
            }
        };
    }

    public static Function1 offsetDateTimeReads$default$2$(EnvReads $this) {
        return $this.offsetDateTimeReads$default$2();
    }

    default public <T> Function1<String, String> offsetDateTimeReads$default$2() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public Reads<OffsetDateTime> DefaultOffsetDateTimeReads();

    public void play$api$libs$json$EnvReads$_setter_$DefaultOffsetDateTimeReads_$eq(Reads var1);

    public static Reads zonedDateTimeReads$(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return $this.zonedDateTimeReads(parsing, (Function1<String, String>)corrector, p);
    }

    default public <T> Reads<ZonedDateTime> zonedDateTimeReads(T parsing, Function1<String, String> corrector, Function1<T, TemporalParser<ZonedDateTime>> p) {
        return new TemporalReads<T, ZonedDateTime>(parsing, corrector, p, (Function1 & Serializable)millis -> EnvReads.zonedDateTimeReads$$anonfun$1(BoxesRunTime.unboxToLong((Object)millis)));
    }

    public static Function1 zonedDateTimeReads$default$2$(EnvReads $this) {
        return $this.zonedDateTimeReads$default$2();
    }

    default public <T> Function1<String, String> zonedDateTimeReads$default$2() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public Reads<ZonedDateTime> DefaultZonedDateTimeReads();

    public void play$api$libs$json$EnvReads$_setter_$DefaultZonedDateTimeReads_$eq(Reads var1);

    public static Reads localDateReads$(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return $this.localDateReads(parsing, (Function1<String, String>)corrector, p);
    }

    default public <T> Reads<LocalDate> localDateReads(T parsing, Function1<String, String> corrector, Function1<T, TemporalParser<LocalDate>> p) {
        return new Reads<LocalDate>(p, parsing, corrector){
            private final Function1 p$2;
            private final Object parsing$2;
            private final Function1 corrector$3;
            {
                this.p$2 = p$5;
                this.parsing$2 = parsing$5;
                this.corrector$3 = corrector$7;
            }

            public JsResult reads(JsValue json) {
                JsValue jsValue = json;
                if (jsValue instanceof JsNumber) {
                    JsNumber n = (JsNumber)jsValue;
                    return n.validate((Reads)Reads$.MODULE$.LongReads()).map((Function1 & Serializable)millis -> this.reads$$anonfun$5(BoxesRunTime.unboxToLong((Object)millis)));
                }
                if (jsValue instanceof JsString) {
                    JsResult<LocalDate> jsResult;
                    String string;
                    JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
                    String s = string = jsString._1();
                    Option<T> option = ((TemporalParser)this.p$2.apply(this.parsing$2)).parse((String)this.corrector$3.apply((Object)s));
                    if (option instanceof Some) {
                        LocalDate d = (LocalDate)((Some)option).value();
                        jsResult = JsSuccess$.MODULE$.apply(d, JsSuccess$.MODULE$.$lessinit$greater$default$2());
                    } else {
                        Object[] objectArray = new Tuple2[1];
                        JsPath$ jsPath$ = (JsPath$)Predef$.MODULE$.ArrowAssoc((Object)JsPath$.MODULE$);
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsPath$, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date.isoformat", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.parsing$2}))})));
                        jsResult = JsError$.MODULE$.apply((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
                    }
                    return jsResult;
                }
                Object[] objectArray = new Tuple2[1];
                JsPath$ jsPath$ = (JsPath$)Predef$.MODULE$.ArrowAssoc((Object)JsPath$.MODULE$);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsPath$, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))})));
                return JsError$.MODULE$.apply((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
            }

            public LocalDate epoch(long millis) {
                return LocalDate.now(Clock.fixed(Instant.ofEpochMilli(millis), ZoneOffset.UTC));
            }

            private final /* synthetic */ LocalDate reads$$anonfun$5(long millis) {
                return this.epoch(millis);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{reads$$anonfun$adapted$3(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public static Function1 localDateReads$default$2$(EnvReads $this) {
        return $this.localDateReads$default$2();
    }

    default public <T> Function1<String, String> localDateReads$default$2() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public Reads<LocalDate> DefaultLocalDateReads();

    public void play$api$libs$json$EnvReads$_setter_$DefaultLocalDateReads_$eq(Reads var1);

    public static Reads instantReads$(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return $this.instantReads(parsing, (Function1<String, String>)corrector, p);
    }

    default public <T> Reads<Instant> instantReads(T parsing, Function1<String, String> corrector, Function1<T, TemporalParser<Instant>> p) {
        return new TemporalReads<T, Instant>(parsing, corrector, p, (Function1 & Serializable)_$1 -> EnvReads.instantReads$$anonfun$1(BoxesRunTime.unboxToLong((Object)_$1)));
    }

    public static Function1 instantReads$default$2$(EnvReads $this) {
        return $this.instantReads$default$2();
    }

    default public <T> Function1<String, String> instantReads$default$2() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public Reads<Instant> DefaultInstantReads();

    public void play$api$libs$json$EnvReads$_setter_$DefaultInstantReads_$eq(Reads var1);

    public static Reads localTimeReads$(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return $this.localTimeReads(parsing, (Function1<String, String>)corrector, p);
    }

    default public <T> Reads<LocalTime> localTimeReads(T parsing, Function1<String, String> corrector, Function1<T, TemporalParser<LocalTime>> p) {
        return new Reads<LocalTime>(p, parsing, corrector){
            private final Function1 p$3;
            private final Object parsing$3;
            private final Function1 corrector$4;
            {
                this.p$3 = p$6;
                this.parsing$3 = parsing$6;
                this.corrector$4 = corrector$8;
            }

            public JsResult reads(JsValue json) {
                JsValue jsValue = json;
                if (jsValue instanceof JsNumber) {
                    JsNumber n = (JsNumber)jsValue;
                    return n.validate((Reads)Reads$.MODULE$.LongReads()).map((Function1 & Serializable)nanos -> this.reads$$anonfun$6(BoxesRunTime.unboxToLong((Object)nanos)));
                }
                if (jsValue instanceof JsString) {
                    JsResult<LocalTime> jsResult;
                    String string;
                    JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
                    String s = string = jsString._1();
                    Option<T> option = ((TemporalParser)this.p$3.apply(this.parsing$3)).parse((String)this.corrector$4.apply((Object)s));
                    if (option instanceof Some) {
                        LocalTime d = (LocalTime)((Some)option).value();
                        jsResult = JsSuccess$.MODULE$.apply(d, JsSuccess$.MODULE$.$lessinit$greater$default$2());
                    } else {
                        Object[] objectArray = new Tuple2[1];
                        JsPath$ jsPath$ = (JsPath$)Predef$.MODULE$.ArrowAssoc((Object)JsPath$.MODULE$);
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsPath$, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date.isoformat", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.parsing$3}))})));
                        jsResult = JsError$.MODULE$.apply((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
                    }
                    return jsResult;
                }
                Object[] objectArray = new Tuple2[1];
                JsPath$ jsPath$ = (JsPath$)Predef$.MODULE$.ArrowAssoc((Object)JsPath$.MODULE$);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsPath$, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))})));
                return JsError$.MODULE$.apply((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
            }

            public LocalTime epoch(long nanos) {
                return LocalTime.ofNanoOfDay(nanos);
            }

            private final /* synthetic */ LocalTime reads$$anonfun$6(long nanos) {
                return this.epoch(nanos);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{reads$$anonfun$adapted$4(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public static Function1 localTimeReads$default$2$(EnvReads $this) {
        return $this.localTimeReads$default$2();
    }

    default public <T> Function1<String, String> localTimeReads$default$2() {
        return (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
    }

    public Reads<LocalTime> DefaultLocalTimeReads();

    public void play$api$libs$json$EnvReads$_setter_$DefaultLocalTimeReads_$eq(Reads var1);

    public Reads<ZoneId> ZoneIdReads();

    public void play$api$libs$json$EnvReads$_setter_$ZoneIdReads_$eq(Reads var1);

    public Reads<Locale> localeReads();

    public void play$api$libs$json$EnvReads$_setter_$localeReads_$eq(Reads var1);

    public Reads<Locale> localeObjectReads();

    public void play$api$libs$json$EnvReads$_setter_$localeObjectReads_$eq(Reads var1);

    private Reads<Duration> jdurationNumberReads(TemporalUnit unit) {
        return Reads$.MODULE$.apply((Function1 & Serializable)x$1 -> {
            JsValue jsValue = x$1;
            if (jsValue instanceof JsNumber) {
                JsNumber n = (JsNumber)jsValue;
                return n.validate((Reads)Reads$.MODULE$.LongReads()).map((Function1 & Serializable)l -> EnvReads.jdurationNumberReads$$anonfun$1$$anonfun$1(unit, BoxesRunTime.unboxToLong((Object)l)));
            }
            return JsError$.MODULE$.apply("error.expected.longDuration");
        });
    }

    public static Reads javaDurationNumberReads$(EnvReads $this, TemporalUnit unit) {
        return $this.javaDurationNumberReads(unit);
    }

    default public Reads<Duration> javaDurationNumberReads(TemporalUnit unit) {
        return this.jdurationNumberReads(unit);
    }

    public Reads<Duration> javaDurationMillisReads();

    public void play$api$libs$json$EnvReads$_setter_$javaDurationMillisReads_$eq(Reads var1);

    public Reads<Duration> DefaultJavaDurationReads();

    public void play$api$libs$json$EnvReads$_setter_$DefaultJavaDurationReads_$eq(Reads var1);

    public Reads<Period> javaPeriodDaysReads();

    public void play$api$libs$json$EnvReads$_setter_$javaPeriodDaysReads_$eq(Reads var1);

    public Reads<Period> javaPeriodWeeksReads();

    public void play$api$libs$json$EnvReads$_setter_$javaPeriodWeeksReads_$eq(Reads var1);

    public Reads<Period> javaPeriodMonthsReads();

    public void play$api$libs$json$EnvReads$_setter_$javaPeriodMonthsReads_$eq(Reads var1);

    public Reads<Period> javaPeriodYearsReads();

    public void play$api$libs$json$EnvReads$_setter_$javaPeriodYearsReads_$eq(Reads var1);

    public Reads<Period> DefaultJavaPeriodReads();

    public void play$api$libs$json$EnvReads$_setter_$DefaultJavaPeriodReads_$eq(Reads var1);

    public static JsResult parseBigDecimal$(EnvReads $this, String input) {
        return $this.parseBigDecimal(input);
    }

    default public JsResult<BigDecimal> parseBigDecimal(String input) {
        return BigDecimalParser$.MODULE$.parse(input, JsonParserSettings$.MODULE$.settings());
    }

    public static JsResult parseBigInteger$(EnvReads $this, String input) {
        return $this.parseBigInteger(input);
    }

    default public JsResult<BigInteger> parseBigInteger(String input) {
        JsResult<BigInteger> jsResult;
        if (input.length() > JsonParserSettings$.MODULE$.settings().bigDecimalParseSettings().digitsLimit()) {
            return JsError$.MODULE$.apply("error.expected.numberdigitlimit");
        }
        try {
            jsResult = JsSuccess$.MODULE$.apply(new BigInteger(input), JsSuccess$.MODULE$.$lessinit$greater$default$2());
        }
        catch (NumberFormatException numberFormatException) {
            jsResult = JsError$.MODULE$.apply(JsonValidationError$.MODULE$.apply("error.expected.numberformatexception", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
        }
        return jsResult;
    }

    private static JsResult base$1(JsValue json$1) {
        return JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(json$1), "language").validate(Reads$.MODULE$.StringReads()).flatMap((Function1 & Serializable)l -> JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(json$1), "country").validateOpt(Reads$.MODULE$.StringReads()).flatMap((Function1 & Serializable)c -> JsLookup$.MODULE$.$bslash$extension(JsValue$.MODULE$.jsValueToJsLookup(json$1), "variant").validateOpt(Reads$.MODULE$.StringReads()).map((Function1 & Serializable)v -> Tuple3$.MODULE$.apply(l, c, v)))).flatMap((Function1 & Serializable)x$1 -> {
            JsResult<Nothing$> jsResult;
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String string = (String)tuple3._1();
                Option option = (Option)tuple3._2();
                Option option2 = (Option)tuple3._3();
                String l = string;
                if (option instanceof Some) {
                    String string2;
                    String country = string2 = (String)((Some)option).value();
                    if (option2 instanceof Some) {
                        String variant = (String)((Some)option2).value();
                        jsResult = JsSuccess$.MODULE$.apply(new Locale(l, country, variant), JsSuccess$.MODULE$.$lessinit$greater$default$2());
                    } else {
                        String l2 = string;
                        String country2 = string2;
                        jsResult = JsSuccess$.MODULE$.apply(new Locale(l2, country2), JsSuccess$.MODULE$.$lessinit$greater$default$2());
                    }
                } else {
                    String l3 = string;
                    if (option2 instanceof Some) {
                        jsResult = JsError$.MODULE$.apply("error.invalid.locale");
                    } else {
                        String l4 = string;
                        jsResult = JsSuccess$.MODULE$.apply(new Locale(l4), JsSuccess$.MODULE$.$lessinit$greater$default$2());
                    }
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
            return jsResult;
        });
    }

    private static /* synthetic */ Period $init$$$anonfun$11(int x$0) {
        return Period.ofDays(x$0);
    }

    private static /* synthetic */ Period $init$$$anonfun$12(int x$0) {
        return Period.ofWeeks(x$0);
    }

    private static /* synthetic */ Period $init$$$anonfun$13(int x$0) {
        return Period.ofMonths(x$0);
    }

    private static /* synthetic */ Period $init$$$anonfun$14(int x$0) {
        return Period.ofYears(x$0);
    }

    public static /* synthetic */ ObjectNode play$api$libs$json$EnvReads$ObjectNodeReads$$$_$reads$$anonfun$1(JsObject jo) {
        return (ObjectNode)JacksonJson$.MODULE$.get().jsValueToJsonNode(jo);
    }

    public static /* synthetic */ ArrayNode play$api$libs$json$EnvReads$ArrayNodeReads$$$_$reads$$anonfun$2(JsArray ja) {
        return (ArrayNode)JacksonJson$.MODULE$.get().jsValueToJsonNode(ja);
    }

    private static /* synthetic */ java.util.Date reads$$anonfun$3(long l) {
        return new java.util.Date(l);
    }

    public static /* bridge */ /* synthetic */ java.util.Date play$api$libs$json$EnvReads$$anon$1$$_$reads$$anonfun$adapted$1(Object l) {
        return EnvReads.reads$$anonfun$3(BoxesRunTime.unboxToLong((Object)l));
    }

    private static /* synthetic */ java.util.Date reads$$anonfun$4(long l) {
        return new java.util.Date(l);
    }

    public static /* bridge */ /* synthetic */ java.util.Date play$api$libs$json$EnvReads$IsoDateReads$$$_$reads$$anonfun$adapted$2(Object l) {
        return EnvReads.reads$$anonfun$4(BoxesRunTime.unboxToLong((Object)l));
    }

    private static /* synthetic */ LocalDateTime localDateTimeReads$$anonfun$1(long millis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    private static /* synthetic */ ZonedDateTime zonedDateTimeReads$$anonfun$1(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    private static /* synthetic */ Instant instantReads$$anonfun$1(long _$1) {
        return Instant.ofEpochMilli(_$1);
    }

    private static /* synthetic */ Duration jdurationNumberReads$$anonfun$1$$anonfun$1(TemporalUnit unit$2, long l) {
        return Duration.of(l, unit$2);
    }

    public interface TemporalParser<T extends Temporal> {
        public Option<T> parse(String var1);
    }

    public final class TemporalReads<A, B extends Temporal>
    implements Reads<B> {
        private final A parsing;
        private final Function1<String, String> corrector;
        private final Function1<A, TemporalParser<B>> p;
        private final Function1<Object, B> epoch;

        public TemporalReads(A parsing, Function1<String, String> corrector, Function1<A, TemporalParser<B>> p, Function1<Object, B> epoch) {
            this.parsing = parsing;
            this.corrector = corrector;
            this.p = p;
            this.epoch = epoch;
        }

        @Override
        public JsResult<B> reads(JsValue json) {
            JsValue jsValue = json;
            if (jsValue instanceof JsNumber) {
                JsNumber n = (JsNumber)jsValue;
                return n.validate((Reads)Reads$.MODULE$.LongReads()).map(this.epoch);
            }
            if (jsValue instanceof JsString) {
                JsResult<Temporal> jsResult;
                String string;
                JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
                String s = string = jsString._1();
                Option option = ((TemporalParser)this.p.apply(this.parsing)).parse((String)this.corrector.apply((Object)s));
                if (option instanceof Some) {
                    Temporal d = (Temporal)((Some)option).value();
                    jsResult = JsSuccess$.MODULE$.apply(d, JsSuccess$.MODULE$.$lessinit$greater$default$2());
                } else if (None$.MODULE$.equals(option)) {
                    Object[] objectArray = new Tuple2[1];
                    JsPath$ jsPath$ = (JsPath$)Predef$.MODULE$.ArrowAssoc((Object)JsPath$.MODULE$);
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsPath$, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date.isoformat", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.parsing}))})));
                    jsResult = JsError$.MODULE$.apply((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
                } else {
                    throw new MatchError(option);
                }
                return jsResult;
            }
            Object[] objectArray = new Tuple2[1];
            JsPath$ jsPath$ = (JsPath$)Predef$.MODULE$.ArrowAssoc((Object)JsPath$.MODULE$);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jsPath$, (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))})));
            return JsError$.MODULE$.apply((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        }
    }
}

