/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.embedded_3;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.cli.resources.AddResources;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.embedded.ContainerBuilder;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.Server;
import org.jboss.arquillian.container.glassfish.embedded_3.GlassFishConfiguration;
import org.jboss.arquillian.protocol.servlet_3.ServletMethodExecutor;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.glassfish.api.ShrinkwrapReadableArchive;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishEmbeddedContainer
implements DeployableContainer {
    public static final String HTTP_PROTOCOL = "http";
    public static final String DEFAULT_ASADMIN_PARAM = "DEFAULT";
    private static final Logger log = Logger.getLogger(GlassFishEmbeddedContainer.class.getName());
    private String target = "server";
    private Server server;
    private GlassFishConfiguration containerConfig;

    public void setup(Context context, Configuration arquillianConfig) {
        this.containerConfig = (GlassFishConfiguration)arquillianConfig.getContainerConfig(GlassFishConfiguration.class);
        Server.Builder serverBuilder = new Server.Builder("arquillian-" + System.currentTimeMillis());
        EmbeddedFileSystem.Builder embeddedFsBuilder = new EmbeddedFileSystem.Builder().instanceRoot(new File(this.containerConfig.getInstanceRoot())).autoDelete(this.containerConfig.isAutoDelete());
        if (this.containerConfig.getDomainXml() != null) {
            File domainXmlFile = new File(this.containerConfig.getDomainXml());
            if (!domainXmlFile.exists() || !domainXmlFile.isFile()) {
                throw new RuntimeException("File specified in domainXml configuration property does not exist: " + domainXmlFile.getAbsolutePath());
            }
            embeddedFsBuilder.configurationFile(domainXmlFile);
        }
        this.server = serverBuilder.embeddedFileSystem(embeddedFsBuilder.build()).build();
        this.server.addContainer(ContainerBuilder.Type.all);
        if (this.containerConfig.getSunResourcesXml() != null) {
            File resourcesXmlFile = new File(this.containerConfig.getSunResourcesXml());
            if (!resourcesXmlFile.exists() || !resourcesXmlFile.isFile()) {
                throw new RuntimeException("File specified in sunResourcesXml configuration property does not exist: " + resourcesXmlFile.getAbsolutePath());
            }
            try {
                File resourcesDtd = new File(this.server.getFileSystem().instanceRoot, "lib/dtds/sun-resources_1_4.dtd");
                if (!resourcesDtd.exists()) {
                    resourcesDtd.getParentFile().mkdirs();
                    GlassFishEmbeddedContainer.copyWithClose(this.getClass().getClassLoader().getResourceAsStream("META-INF/sun-resources_1_4.dtd"), new FileOutputStream(resourcesDtd));
                }
                ParameterMap params = new ParameterMap();
                params.add((Object)DEFAULT_ASADMIN_PARAM, (Object)this.containerConfig.getSunResourcesXml());
                this.executeCommand(AddResources.class.getAnnotation(Service.class).name(), this.server, params);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void start(Context context) throws LifecycleException {
        try {
            this.server.createPort(this.containerConfig.getBindHttpPort());
            this.server.start();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    public void stop(Context context) throws LifecycleException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        try {
            DeployCommandParameters params = new DeployCommandParameters();
            params.enabled = true;
            params.target = this.target;
            params.name = this.createDeploymentName(archive.getName());
            this.server.getDeployer().deploy((ReadableArchive)archive.as(ShrinkwrapReadableArchive.class), params);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + archive.getName(), (Throwable)e);
        }
        try {
            return new ServletMethodExecutor(new URL(HTTP_PROTOCOL, "localhost", this.containerConfig.getBindHttpPort(), "/"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create ContainerMethodExecutor", e);
        }
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        UndeployCommandParameters params = new UndeployCommandParameters();
        params.target = this.target;
        params.name = this.createDeploymentName(archive.getName());
        try {
            this.server.getDeployer().undeploy(params.name, params);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy " + archive.getName(), (Throwable)e);
        }
    }

    private String createDeploymentName(String archiveName) {
        return archiveName.substring(0, archiveName.lastIndexOf("."));
    }

    private void executeCommand(String command, Server server, ParameterMap params) throws Throwable {
        CommandRunner runner = (CommandRunner)server.getHabitat().getComponent(CommandRunner.class);
        ActionReport report = (ActionReport)server.getHabitat().getComponent(ActionReport.class);
        CommandRunner.CommandInvocation invocation = runner.getCommandInvocation(command, report);
        if (params != null) {
            invocation.parameters(params);
        }
        invocation.execute();
        if (report.hasFailures()) {
            throw report.getFailureCause();
        }
        int i = 1;
        for (ActionReport.MessagePart part : report.getTopMessagePart().getChildren()) {
            log.info(command + " command result (" + i++ + "): " + part.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyWithClose(InputStream input, OutputStream output) throws IOException {
        try {
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
            output.flush();
        }
        finally {
            block14: {
                block13: {
                    try {
                        input.close();
                    }
                    catch (IOException ignore) {
                        if (!log.isLoggable(Level.FINER)) break block13;
                        log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                    }
                }
                try {
                    output.close();
                }
                catch (IOException ignore) {
                    if (!log.isLoggable(Level.FINER)) break block14;
                    log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                }
            }
        }
    }
}

