/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.kernel.Async;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.server.staticcontent.CacheStrategy;
import org.http4s.server.staticcontent.WebjarServiceBuilder$;
import org.http4s.server.staticcontent.WebjarServiceBuilder$BadTraversal$2$;
import org.http4s.server.staticcontent.WebjarServiceBuilder$WebjarAsset$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class WebjarServiceBuilder<F> {
    private final Function1<WebjarAsset, Object> webjarAssetFilter;
    private final CacheStrategy<F> cacheStrategy;
    private final Option<ClassLoader> classLoader;
    private final boolean preferGzipped;

    public static <F> WebjarServiceBuilder<F> apply() {
        return WebjarServiceBuilder$.MODULE$.apply();
    }

    public WebjarServiceBuilder(Function1<WebjarAsset, Object> webjarAssetFilter, CacheStrategy<F> cacheStrategy, Option<ClassLoader> classLoader, boolean preferGzipped) {
        this.webjarAssetFilter = webjarAssetFilter;
        this.cacheStrategy = cacheStrategy;
        this.classLoader = classLoader;
        this.preferGzipped = preferGzipped;
    }

    private WebjarServiceBuilder<F> copy(Function1<WebjarAsset, Object> webjarAssetFilter, CacheStrategy<F> cacheStrategy, Option<ClassLoader> classLoader, boolean preferGzipped) {
        return new WebjarServiceBuilder<F>(webjarAssetFilter, cacheStrategy, classLoader, preferGzipped);
    }

    private Function1<WebjarAsset, Object> copy$default$1() {
        return this.webjarAssetFilter;
    }

    private CacheStrategy<F> copy$default$2() {
        return this.cacheStrategy;
    }

    private Option<ClassLoader> copy$default$3() {
        return this.classLoader;
    }

    private boolean copy$default$4() {
        return this.preferGzipped;
    }

    public WebjarServiceBuilder<F> withWebjarAssetFilter(Function1<WebjarAsset, Object> webjarAssetFilter) {
        return this.copy(webjarAssetFilter, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public WebjarServiceBuilder<F> withCacheStrategy(CacheStrategy<F> cacheStrategy) {
        return this.copy(this.copy$default$1(), cacheStrategy, this.copy$default$3(), this.copy$default$4());
    }

    public WebjarServiceBuilder<F> withClassLoader(Option<ClassLoader> classLoader) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), classLoader, this.copy$default$4());
    }

    public WebjarServiceBuilder<F> withPreferGzipped(boolean preferGzipped) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), preferGzipped);
    }

    public Kleisli<?, Request<F>, Response<F>> toRoutes(Async<F> F) {
        LazyRef lazyRef = new LazyRef();
        Path Root = Paths.get("", new String[0]);
        return Kleisli$.MODULE$.apply((Function1 & Serializable)x$1 -> {
            Request request;
            Request request2 = request = x$1;
            Method method = request2.method();
            Method method2 = Method$.MODULE$.GET();
            if (!(method != null ? !method.equals(method2) : method2 != null)) {
                Vector segments = (Vector)request2.pathInfo().segments().map((Function1 & Serializable)_$2 -> _$2.decoded(_$2.decoded$default$1(), true, _$2.decoded$default$3()));
                OptionT optionT = (OptionT)package.all$.MODULE$.catsSyntaxApplicativeError((Object)OptionT$.MODULE$.liftF(F.catchNonFatal(() -> WebjarServiceBuilder.toRoutes$$anonfun$1$$anonfun$1(segments, Root, lazyRef), (.less.colon.less)$less$colon$less$.MODULE$.refl()), (Functor)F).subflatMap((Function1 & Serializable)p -> this.toWebjarAsset((Path)p), (Functor)F).filter(this.webjarAssetFilter, (Functor)F).flatMap((Function1 & Serializable)_$3 -> WebjarServiceBuilder$.MODULE$.org$http4s$server$staticcontent$WebjarServiceBuilder$$$serveWebjarAsset(this.cacheStrategy, this.classLoader, request2, this.preferGzipped, (WebjarAsset)_$3, F), (Monad)F), (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F));
                return (OptionT)ApplicativeErrorOps$.MODULE$.recover$extension((Object)optionT, (PartialFunction)new Serializable(lazyRef, this){
                    private final LazyRef BadTraversal$lzy1$6;
                    {
                        this.BadTraversal$lzy1$6 = BadTraversal$lzy1$7;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        WebjarServiceBuilder$BadTraversal$2$ webjarServiceBuilder$BadTraversal$2$ = WebjarServiceBuilder.org$http4s$server$staticcontent$WebjarServiceBuilder$$_$BadTraversal$1(this.BadTraversal$lzy1$6);
                        Throwable throwable2 = throwable;
                        return !(webjarServiceBuilder$BadTraversal$2$ != null ? !webjarServiceBuilder$BadTraversal$2$.equals(throwable2) : throwable2 != null);
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        WebjarServiceBuilder$BadTraversal$2$ webjarServiceBuilder$BadTraversal$2$ = WebjarServiceBuilder.org$http4s$server$staticcontent$WebjarServiceBuilder$$_$BadTraversal$1(this.BadTraversal$lzy1$6);
                        Throwable throwable2 = throwable;
                        if (!(webjarServiceBuilder$BadTraversal$2$ != null ? !webjarServiceBuilder$BadTraversal$2$.equals(throwable2) : throwable2 != null)) {
                            return Response$.MODULE$.apply(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
                        }
                        return function1.apply((Object)x);
                    }
                }, (ApplicativeError)OptionT$.MODULE$.catsDataMonadErrorForOptionT((MonadError)F));
            }
            return OptionT$.MODULE$.none((Applicative)F);
        });
    }

    private Option<WebjarAsset> toWebjarAsset(Path p) {
        int count = p.getNameCount();
        if (count > 2) {
            String library = p.getName(0).toString();
            String version = p.getName(1).toString();
            String asset = this.asScalaIterator(p.subpath(2, count).iterator()).mkString("/");
            return Some$.MODULE$.apply((Object)WebjarServiceBuilder$WebjarAsset$.MODULE$.apply(library, version, asset));
        }
        return None$.MODULE$;
    }

    private <A> Iterator<A> asScalaIterator(java.util.Iterator<A> underlying) {
        return new Iterator<A>(underlying){
            private final java.util.Iterator underlying$1;
            {
                this.underlying$1 = underlying$2;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }

            public boolean hasNext() {
                return this.underlying$1.hasNext();
            }

            public Object next() {
                return this.underlying$1.next();
            }
        };
    }

    private static final WebjarServiceBuilder$BadTraversal$2$ BadTraversal$lzyINIT1$1(LazyRef BadTraversal$lzy1$1) {
        WebjarServiceBuilder$BadTraversal$2$ webjarServiceBuilder$BadTraversal$2$;
        LazyRef lazyRef = BadTraversal$lzy1$1;
        synchronized (lazyRef) {
            webjarServiceBuilder$BadTraversal$2$ = (WebjarServiceBuilder$BadTraversal$2$)(BadTraversal$lzy1$1.initialized() ? BadTraversal$lzy1$1.value() : BadTraversal$lzy1$1.initialize((Object)new WebjarServiceBuilder$BadTraversal$2$()));
        }
        return webjarServiceBuilder$BadTraversal$2$;
    }

    public static final WebjarServiceBuilder$BadTraversal$2$ org$http4s$server$staticcontent$WebjarServiceBuilder$$_$BadTraversal$1(LazyRef BadTraversal$lzy1$2) {
        return (WebjarServiceBuilder$BadTraversal$2$)(BadTraversal$lzy1$2.initialized() ? BadTraversal$lzy1$2.value() : WebjarServiceBuilder.BadTraversal$lzyINIT1$1(BadTraversal$lzy1$2));
    }

    private static final Path toRoutes$$anonfun$1$$anonfun$1(Vector segments$1, Path Root$2, LazyRef BadTraversal$lzy1$4) {
        return (Path)segments$1.foldLeft((Object)Root$2, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String string = (String)tuple2._2();
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if ("".equals(string)) throw WebjarServiceBuilder.org$http4s$server$staticcontent$WebjarServiceBuilder$$_$BadTraversal$1(BadTraversal$lzy1$4);
                    break;
                }
                case 46: {
                    if (".".equals(string)) throw WebjarServiceBuilder.org$http4s$server$staticcontent$WebjarServiceBuilder$$_$BadTraversal$1(BadTraversal$lzy1$4);
                    break;
                }
                case 1472: {
                    if (!"..".equals(string)) break;
                    throw WebjarServiceBuilder.org$http4s$server$staticcontent$WebjarServiceBuilder$$_$BadTraversal$1(BadTraversal$lzy1$4);
                }
            }
            Path path = (Path)tuple2._1();
            String segment = string;
            return path.resolve(segment);
        });
    }

    public static final class WebjarAsset
    implements Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WebjarAsset.class.getDeclaredField("pathInJar$lzy1"));
        private final String library;
        private final String version;
        private final String asset;
        private volatile Object pathInJar$lzy1;

        public static WebjarAsset apply(String string, String string2, String string3) {
            return WebjarServiceBuilder$WebjarAsset$.MODULE$.apply(string, string2, string3);
        }

        public static WebjarAsset fromProduct(Product product) {
            return WebjarServiceBuilder$WebjarAsset$.MODULE$.fromProduct(product);
        }

        public static WebjarAsset unapply(WebjarAsset webjarAsset) {
            return WebjarServiceBuilder$WebjarAsset$.MODULE$.unapply(webjarAsset);
        }

        public WebjarAsset(String library, String version, String asset) {
            this.library = library;
            this.version = version;
            this.asset = asset;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WebjarAsset)) return false;
            WebjarAsset webjarAsset = (WebjarAsset)object;
            String string = this.library();
            String string2 = webjarAsset.library();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.version();
            String string4 = webjarAsset.version();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.asset();
            String string6 = webjarAsset.asset();
            if (string5 == null) {
                if (string6 == null) return true;
                return false;
            } else {
                if (!string5.equals(string6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WebjarAsset;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "WebjarAsset";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "library";
                }
                case 1: {
                    return "version";
                }
                case 2: {
                    return "asset";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String library() {
            return this.library;
        }

        public String version() {
            return this.version;
        }

        public String asset() {
            return this.asset;
        }

        public String pathInJar() {
            Object object = this.pathInJar$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.pathInJar$lzyINIT1();
        }

        private Object pathInJar$lzyINIT1() {
            Object object;
            block7: {
                while (true) {
                    if ((object = this.pathInJar$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = new StringBuilder(30).append("/META-INF/resources/webjars/").append(this.library()).append("/").append(this.version()).append("/").append(this.asset()).toString();
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        catch (Throwable throwable) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.pathInJar$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                            throw throwable;
                        }
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pathInJar$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public WebjarAsset copy(String library, String version, String asset) {
            return new WebjarAsset(library, version, asset);
        }

        public String copy$default$1() {
            return this.library();
        }

        public String copy$default$2() {
            return this.version();
        }

        public String copy$default$3() {
            return this.asset();
        }

        public String _1() {
            return this.library();
        }

        public String _2() {
            return this.version();
        }

        public String _3() {
            return this.asset();
        }
    }
}

