/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.effect.SyncIO;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.Headers$;
import org.http4s.Message;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.Logger$;
import org.typelevel.ci.CIString;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.NotGiven$;

public final class ResponseLogger$
implements Serializable {
    private static final SelfAwareStructuredLogger<SyncIO> logger;
    public static final ResponseLogger$ MODULE$;

    private ResponseLogger$() {
    }

    static {
        MODULE$ = new ResponseLogger$();
        logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.client.middleware.ResponseLogger");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ResponseLogger$.class);
    }

    private <F> Object defaultLogAction(String s, Sync<F> evidence$1) {
        return ((SyncIO)logger.info(() -> this.defaultLogAction$$anonfun$1(s))).to(evidence$1);
    }

    public <F> Client<F> apply(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, Object>> logAction, Client<F> client, Async<F> evidence$2) {
        return this.impl(client, logBody, (Function1 & Serializable)response -> Logger$.MODULE$.logMessage(response, logHeaders, logBody, redactHeadersWhen, (Function1<String, Object>)((Function1)logAction.getOrElse(() -> this.apply$$anonfun$1$$anonfun$1(evidence$2))), evidence$2), evidence$2);
    }

    public <F> Function1<CIString, Object> apply$default$3() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> logBodyText(boolean logHeaders, Function1<Stream<F, Object>, Option<Object>> logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, Object>> logAction, Client<F> client, Async<F> evidence$3) {
        return this.impl(client, true, (Function1 & Serializable)response -> org.http4s.internal.Logger$.MODULE$.logMessageWithBodyText((Message)response, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse(() -> this.logBodyText$$anonfun$1$$anonfun$1(evidence$3)), (Monad)evidence$3), evidence$3);
    }

    public <F> Function1<CIString, Object> logBodyText$default$3() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public <F> None$ logBodyText$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> customized(Client<F> client, boolean logBody, Option<Function1<String, Object>> logAction, Function1<Response<F>, Object> responseToText, Async<F> evidence$4) {
        return this.impl(client, logBody, (Function1 & Serializable)response -> {
            Function1 log = (Function1)logAction.getOrElse(() -> this.$anonfun$1(evidence$4));
            return package.all$.MODULE$.toFlatMapOps(responseToText.apply(response), (FlatMap)evidence$4).flatMap(log);
        }, evidence$4);
    }

    public boolean customized$default$2() {
        return true;
    }

    public <F> None$ customized$default$3() {
        return None$.MODULE$;
    }

    private <F> Client<F> impl(Client<F> client, boolean logBody, Function1<Response<F>, Object> logMessage, Async<F> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> client.run((Request)req).flatMap((Function1 & Serializable)response -> this.logResponse$1(logBody, logMessage, F, (Response)response)), F);
    }

    public <F> String defaultResponseColor(Response<F> response) {
        Status.ResponseClass responseClass = response.status().responseClass();
        if (Status.Informational$.MODULE$.equals(responseClass) || Status.Successful$.MODULE$.equals(responseClass) || Status.Redirection$.MODULE$.equals(responseClass)) {
            return "\u001b[32m";
        }
        if (Status.ClientError$.MODULE$.equals(responseClass)) {
            return "\u001b[33m";
        }
        if (Status.ServerError$.MODULE$.equals(responseClass)) {
            return "\u001b[31m";
        }
        throw new MatchError((Object)responseClass);
    }

    public <F> Client<F> colored(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Function1<Response<F>, String> color, Option<Function1<String, Object>> logAction, Client<F> client, Async<F> evidence$5) {
        return this.customized(client, logBody, logAction, (Function1 & Serializable)response -> {
            Object object;
            String prelude = new StringBuilder(1).append(response.httpVersion()).append(" ").append(response.status()).toString();
            String headers = org.http4s.internal.Logger$.MODULE$.defaultLogHeaders((Message)response, logHeaders, redactHeadersWhen);
            Option option = org.http4s.internal.Logger$.MODULE$.defaultLogBody((Message)response, logBody, (GenConcurrent)evidence$5);
            if (option instanceof Some) {
                Object textF = ((Some)option).value();
                object = package.all$.MODULE$.toFunctorOps(textF, (Functor)evidence$5).map((Function1 & Serializable)text -> new StringBuilder(7).append("body=\"").append((String)text).append("\"").toString());
            } else if (None$.MODULE$.equals(option)) {
                object = cats.effect.package$.MODULE$.Sync().apply((Sync)evidence$5).pure((Object)"");
            } else {
                throw new MatchError((Object)option);
            }
            Object bodyText = object;
            return package.all$.MODULE$.toFunctorOps(bodyText, (Functor)evidence$5).map((Function1 & Serializable)body -> new StringBuilder(4).append(color.apply(response)).append(prelude).append(this.spaced$1(headers)).append(this.spaced$1((String)body)).append("\u001b[0m").toString());
        }, evidence$5);
    }

    public <F> Function1<CIString, Object> colored$default$3() {
        return (Function1 & Serializable)elem -> Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public <F> Function1<Response<?>, String> colored$default$4() {
        return (Function1 & Serializable)response -> this.defaultResponseColor((Response)response);
    }

    public <F> None$ colored$default$5() {
        return None$.MODULE$;
    }

    private final String defaultLogAction$$anonfun$1(String s$1) {
        return s$1;
    }

    private final Function1 apply$$anonfun$1$$anonfun$1(Async evidence$2$2) {
        return (Function1 & Serializable)s -> this.defaultLogAction((String)s, (Sync)evidence$2$2);
    }

    private final Function1 logBodyText$$anonfun$1$$anonfun$1(Async evidence$3$2) {
        return (Function1 & Serializable)s -> this.defaultLogAction((String)s, (Sync)evidence$3$2);
    }

    private final Function1 $anonfun$1(Async evidence$4$2) {
        return (Function1 & Serializable)s -> this.defaultLogAction((String)s, (Sync)evidence$4$2);
    }

    private final Response logResponse$1$$anonfun$1(Response response$1) {
        return response$1;
    }

    private final String logResponse$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "Error logging response body";
    }

    private final Resource logResponse$1(boolean logBody$3, Function1 logMessage$1, Async F$1, Response response) {
        if (!logBody$3) {
            return cats.effect.package$.MODULE$.Resource().eval(package.all$.MODULE$.catsSyntaxApply(logMessage$1.apply((Object)response), (Apply)F$1).$times$greater(F$1.delay(() -> this.logResponse$1$$anonfun$1(response))));
        }
        Ref.Make make = cats.effect.package$.MODULE$.Ref().apply(Ref.Make$.MODULE$.concurrentInstance((GenConcurrent)F$1));
        return cats.effect.package$.MODULE$.Resource().suspend(package.all$.MODULE$.toFunctorOps(Ref.ApplyBuilders$.MODULE$.of$extension(make, (Object)package$.MODULE$.Vector().empty()), (Functor)F$1).map((Function1 & Serializable)vec -> {
            Function1 & Serializable dumpChunksToVec = (Function1 & Serializable)_$6 -> _$6.chunks().flatMap((Function1 & Serializable)s -> Stream$.MODULE$.exec(vec.update((Function1 & Serializable)_$7 -> (Vector)_$7.$colon$plus(s))), NotGiven$.MODULE$.value());
            return cats.effect.package$.MODULE$.Resource().make(F$1.pure((Object)response.pipeBodyThrough((Function1 & Serializable)_$8 -> {
                Stream stream = Stream$.MODULE$.InvariantOps(_$8);
                return Stream.InvariantOps$.MODULE$.observe$extension(stream, dumpChunksToVec, (GenConcurrent)F$1);
            })), (Function1 & Serializable)_$9 -> {
                Stream newBody = Stream$.MODULE$.eval(vec.get()).flatMap((Function1 & Serializable)os -> Stream$.MODULE$.emits((Seq)os), NotGiven$.MODULE$.value()).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Object object = package.all$.MODULE$.catsSyntaxApplicativeError(logMessage$1.apply((Object)response.withBodyStream(newBody)), (ApplicativeError)F$1);
                return ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, (Function1 & Serializable)t -> ((SyncIO)logger.error(t, this::logResponse$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1)).to((Sync)F$1), (ApplicativeError)F$1);
            }, (Functor)F$1);
        }));
    }

    private final String spaced$1(String x) {
        if (x.isEmpty()) {
            return x;
        }
        return new StringBuilder(1).append(" ").append(x).toString();
    }
}

