/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.ApplicativeError;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Async;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compression.Compression;
import fs2.compression.Compression$;
import fs2.compression.DeflateParams$;
import fs2.io.compression$;
import java.io.Serializable;
import org.http4s.ContentCoding;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.GZip$EmptyBodyException$;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusEncoding$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.NotGiven$;

public final class GZip$
implements Serializable {
    private static final NonEmptyList<ContentCoding> supportedCompressions;
    private static final GZip$EmptyBodyException$ EmptyBodyException;
    public static final GZip$ MODULE$;

    private GZip$() {
    }

    static {
        MODULE$ = new GZip$();
        supportedCompressions = NonEmptyList$.MODULE$.of((Object)ContentCoding$.MODULE$.gzip(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ContentCoding[]{ContentCoding$.MODULE$.deflate()}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GZip$.class);
    }

    public <F> Client<F> apply(int bufferSize, Client<F> client, MonadCancel<F, Throwable> evidence$1, Compression<F> evidence$2) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> {
            Request reqWithEncoding = this.addHeaders((Request)req);
            Resource responseResource = client.run(reqWithEncoding);
            return responseResource.map((Function1 & Serializable)actualResponse -> this.decompress(bufferSize, (Response)actualResponse, (ApplicativeError)evidence$1, evidence$2));
        }, evidence$1);
    }

    public int apply$default$1() {
        return 32768;
    }

    public <F> Client<F> apply(int bufferSize, Client<F> client, Async<F> F) {
        Async<F> async = F;
        Compression compression = compression$.MODULE$.fs2ioCompressionForAsync(async);
        return this.apply(bufferSize, client, (MonadCancel<F, Throwable>)async, (Compression<F>)compression);
    }

    private <F> Request<F> addHeaders(Request<F> req) {
        Option option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Accept$minusEncoding$.MODULE$.headerSemigroupInstance(), Accept$minusEncoding$.MODULE$.headerInstance()));
        if (option instanceof Some) {
            return req;
        }
        return (Request)req.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Accept$minusEncoding$.MODULE$.apply(supportedCompressions), Accept$minusEncoding$.MODULE$.headerInstance())}));
    }

    private <F> Response<F> decompress(int bufferSize, Response<F> response, ApplicativeError<F, Throwable> evidence$3, Compression<F> evidence$4) {
        block4: {
            Content.minusEncoding minusEncoding2;
            block6: {
                block5: {
                    Option option = Headers$.MODULE$.get$extension(response.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusEncoding$.MODULE$.headerInstance()));
                    if (!(option instanceof Some)) break block4;
                    Content.minusEncoding header2 = minusEncoding2 = (Content.minusEncoding)((Some)option).value();
                    ContentCoding contentCoding = header2.contentCoding();
                    ContentCoding contentCoding2 = ContentCoding$.MODULE$.gzip();
                    if (!(contentCoding == null ? contentCoding2 != null : !contentCoding.equals(contentCoding2))) break block5;
                    ContentCoding contentCoding3 = header2.contentCoding();
                    ContentCoding contentCoding4 = ContentCoding$.MODULE$.x$minusgzip();
                    if (contentCoding3 != null ? !contentCoding3.equals(contentCoding4) : contentCoding4 != null) break block6;
                }
                Function1 & Serializable gunzip = (Function1 & Serializable)_$5 -> _$5.through(Compression$.MODULE$.apply(evidence$4).gunzip(bufferSize)).flatMap((Function1 & Serializable)_$6 -> _$6.content(), NotGiven$.MODULE$.value());
                return (Response)response.filterHeaders((Function1 & Serializable)header -> this.nonCompressionHeader((Header.Raw)header)).pipeBodyThrough(this.decompressWith(gunzip, evidence$3));
            }
            Content.minusEncoding header3 = minusEncoding2;
            ContentCoding contentCoding = header3.contentCoding();
            ContentCoding contentCoding5 = ContentCoding$.MODULE$.deflate();
            if (!(contentCoding != null ? !contentCoding.equals(contentCoding5) : contentCoding5 != null)) {
                Function1 deflate = Compression$.MODULE$.apply(evidence$4).deflate(DeflateParams$.MODULE$.apply(bufferSize, DeflateParams$.MODULE$.apply$default$2(), DeflateParams$.MODULE$.apply$default$3(), DeflateParams$.MODULE$.apply$default$4(), DeflateParams$.MODULE$.apply$default$5()));
                return (Response)response.filterHeaders((Function1 & Serializable)header -> this.nonCompressionHeader((Header.Raw)header)).pipeBodyThrough(this.decompressWith(deflate, evidence$3));
            }
        }
        return response;
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> decompressWith(Function1<Stream<F, Object>, Stream<F, Object>> decompressor, ApplicativeError<F, Throwable> evidence$5) {
        return (Function1 & Serializable)_$8 -> {
            Stream stream = Stream$.MODULE$.InvariantOps(_$8);
            Stream stream2 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            Pull pull = Pull$.MODULE$.StreamPullOps(Stream.ToPull$.MODULE$.peek1$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Option option = x$1;
                if (None$.MODULE$.equals(option)) {
                    return Pull$.MODULE$.raiseError((Throwable)GZip$EmptyBodyException$.MODULE$, RaiseThrowable$.MODULE$.fromApplicativeError(evidence$5));
                }
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Stream fullStream = (Stream)tuple2._2();
                    return Pull$.MODULE$.output1((Object)fullStream);
                }
                throw new MatchError((Object)option);
            }));
            return Pull.StreamPullOps$.MODULE$.stream$extension(pull).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).through(decompressor).handleErrorWith((Function1 & Serializable)x$1 -> {
                Throwable throwable = x$1;
                if (GZip$EmptyBodyException$.MODULE$.equals(throwable)) {
                    return Stream$.MODULE$.empty();
                }
                Throwable error = throwable;
                return Stream$.MODULE$.raiseError(error, RaiseThrowable$.MODULE$.fromApplicativeError(evidence$5));
            });
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean nonCompressionHeader(Header.Raw header) {
        CIString cIString = header.name();
        CIString cIString2 = package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Content-Encoding"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        if (cIString == null) {
            if (cIString2 == null) return false;
        } else if (cIString.equals(cIString2)) return false;
        CIString cIString3 = header.name();
        CIString cIString4 = package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Content-Length"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        if (cIString3 == null) {
            if (cIString4 == null) return false;
            return true;
        } else if (cIString3.equals(cIString4)) return false;
        return true;
    }
}

