/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.Priority$NoPriority$;
import org.http4s.blaze.http.http2.bits$;
import org.http4s.blaze.http.http2.bits$Flags$;
import org.http4s.blaze.http.http2.bits$FrameTypes$;
import org.http4s.blaze.http.http2.bits$Masks$;
import org.http4s.blaze.util.BufferTools$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class FrameSerializer$ {
    public static FrameSerializer$ MODULE$;
    private final ByteBuffer sharedPadding;

    static {
        new FrameSerializer$();
    }

    private void require(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    public Seq<ByteBuffer> mkDataFrame(int streamId, boolean endStream, int padding, ByteBuffer data) {
        this.require(0 < streamId, "bad DATA frame stream id");
        this.require(0 <= padding && padding <= 256, "Invalid padding of DATA frame");
        boolean padded = 0 < padding;
        int flags = 0;
        if (padded) {
            flags |= bits$Flags$.MODULE$.PADDED();
        }
        if (endStream) {
            flags |= bits$Flags$.MODULE$.END_STREAM();
        }
        ByteBuffer headerBuffer = ByteBuffer.allocate(bits$.MODULE$.HeaderSize() + (padded ? 1 : 0));
        int payloadSize = data.remaining() + padding;
        this.writeFrameHeader(payloadSize, bits$FrameTypes$.MODULE$.DATA(), (byte)flags, streamId, headerBuffer);
        Object object = padded ? headerBuffer.put((byte)(padding - 1)) : BoxedUnit.UNIT;
        headerBuffer.flip();
        ByteBuffer byteBuffer = headerBuffer;
        ByteBuffer byteBuffer2 = data;
        return this.tailPadding(padding - 1).$colon$colon((Object)byteBuffer2).$colon$colon((Object)byteBuffer);
    }

    public Seq<ByteBuffer> mkHeaderFrame(int streamId, Priority priority, boolean endHeaders, boolean endStream, int padding, ByteBuffer headerData) {
        this.require(0 < streamId, "bad HEADER frame stream id");
        this.require(0 <= padding, "Invalid padding of HEADER frame");
        boolean padded = 0 < padding;
        int flags = 0;
        int nonDataSize = 0;
        if (padded) {
            ++nonDataSize;
            flags |= bits$Flags$.MODULE$.PADDED();
        }
        if (priority.isDefined()) {
            nonDataSize += 5;
            flags |= bits$Flags$.MODULE$.PRIORITY();
        }
        if (endHeaders) {
            flags |= bits$Flags$.MODULE$.END_HEADERS();
        }
        if (endStream) {
            flags |= bits$Flags$.MODULE$.END_STREAM();
        }
        ByteBuffer header = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + nonDataSize);
        int payloadSize = nonDataSize + headerData.remaining() + (padded ? padding - 1 : 0);
        this.writeFrameHeader(payloadSize, bits$FrameTypes$.MODULE$.HEADERS(), (byte)flags, streamId, header);
        Object object = padded ? header.put((byte)(padding - 1)) : BoxedUnit.UNIT;
        Priority priority2 = priority;
        if (priority2 instanceof Priority.Dependent) {
            Priority.Dependent dependent = (Priority.Dependent)priority2;
            this.writePriority(dependent, header);
        } else if (Priority$NoPriority$.MODULE$.equals(priority2)) {
        } else {
            throw new MatchError((Object)priority2);
        }
        header.flip();
        ByteBuffer byteBuffer = header;
        ByteBuffer byteBuffer2 = headerData;
        return this.tailPadding(padding - 1).$colon$colon((Object)byteBuffer2).$colon$colon((Object)byteBuffer);
    }

    public ByteBuffer mkPriorityFrame(int streamId, Priority.Dependent priority) {
        this.require(0 < streamId, "Invalid stream id for PRIORITY frame");
        int payloadSize = 5;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + payloadSize);
        this.writeFrameHeader(payloadSize, bits$FrameTypes$.MODULE$.PRIORITY(), (byte)0, streamId, buffer);
        this.writePriority(priority, buffer);
        buffer.flip();
        return buffer;
    }

    public ByteBuffer mkRstStreamFrame(int streamId, long errorCode) {
        this.require(0 < streamId, "Invalid RST_STREAM stream id");
        this.require(0L <= errorCode && errorCode <= bits$Masks$.MODULE$.INT32(), "Invalid error code");
        int payloadSize = 4;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + payloadSize);
        this.writeFrameHeader(payloadSize, bits$FrameTypes$.MODULE$.RST_STREAM(), (byte)0, streamId, buffer);
        buffer.putInt((int)(errorCode & bits$Masks$.MODULE$.INT32()));
        buffer.flip();
        return buffer;
    }

    public ByteBuffer mkSettingsAckFrame() {
        return this.mkSettingsFrameImpl(true, (Seq<Http2Settings.Setting>)((Seq)Nil$.MODULE$));
    }

    public ByteBuffer mkSettingsFrame(Seq<Http2Settings.Setting> settings) {
        return this.mkSettingsFrameImpl(false, settings);
    }

    private ByteBuffer mkSettingsFrameImpl(boolean ack, Seq<Http2Settings.Setting> settings) {
        this.require(!ack || settings.isEmpty(), "Setting acknowledgement must be empty");
        int payloadSize = settings.length() * 6;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + payloadSize);
        byte flags = ack ? bits$Flags$.MODULE$.ACK() : (byte)0;
        this.writeFrameHeader(payloadSize, bits$FrameTypes$.MODULE$.SETTINGS(), flags, 0, buffer);
        settings.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Http2Settings.Setting setting = x0$1;
            if (setting != null) {
                int k = setting.code();
                int v = setting.value();
                return buffer.putShort((short)k).putInt(v);
            }
            throw new MatchError((Object)setting);
        });
        buffer.flip();
        return buffer;
    }

    public Seq<ByteBuffer> mkPushPromiseFrame(int streamId, int promiseId, boolean endHeaders, int padding, ByteBuffer headerBuffer) {
        this.require(streamId != 0, "Invalid Stream id for PUSH_PROMISE frame");
        this.require(promiseId != 0 && promiseId % 2 == 0, "Invalid Stream id for PUSH_PROMISE frame");
        this.require(0 <= padding && padding <= 256, "Invalid padding of HEADER frame");
        boolean padded = 0 < padding;
        int flags = 0;
        if (endHeaders) {
            flags |= bits$Flags$.MODULE$.END_HEADERS();
        }
        if (padded) {
            flags |= bits$Flags$.MODULE$.PADDED();
        }
        int bufferSize = bits$.MODULE$.HeaderSize() + 4 + (padded ? 1 : 0);
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bufferSize);
        this.writeFrameHeader(4 + padding + headerBuffer.remaining(), bits$FrameTypes$.MODULE$.PUSH_PROMISE(), (byte)flags, streamId, buffer);
        Object object = padded ? buffer.put((byte)(padding - 1)) : BoxedUnit.UNIT;
        buffer.putInt(promiseId).flip();
        ByteBuffer byteBuffer = buffer;
        ByteBuffer byteBuffer2 = headerBuffer;
        return this.tailPadding(padding - 1).$colon$colon((Object)byteBuffer2).$colon$colon((Object)byteBuffer);
    }

    public ByteBuffer mkPingFrame(boolean ack, byte[] data) {
        int PingSize = 8;
        this.require(data.length == PingSize, "Ping data must be 8 bytes long");
        byte flags = ack ? bits$Flags$.MODULE$.ACK() : (byte)0;
        ByteBuffer buffer = ByteBuffer.allocate(bits$.MODULE$.HeaderSize() + PingSize);
        this.writeFrameHeader(PingSize, bits$FrameTypes$.MODULE$.PING(), flags, 0, buffer);
        buffer.put(data).flip();
        return buffer;
    }

    public ByteBuffer mkGoAwayFrame(int lastStreamId, Http2Exception error) {
        byte[] msgString = error.getMessage().getBytes(StandardCharsets.UTF_8);
        return this.mkGoAwayFrame(lastStreamId, error.code(), msgString);
    }

    public ByteBuffer mkGoAwayFrame(int lastStreamId, long error, byte[] debugData) {
        this.require(0 <= lastStreamId, "Invalid last stream id for GOAWAY frame");
        int size = 8;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + size + debugData.length);
        this.writeFrameHeader(size + debugData.length, bits$FrameTypes$.MODULE$.GOAWAY(), (byte)0, 0, buffer);
        buffer.putInt(lastStreamId & bits$Masks$.MODULE$.INT31()).putInt((int)error).put(debugData).flip();
        return buffer;
    }

    public ByteBuffer mkWindowUpdateFrame(int streamId, int increment) {
        this.require(0 <= streamId, "Invalid stream id for WINDOW_UPDATE");
        this.require(0 < increment && increment <= Integer.MAX_VALUE, "Invalid stream increment for WINDOW_UPDATE");
        int size = 4;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize() + size);
        this.writeFrameHeader(size, bits$FrameTypes$.MODULE$.WINDOW_UPDATE(), (byte)0, streamId, buffer);
        buffer.putInt(bits$Masks$.MODULE$.INT31() & increment).flip();
        return buffer;
    }

    public Seq<ByteBuffer> mkContinuationFrame(int streamId, boolean endHeaders, ByteBuffer headerBuffer) {
        this.require(0 < streamId, "Invalid stream id for CONTINUATION frame");
        byte flags = endHeaders ? bits$Flags$.MODULE$.END_HEADERS() : (byte)0;
        ByteBuffer buffer = BufferTools$.MODULE$.allocate(bits$.MODULE$.HeaderSize());
        this.writeFrameHeader(headerBuffer.remaining(), bits$FrameTypes$.MODULE$.CONTINUATION(), flags, streamId, buffer);
        buffer.flip();
        ByteBuffer byteBuffer = buffer;
        ByteBuffer byteBuffer2 = headerBuffer;
        return Nil$.MODULE$.$colon$colon((Object)byteBuffer2).$colon$colon((Object)byteBuffer);
    }

    private void writePriority(Priority.Dependent p, ByteBuffer buffer) {
        ByteBuffer byteBuffer = p.exclusive() ? buffer.putInt(p.dependentStreamId() | bits$Masks$.MODULE$.EXCLUSIVE()) : buffer.putInt(p.dependentStreamId());
        buffer.put((byte)(p.priority() - 1 & 0xFF));
    }

    private List<ByteBuffer> tailPadding(int padBytes) {
        if (0 < padBytes) {
            ByteBuffer b = this.sharedPadding.duplicate();
            b.limit(padBytes);
            ByteBuffer byteBuffer = b;
            return Nil$.MODULE$.$colon$colon((Object)byteBuffer);
        }
        return Nil$.MODULE$;
    }

    private void writeFrameHeader(int length, byte frameType, byte flags, int streamdId, ByteBuffer buffer) {
        buffer.put((byte)(length >>> 16 & 0xFF)).put((byte)(length >>> 8 & 0xFF)).put((byte)(length & 0xFF)).put(frameType).put(flags).putInt(streamdId & bits$Masks$.MODULE$.STREAMID());
    }

    private FrameSerializer$() {
        MODULE$ = this;
        this.sharedPadding = BufferTools$.MODULE$.allocate(255).asReadOnlyBuffer();
    }
}

