/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.websocket;

import java.io.Serializable;
import java.net.ProtocolException;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.Execution$;
import org.http4s.websocket.WebsocketBits;
import org.slf4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011\u0011cV*Ge\u0006lW-Q4he\u0016<\u0017\r^8s\u0015\t\u0019A!A\u0005xK\n\u001cxnY6fi*\u0011QAB\u0001\u0005QR$\bO\u0003\u0002\b\u0011\u0005)!\r\\1{K*\u0011\u0011BC\u0001\u0007QR$\b\u000fN:\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB!Q\u0003\u0007\u000e\u001b\u001b\u00051\"BA\f\u0007\u0003!\u0001\u0018\u000e]3mS:,\u0017BA\r\u0017\u0005!i\u0015\u000eZ*uC\u001e,\u0007CA\u000e)\u001d\taRE\u0004\u0002\u001eI9\u0011ad\t\b\u0003?\tj\u0011\u0001\t\u0006\u0003C1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0002\t\u0013\t1s%A\u0007XK\n\u001cxnY6fi\nKGo\u001d\u0006\u0003\u0007!I!!\u000b\u0016\u0003\u001d]+'mU8dW\u0016$hI]1nK*\u0011ae\n\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0002\"a\f\u0001\u000e\u0003\tAQ!\r\u0001\u0005\u0002I\nAA\\1nKV\t1\u0007\u0005\u00025q9\u0011QG\u000e\t\u0003?AI!a\u000e\t\u0002\rA\u0013X\rZ3g\u0013\tI$H\u0001\u0004TiJLgn\u001a\u0006\u0003oAAq\u0001\u0010\u0001A\u0002\u0013%Q(A\u0003rk\u0016,X-F\u0001?!\ryDIG\u0007\u0002\u0001*\u0011\u0011IQ\u0001\b[V$\u0018M\u00197f\u0015\t\u0019\u0005#\u0001\u0006d_2dWm\u0019;j_:L!!\u0012!\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\b\u000f\u0002\u0001\r\u0011\"\u0003I\u0003%\tX/Z;f?\u0012*\u0017\u000f\u0006\u0002J\u0019B\u0011qBS\u0005\u0003\u0017B\u0011A!\u00168ji\"9QJRA\u0001\u0002\u0004q\u0014a\u0001=%c!1q\n\u0001Q!\ny\na!];fk\u0016\u0004\u0003bB)\u0001\u0001\u0004%IAU\u0001\u0005g&TX-F\u0001T!\tyA+\u0003\u0002V!\t\u0019\u0011J\u001c;\t\u000f]\u0003\u0001\u0019!C\u00051\u0006A1/\u001b>f?\u0012*\u0017\u000f\u0006\u0002J3\"9QJVA\u0001\u0002\u0004\u0019\u0006BB.\u0001A\u0003&1+A\u0003tSj,\u0007\u0005C\u0003^\u0001\u0011\u0005a,A\u0006sK\u0006$'+Z9vKN$HCA0f!\r\u00017MG\u0007\u0002C*\u0011!\rE\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00013b\u0005\u00191U\u000f^;sK\")\u0011\u000b\u0018a\u0001'\")q\r\u0001C\u0005Q\u0006A!/Z1e\u0019>|\u0007\u000fF\u0002JS.DQA\u001b4A\u0002i\tQA\u001a:b[\u0016DQ\u0001\u001c4A\u00025\f\u0011\u0001\u001d\t\u0004A:T\u0012BA8b\u0005\u001d\u0001&o\\7jg\u0016DQ!\u001d\u0001\u0005\nI\fAbY8na&dWM\u0012:b[\u0016$\"!S:\t\u000b1\u0004\b\u0019A7\t\u000bU\u0004A\u0011\u0002<\u0002\u0015!\fg\u000e\u001a7f\u0011\u0016\fG\rF\u0002JobDQA\u001b;A\u0002iAQ\u0001\u001c;A\u00025DQA\u001f\u0001\u0005\u0002m\fAb\u001e:ji\u0016\u0014V-];fgR$\"\u0001`?\u0011\u0007\u0001\u001c\u0017\nC\u0003\u007fs\u0002\u0007!$\u0001\u0003eCR\f\u0007B\u0002>\u0001\t\u0003\n\t\u0001F\u0002}\u0003\u0007AaA`@A\u0002\u0005\u0015\u0001#BA\u0004\u0003#Qb\u0002BA\u0005\u0003\u001bq1aHA\u0006\u0013\u0005\t\u0012bAA\b!\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\n\u0003+\u00111aU3r\u0015\r\ty\u0001\u0005")
public class WSFrameAggregator
implements MidStage<WebsocketBits.WebSocketFrame, WebsocketBits.WebSocketFrame> {
    private ArrayBuffer<WebsocketBits.WebSocketFrame> queue;
    private int size;
    private Tail<WebsocketBits.WebSocketFrame> _nextStage;
    private Head<WebsocketBits.WebSocketFrame> _prevStage;
    private final Logger logger;

    public /* synthetic */ void org$http4s$blaze$pipeline$MidStage$$super$outboundCommand(Command.OutboundCommand cmd) {
        Head.outboundCommand$((Head)this, (Command.OutboundCommand)cmd);
    }

    public void outboundCommand(Command.OutboundCommand cmd) {
        MidStage.outboundCommand$((MidStage)this, (Command.OutboundCommand)cmd);
    }

    public final MidStage<WebsocketBits.WebSocketFrame, WebsocketBits.WebSocketFrame> replaceInline(MidStage<WebsocketBits.WebSocketFrame, WebsocketBits.WebSocketFrame> stage) {
        return MidStage.replaceInline$((MidStage)this, stage);
    }

    public final Tail<WebsocketBits.WebSocketFrame> replaceNext(LeafBuilder<WebsocketBits.WebSocketFrame> stage) {
        return MidStage.replaceNext$((MidStage)this, stage);
    }

    public final void removeStage(Predef$.eq.colon.eq<MidStage<WebsocketBits.WebSocketFrame, WebsocketBits.WebSocketFrame>, MidStage<WebsocketBits.WebSocketFrame, WebsocketBits.WebSocketFrame>> ev) {
        MidStage.removeStage$((MidStage)this, ev);
    }

    public /* synthetic */ void org$http4s$blaze$pipeline$Head$$super$inboundCommand(Command.InboundCommand cmd) {
        Stage.inboundCommand$((Stage)this, (Command.InboundCommand)cmd);
    }

    public final void sendInboundCommand(Command.InboundCommand cmd) {
        Head.sendInboundCommand$((Head)this, (Command.InboundCommand)cmd);
    }

    public void inboundCommand(Command.InboundCommand cmd) {
        Head.inboundCommand$((Head)this, (Command.InboundCommand)cmd);
    }

    public final void spliceAfter(MidStage<WebsocketBits.WebSocketFrame, WebsocketBits.WebSocketFrame> stage) {
        Head.spliceAfter$((Head)this, stage);
    }

    public final Option<Stage> findInboundStage(String name) {
        return Head.findInboundStage$((Head)this, (String)name);
    }

    public final <C extends Stage> Option<C> findInboundStage(Class<C> clazz) {
        return Head.findInboundStage$((Head)this, clazz);
    }

    public Future<WebsocketBits.WebSocketFrame> channelRead(int size, Duration timeout) {
        return Tail.channelRead$((Tail)this, (int)size, (Duration)timeout);
    }

    public Future channelWrite(Object data) {
        return Tail.channelWrite$((Tail)this, (Object)data);
    }

    public final Future channelWrite(Object data, Duration timeout) {
        return Tail.channelWrite$((Tail)this, (Object)data, (Duration)timeout);
    }

    public Future<BoxedUnit> channelWrite(Seq<WebsocketBits.WebSocketFrame> data) {
        return Tail.channelWrite$((Tail)this, data);
    }

    public final Future<BoxedUnit> channelWrite(Seq<WebsocketBits.WebSocketFrame> data, Duration timeout) {
        return Tail.channelWrite$((Tail)this, data, (Duration)timeout);
    }

    public final void spliceBefore(MidStage<WebsocketBits.WebSocketFrame, WebsocketBits.WebSocketFrame> stage) {
        Tail.spliceBefore$((Tail)this, stage);
    }

    public final void sendOutboundCommand(Command.OutboundCommand cmd) {
        Tail.sendOutboundCommand$((Tail)this, (Command.OutboundCommand)cmd);
    }

    public final Option<Stage> findOutboundStage(String name) {
        return Tail.findOutboundStage$((Tail)this, (String)name);
    }

    public final <C extends Stage> Option<C> findOutboundStage(Class<C> clazz) {
        return Tail.findOutboundStage$((Tail)this, clazz);
    }

    public final Tail<WebsocketBits.WebSocketFrame> replaceInline(LeafBuilder<WebsocketBits.WebSocketFrame> leafBuilder, boolean startup) {
        return Tail.replaceInline$((Tail)this, leafBuilder, (boolean)startup);
    }

    public int channelRead$default$1() {
        return Tail.channelRead$default$1$((Tail)this);
    }

    public Duration channelRead$default$2() {
        return Tail.channelRead$default$2$((Tail)this);
    }

    public final boolean replaceInline$default$2() {
        return Tail.replaceInline$default$2$((Tail)this);
    }

    public void stageStartup() {
        Stage.stageStartup$((Stage)this);
    }

    public void stageShutdown() {
        Stage.stageShutdown$((Stage)this);
    }

    public Tail<WebsocketBits.WebSocketFrame> _nextStage() {
        return this._nextStage;
    }

    public void _nextStage_$eq(Tail<WebsocketBits.WebSocketFrame> x$1) {
        this._nextStage = x$1;
    }

    public Head<WebsocketBits.WebSocketFrame> _prevStage() {
        return this._prevStage;
    }

    public void _prevStage_$eq(Head<WebsocketBits.WebSocketFrame> x$1) {
        this._prevStage = x$1;
    }

    public final Logger logger() {
        return this.logger;
    }

    public final void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String name() {
        return "WebSocket Frame Aggregator";
    }

    private ArrayBuffer<WebsocketBits.WebSocketFrame> queue() {
        return this.queue;
    }

    private void queue_$eq(ArrayBuffer<WebsocketBits.WebSocketFrame> x$1) {
        this.queue = x$1;
    }

    private int size() {
        return this.size;
    }

    private void size_$eq(int x$1) {
        this.size = x$1;
    }

    public Future<WebsocketBits.WebSocketFrame> readRequest(int size) {
        Promise p = Promise$.MODULE$.apply();
        this.channelRead(size, this.channelRead$default$2()).onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WebsocketBits.WebSocketFrame f = (WebsocketBits.WebSocketFrame)success.value();
                this.readLoop(f, (Promise<WebsocketBits.WebSocketFrame>)p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                boxedUnit = p.failure(t);
            } else {
                throw new MatchError((Object)try_);
            }
            return boxedUnit;
        }, Execution$.MODULE$.directec());
        return p.future();
    }

    private void readLoop(WebsocketBits.WebSocketFrame frame, Promise<WebsocketBits.WebSocketFrame> p) {
        WebsocketBits.WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof WebsocketBits.Text) {
            this.handleHead(frame, p);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (webSocketFrame instanceof WebsocketBits.Binary) {
            this.handleHead(frame, p);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (webSocketFrame instanceof WebsocketBits.Continuation) {
            BoxedUnit boxedUnit;
            WebsocketBits.Continuation continuation = (WebsocketBits.Continuation)webSocketFrame;
            if (this.queue().isEmpty()) {
                ProtocolException e = new ProtocolException("Invalid state: Received a Continuation frame without accumulated state.");
                this.logger().error("Invalid state", (Throwable)e);
                p.failure((Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.queue().$plus$eq((Object)frame);
                this.size_$eq(this.size() + frame.length());
                if (continuation.last()) {
                    this.compileFrame(p);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        BoxedUnit boxedUnit;
                        Try try_ = x0$2;
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            WebsocketBits.WebSocketFrame f = (WebsocketBits.WebSocketFrame)success.value();
                            this.readLoop(f, p);
                            boxedUnit = BoxedUnit.UNIT;
                        } else if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable t = failure.exception();
                            boxedUnit = p.failure(t);
                        } else {
                            throw new MatchError((Object)try_);
                        }
                        return boxedUnit;
                    }, Execution$.MODULE$.trampoline());
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            p.success((Object)webSocketFrame);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void compileFrame(Promise<WebsocketBits.WebSocketFrame> p) {
        WebsocketBits.Text text;
        byte[] arr = new byte[this.size()];
        this.size_$eq(0);
        ArrayBuffer<WebsocketBits.WebSocketFrame> msgs = this.queue();
        this.queue_$eq((ArrayBuffer<WebsocketBits.WebSocketFrame>)new ArrayBuffer(msgs.size() + 10));
        msgs.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(i, f) -> BoxesRunTime.boxToInteger((int)WSFrameAggregator.$anonfun$compileFrame$1(arr, BoxesRunTime.unboxToInt((Object)i), f)));
        WebsocketBits.WebSocketFrame webSocketFrame = (WebsocketBits.WebSocketFrame)msgs.head();
        if (webSocketFrame instanceof WebsocketBits.Text) {
            text = WebsocketBits.Text$.MODULE$.apply(arr);
        } else if (webSocketFrame instanceof WebsocketBits.Binary) {
            text = new WebsocketBits.Binary(arr, WebsocketBits.Binary$.MODULE$.apply$default$2());
        } else {
            throw package$.MODULE$.error("Shouldn't get here. Wrong type: " + webSocketFrame);
        }
        WebsocketBits.Text msg = text;
        p.success((Object)msg);
    }

    private void handleHead(WebsocketBits.WebSocketFrame frame, Promise<WebsocketBits.WebSocketFrame> p) {
        if (!this.queue().isEmpty()) {
            ProtocolException e = new ProtocolException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid state: Received a head frame with accumulated state: ", " frames"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.queue().length())})));
            this.logger().error("Invalid state", (Throwable)e);
            this.size_$eq(0);
            this.queue().clear();
            p.failure((Throwable)e);
        } else if (frame.last()) {
            p.success((Object)frame);
        } else {
            this.size_$eq(this.size() + frame.length());
            this.queue().$plus$eq((Object)frame);
            this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1 & Serializable & scala.Serializable)x0$3 -> {
                BoxedUnit boxedUnit;
                Try try_ = x0$3;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    WebsocketBits.WebSocketFrame f = (WebsocketBits.WebSocketFrame)success.value();
                    this.readLoop(f, p);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    boxedUnit = p.failure(t);
                } else {
                    throw new MatchError((Object)try_);
                }
                return boxedUnit;
            }, Execution$.MODULE$.directec());
        }
    }

    public Future<BoxedUnit> writeRequest(WebsocketBits.WebSocketFrame data) {
        return this.channelWrite(data);
    }

    public Future<BoxedUnit> writeRequest(Seq<WebsocketBits.WebSocketFrame> data) {
        return this.channelWrite(data);
    }

    public static final /* synthetic */ int $anonfun$compileFrame$1(byte[] arr$1, int i, WebsocketBits.WebSocketFrame f) {
        System.arraycopy(f.data(), 0, arr$1, i, f.data().length);
        return i + f.data().length;
    }

    public WSFrameAggregator() {
        Stage.$init$((Stage)this);
        Tail.$init$((Tail)this);
        Head.$init$((Head)this);
        MidStage.$init$((MidStage)this);
        this.queue = new ArrayBuffer();
        this.size = 0;
    }
}

