/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http_parser;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http_parser.BaseExceptions;
import org.http4s.blaze.http.http_parser.BodyAndHeaderParser;
import org.http4s.blaze.http.http_parser.HttpTokens;

public abstract class Http1ServerParser
extends BodyAndHeaderParser {
    private final int maxRequestLineSize;
    private LineState _lineState = LineState.START;
    private String _methodString;
    private String _uriString;

    public abstract boolean submitRequestLine(String var1, String var2, String var3, int var4, int var5);

    public final boolean requestLineComplete() {
        return this._lineState == LineState.END;
    }

    @Override
    public void reset() {
        super.reset();
        this._internalReset();
    }

    private void _internalReset() {
        this._lineState = LineState.START;
    }

    @Override
    public void shutdownParser() {
        super.shutdownParser();
        this._lineState = LineState.END;
    }

    public Http1ServerParser(int n, int n2, int n3, int n4) {
        super(n3, n2, n4, false);
        this.maxRequestLineSize = n;
        this._internalReset();
    }

    public Http1ServerParser(int n, int n2, int n3) {
        this(n, n2, n3, Integer.MAX_VALUE);
    }

    public Http1ServerParser(int n) {
        this(2048, 40960, n);
    }

    public Http1ServerParser() {
        this(10240);
    }

    @Override
    public boolean mustNotHaveBody() {
        return !this.definedContentLength() && !this.isChunked();
    }

    protected final boolean parseRequestLine(ByteBuffer byteBuffer) throws BaseExceptions.InvalidState, BaseExceptions.BadRequest {
        switch (this._lineState) {
            case START: {
                this._lineState = LineState.METHOD;
                this.resetLimit(this.maxRequestLineSize);
            }
            case METHOD: {
                char c = this.next(byteBuffer, false);
                while ('A' <= c && c <= 'Z') {
                    this.putChar(c);
                    c = this.next(byteBuffer, false);
                }
                if (c == '\uffff') {
                    return false;
                }
                this._methodString = this.getString();
                this.clearBuffer();
                if (!HttpTokens.isWhiteSpace(c)) {
                    String string = this._methodString + c;
                    this.shutdownParser();
                    throw new BaseExceptions.BadRequest("Invalid request method: '" + string + "'");
                }
                this._lineState = LineState.SPACE1;
            }
            case SPACE1: {
                char c = this.next(byteBuffer, false);
                while (c == ' ' || c == '\t') {
                    c = this.next(byteBuffer, false);
                }
                if (c == '\uffff') {
                    return false;
                }
                this.putChar(c);
                this._lineState = LineState.URI;
            }
            case URI: {
                char c = this.next(byteBuffer, false);
                while (c != ' ' && c != '\t') {
                    if (c == '\uffff') {
                        return false;
                    }
                    this.putChar(c);
                    c = this.next(byteBuffer, false);
                }
                this._uriString = this.getString();
                this.clearBuffer();
                this._lineState = LineState.SPACE2;
            }
            case SPACE2: {
                char c = this.next(byteBuffer, false);
                while (c == ' ' || c == '\t') {
                    c = this.next(byteBuffer, false);
                }
                if (c == '\uffff') {
                    return false;
                }
                if (c != 'H') {
                    this.shutdownParser();
                    throw new BaseExceptions.BadRequest("Http version started with illegal character: " + c);
                }
                this.putChar(c);
                this._lineState = LineState.REQUEST_VERSION;
            }
            case REQUEST_VERSION: {
                char c = this.next(byteBuffer, false);
                while (c != '\n') {
                    if (c == '\uffff') {
                        return false;
                    }
                    this.putChar(c);
                    c = this.next(byteBuffer, false);
                }
                int n = 1;
                int n2 = 1;
                if (!this.arrayMatches(HTTP11Bytes) && !this.arrayMatches(HTTPS11Bytes)) {
                    if (this.arrayMatches(HTTP10Bytes) || this.arrayMatches(HTTPS10Bytes)) {
                        n2 = 0;
                    } else {
                        String string = "Bad HTTP version: " + this.getString();
                        this.clearBuffer();
                        this.shutdownParser();
                        throw new BaseExceptions.BadRequest(string);
                    }
                }
                String string = this.getString(this.bufferPosition() - 4);
                this.clearBuffer();
                this._lineState = LineState.END;
                return !this.submitRequestLine(this._methodString, this._uriString, string, n, n2);
            }
        }
        throw new BaseExceptions.InvalidState("Attempted to parse Request line when already complete.LineState: '" + (Object)((Object)this._lineState) + "'");
    }

    private static enum LineState {
        START,
        METHOD,
        SPACE1,
        URI,
        SPACE2,
        REQUEST_VERSION,
        END;

    }
}

