/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http_parser;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http_parser.BaseExceptions;
import org.http4s.blaze.http.http_parser.HttpTokens;
import org.http4s.blaze.http.http_parser.ParserBase;
import org.http4s.blaze.util.BufferTools;

public abstract class BodyAndHeaderParser
extends ParserBase {
    private final int headerSizeLimit;
    private final int maxChunkSize;
    private HeaderState _hstate = HeaderState.START;
    private long _contentLength;
    private long _contentPosition;
    private ChunkState _chunkState;
    private long _chunkLength;
    private String _headerName;
    private EndOfContent _endOfContent;
    protected static final char[] HTTP10Bytes = "HTTP/1.0".toCharArray();
    protected static final char[] HTTP11Bytes = "HTTP/1.1".toCharArray();
    protected static final char[] HTTPS10Bytes = "HTTPS/1.0".toCharArray();
    protected static final char[] HTTPS11Bytes = "HTTPS/1.1".toCharArray();

    protected BodyAndHeaderParser(int n, int n2, int n3, boolean bl) {
        super(n, bl);
        this.headerSizeLimit = n2;
        this.maxChunkSize = n3;
        this._internalReset();
    }

    protected abstract boolean headerComplete(String var1, String var2) throws BaseExceptions.BadRequest;

    public abstract boolean mustNotHaveBody();

    public final boolean headersComplete() {
        return this._hstate == HeaderState.END;
    }

    public final boolean contentComplete() {
        return this.mustNotHaveBody() || this._endOfContent == EndOfContent.END || this._endOfContent == EndOfContent.NO_CONTENT;
    }

    public final boolean isChunked() {
        return this._endOfContent == EndOfContent.CHUNKED_CONTENT;
    }

    public final boolean inChunkedHeaders() {
        return this._chunkState == ChunkState.CHUNK_TRAILERS;
    }

    public final boolean definedContentLength() {
        return this._endOfContent == EndOfContent.CONTENT_LENGTH;
    }

    public final EndOfContent getContentType() {
        return this._endOfContent;
    }

    @Override
    void reset() {
        super.reset();
        this._internalReset();
    }

    private void _internalReset() {
        this._hstate = HeaderState.START;
        this._chunkState = ChunkState.START;
        this._endOfContent = EndOfContent.UNKNOWN_CONTENT;
        this._contentLength = 0L;
        this._contentPosition = 0L;
        this._chunkLength = 0L;
    }

    @Override
    public void shutdownParser() {
        this._hstate = HeaderState.END;
        this._chunkState = ChunkState.END;
        this._endOfContent = EndOfContent.END;
        super.shutdownParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected final boolean parseHeaders(ByteBuffer var1_1) throws BaseExceptions.BadRequest, BaseExceptions.InvalidState {
        while (true) {
            switch (1.$SwitchMap$org$http4s$blaze$http$http_parser$BodyAndHeaderParser$HeaderState[this._hstate.ordinal()]) {
                case 1: {
                    this._hstate = HeaderState.HEADER_IN_NAME;
                    this.resetLimit(this.headerSizeLimit);
                }
                case 2: {
                    var2_2 = this.next(var1_1, false);
                    while (var2_2 != ':' && var2_2 != '\n') {
                        if (var2_2 == '\uffff') {
                            return false;
                        }
                        this.putChar(var2_2);
                        var2_2 = this.next(var1_1, false);
                    }
                    if (this.bufferPosition() == 0) {
                        this._hstate = HeaderState.END;
                        if (this._chunkState == ChunkState.CHUNK_TRAILERS) {
                            this.shutdownParser();
                        } else if (this._endOfContent == EndOfContent.UNKNOWN_CONTENT && this.mustNotHaveBody()) {
                            this.shutdownParser();
                        }
                        return true;
                    }
                    if (var2_2 == '\n') {
                        var3_3 = this.getString();
                        this.clearBuffer();
                        if (!this.headerComplete(var3_3, "")) break;
                        return true;
                    }
                    this._headerName = this.getString();
                    this.clearBuffer();
                    this._hstate = HeaderState.HEADER_IN_VALUE;
                }
                case 3: {
                    var2_2 = this.next(var1_1, true);
                    while (var2_2 != '\n') {
                        if (var2_2 == '\uffff') {
                            return false;
                        }
                        this.putChar(var2_2);
                        var2_2 = this.next(var1_1, true);
                    }
                    try {
                        var3_3 = this.getTrimmedString();
                    }
                    catch (BaseExceptions.BadRequest var4_5) {
                        this.shutdownParser();
                        throw var4_5;
                    }
                    this.clearBuffer();
                    if (this._chunkState == ChunkState.CHUNK_TRAILERS) ** GOTO lbl75
                    if (!this._headerName.equalsIgnoreCase("Transfer-Encoding")) ** GOTO lbl55
                    if (var3_3.equalsIgnoreCase("chunked")) {
                        if (this._endOfContent != EndOfContent.END) {
                            this._endOfContent = EndOfContent.CHUNKED_CONTENT;
                        }
                    } else if (!var3_3.equalsIgnoreCase("identity")) {
                        this.shutdownParser();
                        throw new BaseExceptions.BadRequest("Unknown Transfer-Encoding: " + var3_3);
                    }
                    ** GOTO lbl75
lbl55:
                    // 1 sources

                    if (this._endOfContent == EndOfContent.CHUNKED_CONTENT || !this._headerName.equalsIgnoreCase("Content-Length")) ** GOTO lbl75
                    try {
                        var4_4 = Long.parseLong(var3_3);
                        if ((this._endOfContent == EndOfContent.NO_CONTENT || this._endOfContent == EndOfContent.CONTENT_LENGTH) && var4_4 != this._contentLength) {
                            var6_8 = this._contentLength;
                            this.shutdownParser();
                            throw new BaseExceptions.BadRequest("Duplicate Content-Length headers detected: " + var6_8 + " and " + var4_4 + "\n");
                        }
                        if (var4_4 <= 0L) ** GOTO lbl66
                        this._contentLength = var4_4;
                        this._endOfContent = EndOfContent.CONTENT_LENGTH;
                        ** GOTO lbl75
lbl66:
                        // 1 sources

                        if (var4_4 != 0L) ** GOTO lbl70
                        this._contentLength = var4_4;
                        this._endOfContent = EndOfContent.NO_CONTENT;
                        ** GOTO lbl75
lbl70:
                        // 1 sources

                        this.shutdownParser();
                        throw new BaseExceptions.BadRequest("Cannot have negative Content-Length: '" + var4_4 + "'\n");
                    }
                    catch (NumberFormatException var4_6) {
                        this.shutdownParser();
                        throw new BaseExceptions.BadRequest("Invalid Content-Length: '" + var3_3 + "'\n");
                    }
lbl75:
                    // 6 sources

                    try {
                        if (this.headerComplete(this._headerName, var3_3)) {
                            var4_7 = true;
                            return var4_7;
                        }
                        break;
                    }
                    finally {
                        this._hstate = HeaderState.HEADER_IN_NAME;
                    }
                }
                case 4: {
                    this.shutdownParser();
                    throw new BaseExceptions.InvalidState("Header parser reached invalid position.");
                }
            }
        }
    }

    protected final ByteBuffer parseContent(ByteBuffer byteBuffer) throws BaseExceptions.ParserException {
        if (this.contentComplete()) {
            throw new BaseExceptions.InvalidState("content already complete: " + (Object)((Object)this._endOfContent));
        }
        switch (this._endOfContent) {
            case UNKNOWN_CONTENT: {
                this._endOfContent = EndOfContent.EOF_CONTENT;
                this._contentLength = Long.MAX_VALUE;
                return this.parseContent(byteBuffer);
            }
            case CONTENT_LENGTH: 
            case EOF_CONTENT: {
                return this.nonChunkedContent(byteBuffer);
            }
            case CHUNKED_CONTENT: {
                return this.chunkedContent(byteBuffer);
            }
        }
        throw new BaseExceptions.InvalidState("not implemented: " + (Object)((Object)this._endOfContent));
    }

    private ByteBuffer nonChunkedContent(ByteBuffer byteBuffer) {
        long l = this._contentLength - this._contentPosition;
        int n = byteBuffer.remaining();
        if ((long)n >= l) {
            this._contentPosition += l;
            ByteBuffer byteBuffer2 = this.submitPartialBuffer(byteBuffer, (int)l);
            this.shutdownParser();
            return byteBuffer2;
        }
        if (n > 0) {
            this._contentPosition += (long)n;
            return this.submitBuffer(byteBuffer);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private ByteBuffer chunkedContent(ByteBuffer var1_1) throws BaseExceptions.BadRequest, BaseExceptions.InvalidState {
        while (true) {
            block0 : switch (1.$SwitchMap$org$http4s$blaze$http$http_parser$BodyAndHeaderParser$ChunkState[this._chunkState.ordinal()]) {
                case 1: {
                    this._chunkState = ChunkState.CHUNK_SIZE;
                    this.resetLimit(256);
                }
                case 2: {
                    if (!BodyAndHeaderParser.$assertionsDisabled && this._contentPosition != 0L) {
                        throw new AssertionError();
                    }
                    do {
                        if ((var2_2 = this.next(var1_1, false)) == '\uffff') {
                            return null;
                        }
                        if (!HttpTokens.isWhiteSpace(var2_2) && var2_2 != ';') ** GOTO lbl15
                        this._chunkState = ChunkState.CHUNK_PARAMS;
                        ** GOTO lbl26
lbl15:
                        // 1 sources

                        if (var2_2 == '\n') {
                            if (this._chunkLength == 0L) {
                                this._hstate = HeaderState.START;
                                this._chunkState = ChunkState.CHUNK_TRAILERS;
                                break block0;
                            }
                            this._chunkState = ChunkState.CHUNK;
                            break block0;
                        }
                        this._chunkLength = 16L * this._chunkLength + (long)HttpTokens.hexCharToInt(var2_2);
                    } while (this._chunkLength <= (long)this.maxChunkSize);
                    this.shutdownParser();
                    throw new BaseExceptions.BadRequest("Chunk length too large: " + this._chunkLength);
                }
lbl26:
                // 2 sources

                case 3: {
                    var2_2 = this.next(var1_1, false);
                    while (var2_2 != '\n') {
                        if (var2_2 == '\uffff') {
                            return null;
                        }
                        var2_2 = this.next(var1_1, false);
                    }
                    if (this._chunkLength == 0L) {
                        this._hstate = HeaderState.START;
                        this._chunkState = ChunkState.CHUNK_TRAILERS;
                        break;
                    }
                    this._chunkState = ChunkState.CHUNK;
                    break;
                }
                case 4: {
                    var3_3 = this._chunkLength - this._contentPosition;
                    var5_4 = var1_1.remaining();
                    if (var3_3 <= (long)var5_4) {
                        var6_5 = this.submitPartialBuffer(var1_1, (int)var3_3);
                        this._chunkLength = 0L;
                        this._contentPosition = 0L;
                        this._chunkState = ChunkState.CHUNK_LF;
                        return var6_5;
                    }
                    if (var5_4 > 0) {
                        this._contentPosition += (long)var5_4;
                        return this.submitBuffer(var1_1);
                    }
                    return null;
                }
                case 5: {
                    var2_2 = this.next(var1_1, false);
                    if (var2_2 == '\uffff') {
                        return null;
                    }
                    if (var2_2 != '\n') {
                        this.shutdownParser();
                        throw new BaseExceptions.BadRequest("Bad chunked encoding char: '" + var2_2 + "'");
                    }
                    this._chunkState = ChunkState.START;
                    break;
                }
                case 6: {
                    if (this.parseHeaders(var1_1)) {
                        return BufferTools.emptyBuffer();
                    }
                    return null;
                }
            }
        }
    }

    private ByteBuffer submitBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
        byteBuffer.position(byteBuffer.limit());
        return byteBuffer2;
    }

    private ByteBuffer submitPartialBuffer(ByteBuffer byteBuffer, int n) {
        if (n == byteBuffer.remaining()) {
            return this.submitBuffer(byteBuffer);
        }
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.position() + n;
        byteBuffer.limit(n3);
        ByteBuffer byteBuffer2 = byteBuffer.slice().asReadOnlyBuffer();
        byteBuffer.limit(n2);
        byteBuffer.position(n3);
        return byteBuffer2;
    }

    public static enum EndOfContent {
        UNKNOWN_CONTENT,
        NO_CONTENT,
        CONTENT_LENGTH,
        CHUNKED_CONTENT,
        EOF_CONTENT,
        END;

    }

    private static enum ChunkState {
        START,
        CHUNK_SIZE,
        CHUNK_PARAMS,
        CHUNK,
        CHUNK_LF,
        CHUNK_TRAILERS,
        END;

    }

    private static enum HeaderState {
        START,
        HEADER_IN_NAME,
        HEADER_IN_VALUE,
        END;

    }
}

