/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.Done;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.LoggingBus;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.impl.ExtendedActorMaterializer;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance;
import org.apache.pekko.stream.impl.SubFusingActorMaterializerImpl;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreterShell$Abort$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreterShell$AsyncInput$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreterShell$ResumeShell$;
import org.apache.pekko.stream.snapshot.InterpreterSnapshot;
import org.apache.pekko.stream.snapshot.LogicSnapshot;
import org.apache.pekko.stream.snapshot.LogicSnapshotImpl;
import org.apache.pekko.stream.snapshot.LogicSnapshotImpl$;
import org.apache.pekko.stream.snapshot.UninitializedInterpreterImpl$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Promise;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure4;
import scala.util.control.NonFatal$;

@InternalApi
public final class GraphInterpreterShell {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(GraphInterpreterShell.class.getDeclaredField("interpreter$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(GraphInterpreterShell.class.getDeclaredField("log$lzy1"));
    private GraphInterpreter.Connection[] connections;
    private GraphStageLogic[] logics;
    private final Attributes attributes;
    private final ExtendedActorMaterializer mat;
    private ActorRef self;
    private volatile Object log$lzy1;
    public final GraphInterpreterShell$AsyncInput$ AsyncInput$lzy1;
    public final GraphInterpreterShell$ResumeShell$ ResumeShell$lzy1;
    public final GraphInterpreterShell$Abort$ Abort$lzy1;
    private Function1<Object, BoxedUnit> enqueueToShortCircuit;
    private volatile Object interpreter$lzy1;
    public int org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$subscribesPending;
    private List<ActorGraphInterpreter.BatchingActorInputBoundary> inputs;
    private List<ActorGraphInterpreter.ActorOutputBoundary> outputs;
    private final int shellEventLimit;
    private final int abortLimit;
    private boolean resumeScheduled;
    private boolean interpreterCompleted;
    public boolean org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$waitingForShutdown;
    private final ResumeShell resume;

    public GraphInterpreterShell(GraphInterpreter.Connection[] connections, GraphStageLogic[] logics, Attributes attributes, ExtendedActorMaterializer mat) {
        this.connections = connections;
        this.logics = logics;
        this.attributes = attributes;
        this.mat = mat;
        this.AsyncInput$lzy1 = new GraphInterpreterShell$AsyncInput$(this);
        this.ResumeShell$lzy1 = new GraphInterpreterShell$ResumeShell$(this);
        this.Abort$lzy1 = new GraphInterpreterShell$Abort$(this);
        this.org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$subscribesPending = 0;
        this.inputs = package$.MODULE$.Nil();
        this.outputs = package$.MODULE$.Nil();
        this.shellEventLimit = ((Attributes.InputBuffer)attributes.mandatoryAttribute(ClassTag$.MODULE$.apply(Attributes.InputBuffer.class))).max() * 16;
        this.abortLimit = this.shellEventLimit() * 2;
        this.resumeScheduled = false;
        this.interpreterCompleted = false;
        this.org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$waitingForShutdown = false;
        this.resume = this.ResumeShell().apply(this);
    }

    public GraphInterpreter.Connection[] connections() {
        return this.connections;
    }

    public void connections_$eq(GraphInterpreter.Connection[] x$1) {
        this.connections = x$1;
    }

    public GraphStageLogic[] logics() {
        return this.logics;
    }

    public void logics_$eq(GraphStageLogic[] x$1) {
        this.logics = x$1;
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public ExtendedActorMaterializer mat() {
        return this.mat;
    }

    public LoggingAdapter log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingAdapter) {
            return (LoggingAdapter)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingAdapter)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingAdapter loggingAdapter = null;
                    try {
                        loggingAdapter = Logging$.MODULE$.apply((LoggingBus)this.mat().system().eventStream(), (Object)this.self, LogSource$.MODULE$.fromActorRef());
                        object2 = loggingAdapter == null ? LazyVals.NullValue$.MODULE$ : loggingAdapter;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingAdapter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final GraphInterpreterShell$AsyncInput$ AsyncInput() {
        return this.AsyncInput$lzy1;
    }

    public final GraphInterpreterShell$ResumeShell$ ResumeShell() {
        return this.ResumeShell$lzy1;
    }

    public final GraphInterpreterShell$Abort$ Abort() {
        return this.Abort$lzy1;
    }

    public GraphInterpreter interpreter() {
        Object object = this.interpreter$lzy1;
        if (object instanceof GraphInterpreter) {
            return (GraphInterpreter)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (GraphInterpreter)this.interpreter$lzyINIT1();
    }

    private Object interpreter$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.interpreter$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    GraphInterpreter graphInterpreter = null;
                    try {
                        graphInterpreter = new GraphInterpreter(this.mat(), this.log(), this.logics(), this.connections(), (Function4<GraphStageLogic, Object, Promise<Done>, Function1<Object, BoxedUnit>, BoxedUnit>)(JProcedure4 & Serializable)(logic, event, promise, handler) -> {
                            AsyncInput asyncInput = this.AsyncInput().apply(this, (GraphStageLogic)logic, event, (Promise<Done>)promise, (Function1<Object, BoxedUnit>)handler);
                            GraphInterpreter currentInterpreter = GraphInterpreter$.MODULE$.currentInterpreterOrNull();
                            if (currentInterpreter == null || currentInterpreter.context() != this.self) {
                                ActorRef actorRef = this.self;
                                actorRef.$bang((Object)asyncInput, actorRef.$bang$default$2((Object)asyncInput));
                                return;
                            }
                            this.enqueueToShortCircuit.apply((Object)asyncInput);
                        }, ((ActorAttributes.FuzzingMode)this.attributes().mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.FuzzingMode.class))).enabled(), this.self);
                        object2 = graphInterpreter == null ? LazyVals.NullValue$.MODULE$ : graphInterpreter;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.interpreter$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.interpreter$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return graphInterpreter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int shellEventLimit() {
        return this.shellEventLimit;
    }

    public boolean isInitialized() {
        return this.self != null;
    }

    public int init(ActorRef self, SubFusingActorMaterializerImpl subMat, Function1<Object, BoxedUnit> enqueueToShortCircuit, int eventLimit) {
        this.self = self;
        this.enqueueToShortCircuit = enqueueToShortCircuit;
        for (int i = 0; i < this.logics().length; ++i) {
            GraphStageLogic graphStageLogic = this.logics()[i];
            if (graphStageLogic instanceof ActorGraphInterpreter.BatchingActorInputBoundary) {
                ActorGraphInterpreter.BatchingActorInputBoundary in = (ActorGraphInterpreter.BatchingActorInputBoundary)graphStageLogic;
                in.setActor(self);
                ++this.org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$subscribesPending;
                this.inputs = this.inputs.$colon$colon((Object)in);
                continue;
            }
            if (!(graphStageLogic instanceof ActorGraphInterpreter.ActorOutputBoundary)) continue;
            ActorGraphInterpreter.ActorOutputBoundary out = (ActorGraphInterpreter.ActorOutputBoundary)graphStageLogic;
            out.setActor(self);
            out.subscribePending();
            this.outputs = this.outputs.$colon$colon((Object)out);
        }
        this.interpreter().init(subMat);
        return this.runBatch(eventLimit);
    }

    public int processEvent(ActorGraphInterpreter.BoundaryEvent event, int eventLimit) {
        this.resumeScheduled = false;
        return event.execute(eventLimit);
    }

    public boolean isTerminated() {
        return this.interpreterCompleted && this.canShutDown();
    }

    private boolean canShutDown() {
        return this.org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$subscribesPending == 0;
    }

    public void subscribeArrived() {
        --this.org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$subscribesPending;
    }

    public ResumeShell resume() {
        return this.resume;
    }

    public void sendResume(boolean sendResume) {
        this.resumeScheduled = true;
        if (sendResume) {
            ActorRef actorRef = this.self;
            actorRef.$bang((Object)this.resume(), actorRef.$bang$default$2((Object)this.resume()));
            return;
        }
        this.enqueueToShortCircuit.apply((Object)this.resume());
    }

    /*
     * WARNING - void declaration
     */
    public int runBatch(int actorEventLimit) {
        int n;
        try {
            void var3_3;
            boolean usingShellLimit = this.shellEventLimit() < actorEventLimit;
            int remainingQuota = this.interpreter().execute(Math.min(actorEventLimit, this.shellEventLimit()));
            if (this.interpreter().isCompleted()) {
                if (this.canShutDown()) {
                    this.interpreterCompleted = true;
                } else {
                    this.org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$waitingForShutdown = true;
                    FiniteDuration subscriptionTimeout = ((ActorAttributes.StreamSubscriptionTimeout)this.attributes().mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.StreamSubscriptionTimeout.class))).timeout();
                    this.mat().scheduleOnce(subscriptionTimeout, () -> {
                        ActorRef actorRef = this.self;
                        Abort abort = this.Abort().apply(this);
                        actorRef.$bang((Object)abort, actorRef.$bang$default$2((Object)abort));
                    });
                }
            } else if (this.interpreter().isSuspended() && !this.resumeScheduled) {
                this.sendResume(!usingShellLimit);
            }
            n = usingShellLimit ? actorEventLimit - this.shellEventLimit() + remainingQuota : var3_3;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.tryAbort(e);
                n = actorEventLimit - 1;
            }
            throw throwable;
        }
        return n;
    }

    public void tryAbort(Throwable ex) {
        block8: {
            Throwable throwable;
            Throwable throwable2 = ex;
            if (throwable2 instanceof ReactiveStreamsCompliance.SpecViolation) {
                ReactiveStreamsCompliance.SpecViolation s = (ReactiveStreamsCompliance.SpecViolation)((Object)throwable2);
                throwable = new IllegalStateException("Shutting down because of violation of the Reactive Streams specification.", (Throwable)((Object)s));
            } else {
                throwable = ex;
            }
            Throwable reason = throwable;
            try {
                try {
                    this.inputs.foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.onInternalError(reason));
                    this.interpreter().execute(this.abortLimit);
                    this.interpreter().finish();
                }
                catch (Throwable throwable3) {
                    Option option;
                    Throwable throwable4 = throwable3;
                    if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                        Throwable throwable5 = (Throwable)option.get();
                        break block8;
                    }
                    throw throwable3;
                }
            }
            finally {
                this.interpreterCompleted = true;
                this.outputs.foreach((Function1)(JProcedure1 & Serializable)_$6 -> _$6.fail(reason));
                this.inputs.foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.cancel(reason));
            }
        }
    }

    public InterpreterSnapshot toSnapshot() {
        if (!this.isInitialized()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.logics());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
            return UninitializedInterpreterImpl$.MODULE$.apply((Seq<LogicSnapshot>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    GraphStageLogic logic = (GraphStageLogic)tuple2._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return LogicSnapshotImpl$.MODULE$.apply(idx, logic.toString(), logic.attributes());
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(LogicSnapshotImpl.class))).toVector());
        }
        return this.interpreter().toSnapshot();
    }

    public class Abort
    implements ActorGraphInterpreter.BoundaryEvent,
    Product,
    Serializable {
        private final GraphInterpreterShell shell;
        private final /* synthetic */ GraphInterpreterShell $outer;

        public Abort(GraphInterpreterShell $outer, GraphInterpreterShell shell) {
            this.shell = shell;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Abort)) return false;
            if (((Abort)object).org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$Abort$$$outer() != this.$outer) return false;
            Abort abort = (Abort)object;
            GraphInterpreterShell graphInterpreterShell = this.shell();
            GraphInterpreterShell graphInterpreterShell2 = abort.shell();
            if (graphInterpreterShell == null) {
                if (graphInterpreterShell2 != null) {
                    return false;
                }
            } else if (!graphInterpreterShell.equals(graphInterpreterShell2)) return false;
            if (!abort.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Abort;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Abort";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shell";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public GraphInterpreterShell shell() {
            return this.shell;
        }

        @Override
        public int execute(int eventLimit) {
            if (this.$outer.org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$waitingForShutdown) {
                this.$outer.org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$subscribesPending = 0;
                FiniteDuration subscriptionTimeout = ((ActorAttributes.StreamSubscriptionTimeout)this.$outer.attributes().mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.StreamSubscriptionTimeout.class))).timeout();
                this.$outer.tryAbort(new TimeoutException(new StringBuilder(83).append("Streaming actor has been already stopped processing (normally), but not all of its ").append(new StringBuilder(66).append("inputs or outputs have been subscribed in [").append(subscriptionTimeout).append("}]. Aborting actor now.").toString()).toString()));
            }
            return 0;
        }

        @Override
        public void cancel() {
        }

        public Abort copy(GraphInterpreterShell shell) {
            return new Abort(this.$outer, shell);
        }

        public GraphInterpreterShell copy$default$1() {
            return this.shell();
        }

        public GraphInterpreterShell _1() {
            return this.shell();
        }

        public final /* synthetic */ GraphInterpreterShell org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$Abort$$$outer() {
            return this.$outer;
        }
    }

    public class AsyncInput
    implements ActorGraphInterpreter.BoundaryEvent,
    Product,
    Serializable {
        private final GraphInterpreterShell shell;
        private final GraphStageLogic logic;
        private final Object evt;
        private final Promise promise;
        private final Function1 handler;
        private final /* synthetic */ GraphInterpreterShell $outer;

        public AsyncInput(GraphInterpreterShell $outer, GraphInterpreterShell shell, GraphStageLogic logic, Object evt, Promise<Done> promise, Function1<Object, BoxedUnit> handler) {
            this.shell = shell;
            this.logic = logic;
            this.evt = evt;
            this.promise = promise;
            this.handler = handler;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AsyncInput)) return false;
            if (((AsyncInput)object).org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$AsyncInput$$$outer() != this.$outer) return false;
            AsyncInput asyncInput = (AsyncInput)object;
            GraphInterpreterShell graphInterpreterShell = this.shell();
            GraphInterpreterShell graphInterpreterShell2 = asyncInput.shell();
            if (graphInterpreterShell == null) {
                if (graphInterpreterShell2 != null) {
                    return false;
                }
            } else if (!graphInterpreterShell.equals(graphInterpreterShell2)) return false;
            GraphStageLogic graphStageLogic = this.logic();
            GraphStageLogic graphStageLogic2 = asyncInput.logic();
            if (graphStageLogic == null) {
                if (graphStageLogic2 != null) {
                    return false;
                }
            } else if (!graphStageLogic.equals(graphStageLogic2)) return false;
            if (!BoxesRunTime.equals((Object)this.evt(), (Object)asyncInput.evt())) return false;
            Promise<Done> promise = this.promise();
            Promise<Done> promise2 = asyncInput.promise();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            Function1<Object, BoxedUnit> function1 = this.handler();
            Function1<Object, BoxedUnit> function12 = asyncInput.handler();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!asyncInput.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AsyncInput;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "AsyncInput";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "shell";
                }
                case 1: {
                    return "logic";
                }
                case 2: {
                    return "evt";
                }
                case 3: {
                    return "promise";
                }
                case 4: {
                    return "handler";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public GraphInterpreterShell shell() {
            return this.shell;
        }

        public GraphStageLogic logic() {
            return this.logic;
        }

        public Object evt() {
            return this.evt;
        }

        public Promise<Done> promise() {
            return this.promise;
        }

        public Function1<Object, BoxedUnit> handler() {
            return this.handler;
        }

        @Override
        @InternalStableApi
        public int execute(int eventLimit) {
            if (!this.$outer.org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$waitingForShutdown) {
                this.$outer.interpreter().runAsyncInput(this.logic(), this.evt(), this.promise(), this.handler());
                if (eventLimit == 1 && this.$outer.interpreter().isSuspended()) {
                    this.$outer.sendResume(true);
                    return 0;
                }
                return this.$outer.runBatch(eventLimit - 1);
            }
            return eventLimit;
        }

        @Override
        public void cancel() {
        }

        public AsyncInput copy(GraphInterpreterShell shell, GraphStageLogic logic, Object evt, Promise<Done> promise, Function1<Object, BoxedUnit> handler) {
            return new AsyncInput(this.$outer, shell, logic, evt, promise, handler);
        }

        public GraphInterpreterShell copy$default$1() {
            return this.shell();
        }

        public GraphStageLogic copy$default$2() {
            return this.logic();
        }

        public Object copy$default$3() {
            return this.evt();
        }

        public Promise<Done> copy$default$4() {
            return this.promise();
        }

        public Function1<Object, BoxedUnit> copy$default$5() {
            return this.handler();
        }

        public GraphInterpreterShell _1() {
            return this.shell();
        }

        public GraphStageLogic _2() {
            return this.logic();
        }

        public Object _3() {
            return this.evt();
        }

        public Promise<Done> _4() {
            return this.promise();
        }

        public Function1<Object, BoxedUnit> _5() {
            return this.handler();
        }

        public final /* synthetic */ GraphInterpreterShell org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$AsyncInput$$$outer() {
            return this.$outer;
        }
    }

    public class ResumeShell
    implements ActorGraphInterpreter.BoundaryEvent,
    Product,
    Serializable {
        private final GraphInterpreterShell shell;
        private final /* synthetic */ GraphInterpreterShell $outer;

        public ResumeShell(GraphInterpreterShell $outer, GraphInterpreterShell shell) {
            this.shell = shell;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResumeShell)) return false;
            if (((ResumeShell)object).org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$ResumeShell$$$outer() != this.$outer) return false;
            ResumeShell resumeShell = (ResumeShell)object;
            GraphInterpreterShell graphInterpreterShell = this.shell();
            GraphInterpreterShell graphInterpreterShell2 = resumeShell.shell();
            if (graphInterpreterShell == null) {
                if (graphInterpreterShell2 != null) {
                    return false;
                }
            } else if (!graphInterpreterShell.equals(graphInterpreterShell2)) return false;
            if (!resumeShell.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResumeShell;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ResumeShell";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shell";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public GraphInterpreterShell shell() {
            return this.shell;
        }

        @Override
        public int execute(int eventLimit) {
            if (!this.$outer.org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$$waitingForShutdown) {
                if (this.$outer.interpreter().isSuspended()) {
                    return this.$outer.runBatch(eventLimit);
                }
                return eventLimit;
            }
            return eventLimit;
        }

        @Override
        public void cancel() {
        }

        public ResumeShell copy(GraphInterpreterShell shell) {
            return new ResumeShell(this.$outer, shell);
        }

        public GraphInterpreterShell copy$default$1() {
            return this.shell();
        }

        public GraphInterpreterShell _1() {
            return this.shell();
        }

        public final /* synthetic */ GraphInterpreterShell org$apache$pekko$stream$impl$fusing$GraphInterpreterShell$ResumeShell$$$outer() {
            return this.$outer;
        }
    }
}

