/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.stream.AbruptStageTerminationException;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$InputBuffer$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.SinkShape;
import org.apache.pekko.stream.SinkShape$;
import org.apache.pekko.stream.impl.Buffer;
import org.apache.pekko.stream.impl.Buffer$;
import org.apache.pekko.stream.impl.QueueSink$Cancel$;
import org.apache.pekko.stream.impl.QueueSink$Pull$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.scaladsl.SinkQueueWithCancel;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

@InternalApi
public final class QueueSink<T>
extends GraphStageWithMaterializedValue<SinkShape<T>, SinkQueueWithCancel<T>> {
    public final int org$apache$pekko$stream$impl$QueueSink$$maxConcurrentPulls;
    private final Inlet in;
    private final SinkShape shape;

    public QueueSink(int maxConcurrentPulls) {
        this.org$apache$pekko$stream$impl$QueueSink$$maxConcurrentPulls = maxConcurrentPulls;
        Predef$.MODULE$.require(maxConcurrentPulls > 0, QueueSink::$init$$$anonfun$1);
        this.in = Inlet$.MODULE$.apply("queueSink.in");
        this.shape = SinkShape$.MODULE$.of(this.in());
    }

    public Inlet<T> in() {
        return this.in;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.queueSink();
    }

    @Override
    public SinkShape<T> shape() {
        return this.shape;
    }

    public String toString() {
        return "QueueSink";
    }

    @Override
    public Tuple2<GraphStageLogic, SinkQueueWithCancel<T>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        InHandler stageLogic = new InHandler(inheritedAttributes, this){
            private final int maxBuffer;
            private final Buffer buffer;
            private final Buffer currentRequests;
            private final AsyncCallback callback;
            private final /* synthetic */ QueueSink $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.maxBuffer = inheritedAttributes$1.get(Attributes$InputBuffer$.MODULE$.apply(16, 16), ClassTag$.MODULE$.apply(Attributes.InputBuffer.class)).max();
                Predef$.MODULE$.require(this.maxBuffer() > 0, QueueSink::org$apache$pekko$stream$impl$QueueSink$$anon$4$$_$$lessinit$greater$$anonfun$2);
                this.buffer = Buffer$.MODULE$.apply(this.maxBuffer() + 1, inheritedAttributes$1);
                this.currentRequests = Buffer$.MODULE$.apply($outer.org$apache$pekko$stream$impl$QueueSink$$maxConcurrentPulls, inheritedAttributes$1);
                this.callback = this.getAsyncCallback((JProcedure1 & Serializable)x$1 -> {
                    Pull<T> pull;
                    Promise<Option<T>> promise;
                    Output output = x$1;
                    if (output instanceof Pull && (promise = (pull = QueueSink$Pull$.MODULE$.unapply((Pull)output))._1()) instanceof Promise) {
                        Promise<Option<T>> pullPromise = promise;
                        if (this.currentRequests().isFull()) {
                            pullPromise.failure((Throwable)new IllegalStateException(new StringBuilder(129).append("Too many concurrent pulls. Specified maximum is ").append($outer$1.org$apache$pekko$stream$impl$QueueSink$$maxConcurrentPulls).append(". ").append("You have to wait for one previous future to be resolved to send another request").toString()));
                            return;
                        }
                        if (this.buffer().isEmpty()) {
                            this.currentRequests().enqueue(pullPromise);
                            return;
                        }
                        if (this.buffer().used() == this.maxBuffer()) {
                            this.tryPull($outer.in());
                        }
                        this.sendDownstream(pullPromise);
                        return;
                    }
                    if (QueueSink$Cancel$.MODULE$.equals(output)) {
                        this.completeStage();
                        return;
                    }
                    throw new MatchError((Object)output);
                });
                this.setHandler($outer.in(), this);
            }

            public int maxBuffer() {
                return this.maxBuffer;
            }

            public Buffer buffer() {
                return this.buffer;
            }

            public Buffer currentRequests() {
                return this.currentRequests;
            }

            public void preStart() {
                this.setKeepGoing(true);
                this.pull(this.$outer.in());
            }

            public void sendDownstream(Promise promise) {
                Try e = (Try)this.buffer().dequeue();
                promise.complete(e);
                Try try_ = e;
                if (try_ instanceof Success) {
                    Option option = (Option)((Success)try_).value();
                    if (option instanceof Some) {
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        this.completeStage();
                        return;
                    }
                }
                if (try_ instanceof Failure) {
                    Throwable t = ((Failure)try_).exception();
                    this.failStage(t);
                    return;
                }
                throw new MatchError((Object)try_);
            }

            public void onPush() {
                this.buffer().enqueue(Success$.MODULE$.apply((Object)Some$.MODULE$.apply(this.grab(this.$outer.in()))));
                if (this.currentRequests().nonEmpty()) {
                    ((Promise)this.currentRequests().dequeue()).complete((Try)this.buffer().dequeue());
                }
                if (this.buffer().used() < this.maxBuffer()) {
                    this.pull(this.$outer.in());
                    return;
                }
            }

            public void onUpstreamFinish() {
                this.buffer().enqueue(Success$.MODULE$.apply((Object)None$.MODULE$));
                while (this.currentRequests().nonEmpty() && this.buffer().nonEmpty()) {
                    ((Promise)this.currentRequests().dequeue()).complete((Try)this.buffer().dequeue());
                }
                while (this.currentRequests().nonEmpty()) {
                    ((Promise)this.currentRequests().dequeue()).complete((Try)Success$.MODULE$.apply((Object)None$.MODULE$));
                }
                if (this.buffer().isEmpty()) {
                    this.completeStage();
                    return;
                }
            }

            public void onUpstreamFailure(Throwable ex) {
                this.buffer().enqueue(Failure$.MODULE$.apply(ex));
                while (this.currentRequests().nonEmpty() && this.buffer().nonEmpty()) {
                    ((Promise)this.currentRequests().dequeue()).complete((Try)this.buffer().dequeue());
                }
                while (this.currentRequests().nonEmpty()) {
                    ((Promise)this.currentRequests().dequeue()).complete((Try)Failure$.MODULE$.apply(ex));
                }
                if (this.buffer().isEmpty()) {
                    this.failStage(ex);
                    return;
                }
            }

            public void postStop() {
                while (this.currentRequests().nonEmpty()) {
                    ((Promise)this.currentRequests().dequeue()).failure((Throwable)new AbruptStageTerminationException(this));
                }
            }

            public Future pull() {
                Promise p = Promise$.MODULE$.apply();
                this.callback.invokeWithFeedback(QueueSink$Pull$.MODULE$.apply(p)).failed().foreach(arg_0 -> QueueSink.org$apache$pekko$stream$impl$QueueSink$$anon$4$$_$pull$$anonfun$1(p, arg_0), ExecutionContexts$.MODULE$.parasitic());
                return p.future();
            }

            public void cancel() {
                this.callback.invoke(QueueSink$Cancel$.MODULE$);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$stream$impl$QueueSink$$anon$4$$_$$lessinit$greater$$anonfun$2(), $init$$$anonfun$3(org.apache.pekko.stream.impl.QueueSink org.apache.pekko.stream.impl.QueueSink$Output ), org$apache$pekko$stream$impl$QueueSink$$anon$4$$_$pull$$anonfun$1(scala.concurrent.Promise java.lang.Throwable )}, serializedLambda);
            }
        };
        return Tuple2$.MODULE$.apply((Object)stageLogic, (Object)stageLogic);
    }

    private static final Object $init$$$anonfun$1() {
        return "Max concurrent pulls must be greater than 0";
    }

    public static final Object org$apache$pekko$stream$impl$QueueSink$$anon$4$$_$$lessinit$greater$$anonfun$2() {
        return "Buffer size must be greater than 0";
    }

    public static final /* synthetic */ Object org$apache$pekko$stream$impl$QueueSink$$anon$4$$_$pull$$anonfun$1(Promise p$4, Throwable x$1) {
        Option option;
        Throwable throwable = x$1;
        if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
            Throwable throwable2;
            Throwable e = throwable2 = (Throwable)option.get();
            return BoxesRunTime.boxToBoolean((boolean)p$4.tryFailure(e));
        }
        return BoxedUnit.UNIT;
    }

    public static interface Output<T> {
    }

    public static final class Pull<T>
    implements Output<T>,
    Product,
    Serializable {
        private final Promise promise;

        public static <T> Pull<T> apply(Promise<Option<T>> promise) {
            return QueueSink$Pull$.MODULE$.apply(promise);
        }

        public static Pull<?> fromProduct(Product product) {
            return QueueSink$Pull$.MODULE$.fromProduct(product);
        }

        public static <T> Pull<T> unapply(Pull<T> pull) {
            return QueueSink$Pull$.MODULE$.unapply(pull);
        }

        public Pull(Promise<Option<T>> promise) {
            this.promise = promise;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Pull)) return false;
            Pull pull = (Pull)object;
            Promise<Option<T>> promise = this.promise();
            Promise<Option<T>> promise2 = pull.promise();
            if (promise != null) {
                if (!promise.equals(promise2)) return false;
                return true;
            }
            if (promise2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Pull;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Pull";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "promise";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Promise<Option<T>> promise() {
            return this.promise;
        }

        public <T> Pull<T> copy(Promise<Option<T>> promise) {
            return new Pull<T>(promise);
        }

        public <T> Promise<Option<T>> copy$default$1() {
            return this.promise();
        }

        public Promise<Option<T>> _1() {
            return this.promise();
        }
    }
}

