/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.NotUsed$;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.PoisonPill$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.ActorMaterializerSettings;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.ClosedShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.InPort;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.MaterializationContext;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.Shape$;
import org.apache.pekko.stream.impl.Compose;
import org.apache.pekko.stream.impl.Concat;
import org.apache.pekko.stream.impl.Concat$;
import org.apache.pekko.stream.impl.EmptyTraversal$;
import org.apache.pekko.stream.impl.EnterIsland;
import org.apache.pekko.stream.impl.EnterIsland$;
import org.apache.pekko.stream.impl.ExitIsland$;
import org.apache.pekko.stream.impl.ExtendedActorMaterializer;
import org.apache.pekko.stream.impl.IslandTag;
import org.apache.pekko.stream.impl.IslandTracking;
import org.apache.pekko.stream.impl.MaterializeAtomic;
import org.apache.pekko.stream.impl.MaterializeAtomic$;
import org.apache.pekko.stream.impl.Phase;
import org.apache.pekko.stream.impl.PhasedFusingActorMaterializer$;
import org.apache.pekko.stream.impl.Pop$;
import org.apache.pekko.stream.impl.PopAttributes$;
import org.apache.pekko.stream.impl.PushAttributes;
import org.apache.pekko.stream.impl.PushAttributes$;
import org.apache.pekko.stream.impl.PushNotUsed$;
import org.apache.pekko.stream.impl.SeqActorName;
import org.apache.pekko.stream.impl.StreamLayout;
import org.apache.pekko.stream.impl.Transform;
import org.apache.pekko.stream.impl.Traversal;
import org.apache.pekko.stream.impl.TraversalBuilder$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public class PhasedFusingActorMaterializer
extends ExtendedActorMaterializer
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PhasedFusingActorMaterializer.class.getDeclaredField("executionContext$lzy1"));
    private final ActorSystem system;
    private final ActorMaterializerSettings settings;
    private final Attributes defaultAttributes;
    private final Dispatchers dispatchers;
    private final ActorRef supervisor;
    private final AtomicBoolean haveShutDown;
    private final SeqActorName flowNames;
    private final LoggingAdapter _logger;
    private final boolean fuzzingWarningDisabled;
    private volatile Object executionContext$lzy1;

    public static boolean Debug() {
        return PhasedFusingActorMaterializer$.MODULE$.Debug();
    }

    public static Phase<Object> DefaultPhase() {
        return PhasedFusingActorMaterializer$.MODULE$.DefaultPhase();
    }

    public static Map<IslandTag, Phase<Object>> DefaultPhases() {
        return PhasedFusingActorMaterializer$.MODULE$.DefaultPhases();
    }

    public static String MailboxConfigName() {
        return PhasedFusingActorMaterializer$.MODULE$.MailboxConfigName();
    }

    public static PhasedFusingActorMaterializer apply(ActorContext actorContext, String string, ActorMaterializerSettings actorMaterializerSettings, Attributes attributes) {
        return PhasedFusingActorMaterializer$.MODULE$.apply(actorContext, string, actorMaterializerSettings, attributes);
    }

    public static PhasedFusingActorMaterializer apply(ActorSystem actorSystem, ActorMaterializerSettings actorMaterializerSettings, Attributes attributes, Dispatchers dispatchers, ActorRef actorRef, AtomicBoolean atomicBoolean, SeqActorName seqActorName) {
        return PhasedFusingActorMaterializer$.MODULE$.apply(actorSystem, actorMaterializerSettings, attributes, dispatchers, actorRef, atomicBoolean, seqActorName);
    }

    public static PhasedFusingActorMaterializer fromProduct(Product product) {
        return PhasedFusingActorMaterializer$.MODULE$.fromProduct(product);
    }

    public static PhasedFusingActorMaterializer unapply(PhasedFusingActorMaterializer phasedFusingActorMaterializer) {
        return PhasedFusingActorMaterializer$.MODULE$.unapply(phasedFusingActorMaterializer);
    }

    public PhasedFusingActorMaterializer(ActorSystem system, ActorMaterializerSettings settings, Attributes defaultAttributes, Dispatchers dispatchers, ActorRef supervisor, AtomicBoolean haveShutDown, SeqActorName flowNames) {
        this.system = system;
        this.settings = settings;
        this.defaultAttributes = defaultAttributes;
        this.dispatchers = dispatchers;
        this.supervisor = supervisor;
        this.haveShutDown = haveShutDown;
        this.flowNames = flowNames;
        this._logger = Logging$.MODULE$.getLogger(system, (Object)this);
        this.fuzzingWarningDisabled = system.settings().config().hasPath("pekko.stream.secret-test-fuzzing-warning-disable");
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof PhasedFusingActorMaterializer)) return false;
        PhasedFusingActorMaterializer phasedFusingActorMaterializer = (PhasedFusingActorMaterializer)object;
        ActorSystem actorSystem = this.system();
        ActorSystem actorSystem2 = phasedFusingActorMaterializer.system();
        if (actorSystem == null) {
            if (actorSystem2 != null) {
                return false;
            }
        } else if (!actorSystem.equals(actorSystem2)) return false;
        ActorMaterializerSettings actorMaterializerSettings = this.settings();
        ActorMaterializerSettings actorMaterializerSettings2 = phasedFusingActorMaterializer.settings();
        if (actorMaterializerSettings == null) {
            if (actorMaterializerSettings2 != null) {
                return false;
            }
        } else if (!((Object)actorMaterializerSettings).equals(actorMaterializerSettings2)) return false;
        Attributes attributes = this.defaultAttributes();
        Attributes attributes2 = phasedFusingActorMaterializer.defaultAttributes();
        if (attributes == null) {
            if (attributes2 != null) {
                return false;
            }
        } else if (!((Object)attributes).equals(attributes2)) return false;
        Dispatchers dispatchers = this.dispatchers();
        Dispatchers dispatchers2 = phasedFusingActorMaterializer.dispatchers();
        if (dispatchers == null) {
            if (dispatchers2 != null) {
                return false;
            }
        } else if (!dispatchers.equals(dispatchers2)) return false;
        ActorRef actorRef = this.supervisor();
        ActorRef actorRef2 = phasedFusingActorMaterializer.supervisor();
        if (actorRef == null) {
            if (actorRef2 != null) {
                return false;
            }
        } else if (!actorRef.equals(actorRef2)) return false;
        AtomicBoolean atomicBoolean = this.haveShutDown();
        AtomicBoolean atomicBoolean2 = phasedFusingActorMaterializer.haveShutDown();
        if (atomicBoolean == null) {
            if (atomicBoolean2 != null) {
                return false;
            }
        } else if (!atomicBoolean.equals(atomicBoolean2)) return false;
        SeqActorName seqActorName = this.flowNames();
        SeqActorName seqActorName2 = phasedFusingActorMaterializer.flowNames();
        if (seqActorName == null) {
            if (seqActorName2 != null) {
                return false;
            }
        } else if (!seqActorName.equals(seqActorName2)) return false;
        if (!phasedFusingActorMaterializer.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof PhasedFusingActorMaterializer;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "PhasedFusingActorMaterializer";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "system";
            }
            case 1: {
                return "settings";
            }
            case 2: {
                return "defaultAttributes";
            }
            case 3: {
                return "dispatchers";
            }
            case 4: {
                return "supervisor";
            }
            case 5: {
                return "haveShutDown";
            }
            case 6: {
                return "flowNames";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    @Override
    public ActorMaterializerSettings settings() {
        return this.settings;
    }

    public Attributes defaultAttributes() {
        return this.defaultAttributes;
    }

    public Dispatchers dispatchers() {
        return this.dispatchers;
    }

    @Override
    public ActorRef supervisor() {
        return this.supervisor;
    }

    public AtomicBoolean haveShutDown() {
        return this.haveShutDown;
    }

    public SeqActorName flowNames() {
        return this.flowNames;
    }

    @Override
    public LoggingAdapter logger() {
        return this._logger;
    }

    @Override
    public void shutdown() {
        if (this.haveShutDown().compareAndSet(false, true)) {
            this.supervisor().$bang((Object)PoisonPill$.MODULE$, this.supervisor().$bang$default$2((Object)PoisonPill$.MODULE$));
            return;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.haveShutDown().get();
    }

    @Override
    public PhasedFusingActorMaterializer withNamePrefix(String name) {
        SeqActorName seqActorName = this.flowNames().copy(name);
        ActorSystem actorSystem = this.copy$default$1();
        ActorMaterializerSettings actorMaterializerSettings = this.copy$default$2();
        Attributes attributes = this.copy$default$3();
        Dispatchers dispatchers = this.copy$default$4();
        ActorRef actorRef = this.copy$default$5();
        AtomicBoolean atomicBoolean = this.copy$default$6();
        return this.copy(actorSystem, actorMaterializerSettings, attributes, dispatchers, actorRef, atomicBoolean, seqActorName);
    }

    private String createFlowName() {
        return this.flowNames().next();
    }

    @Override
    public ExecutionContextExecutor executionContext() {
        Object object = this.executionContext$lzy1;
        if (object instanceof ExecutionContextExecutor) {
            return (ExecutionContextExecutor)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ExecutionContextExecutor)this.executionContext$lzyINIT1();
    }

    private Object executionContext$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.executionContext$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MessageDispatcher messageDispatcher = null;
                    try {
                        messageDispatcher = this.dispatchers().lookup(((ActorAttributes.Dispatcher)this.defaultAttributes().mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.Dispatcher.class))).dispatcher());
                        object2 = messageDispatcher == null ? LazyVals.NullValue$.MODULE$ : messageDispatcher;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.executionContext$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return messageDispatcher;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, Runnable task) {
        return this.system().scheduler().scheduleWithFixedDelay(initialDelay, delay, task, (ExecutionContext)this.executionContext());
    }

    @Override
    public Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, Runnable task) {
        return this.system().scheduler().scheduleAtFixedRate(initialDelay, interval, task, (ExecutionContext)this.executionContext());
    }

    @Override
    public Cancellable schedulePeriodically(FiniteDuration initialDelay, FiniteDuration interval, Runnable task) {
        return this.system().scheduler().scheduleAtFixedRate(initialDelay, interval, task, (ExecutionContext)this.executionContext());
    }

    @Override
    public Cancellable scheduleOnce(FiniteDuration delay, Runnable task) {
        return this.system().scheduler().scheduleOnce(delay, task, (ExecutionContext)this.executionContext());
    }

    @Override
    public <Mat> Mat materialize(Graph<ClosedShape, Mat> _runnableGraph) {
        return this.materialize(_runnableGraph, this.defaultAttributes());
    }

    @Override
    @InternalStableApi
    public <Mat> Mat materialize(Graph<ClosedShape, Mat> _runnableGraph, Attributes defaultAttributes) {
        return this.materialize(_runnableGraph, defaultAttributes, PhasedFusingActorMaterializer$.MODULE$.DefaultPhase(), PhasedFusingActorMaterializer$.MODULE$.DefaultPhases());
    }

    @Override
    public <Mat> Mat materialize(Graph<ClosedShape, Mat> graph, Attributes defaultAttributes, Phase<Object> defaultPhase, Map<IslandTag, Phase<Object>> phases) {
        Object e;
        if (this.isShutdown()) {
            throw new IllegalStateException("Trying to materialize stream after materializer has been shutdown");
        }
        Attributes defaultAndGraphAttributes = defaultAttributes.and(graph.traversalBuilder().attributes());
        if (((ActorAttributes.FuzzingMode)defaultAndGraphAttributes.mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.FuzzingMode.class))).enabled() && !this.fuzzingWarningDisabled) {
            this._logger.warning("Fuzzing mode is enabled on this system. If you see this warning on your production system then set 'pekko.stream.materializer.debug.fuzzing-mode' to off.");
        }
        IslandTracking islandTracking = new IslandTracking(phases, this.settings(), defaultAndGraphAttributes, defaultPhase, this, new StringBuilder(1).append(this.createFlowName()).append("-").toString());
        Traversal current = graph.traversalBuilder().traversal();
        ArrayDeque<Attributes> attributesStack = new ArrayDeque<Attributes>(8);
        attributesStack.addLast(defaultAndGraphAttributes);
        ArrayDeque<Traversal> traversalStack = new ArrayDeque<Traversal>(16);
        traversalStack.addLast(current);
        ArrayDeque<Object> matValueStack = new ArrayDeque<Object>(8);
        if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
            Predef$.MODULE$.println((Object)"--- Materializing layout:");
            TraversalBuilder$.MODULE$.printTraversal(current, TraversalBuilder$.MODULE$.printTraversal$default$2());
            Predef$.MODULE$.println((Object)"--- Start materialization");
        }
        while (!traversalStack.isEmpty()) {
            current = (Traversal)traversalStack.removeLast();
            while (current != EmptyTraversal$.MODULE$) {
                Traversal nextStep = EmptyTraversal$.MODULE$;
                Traversal traversal = current;
                if (traversal instanceof MaterializeAtomic) {
                    MaterializeAtomic materializeAtomic = MaterializeAtomic$.MODULE$.unapply((MaterializeAtomic)traversal);
                    StreamLayout.AtomicModule<Shape, Object> atomicModule = materializeAtomic._1();
                    int[] nArray = materializeAtomic._2();
                    StreamLayout.AtomicModule<Shape, Object> mod = atomicModule;
                    int[] outToSlot = nArray;
                    if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(22).append("materializing module: ").append(mod).toString());
                    }
                    Tuple2<Object, Object> matAndStage = islandTracking.getCurrentPhase().materializeAtomic(mod, (Attributes)attributesStack.getLast());
                    Object logic = matAndStage._1();
                    Object matValue = matAndStage._2();
                    if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(24).append("  materialized value is ").append(matValue).toString());
                    }
                    matValueStack.addLast(matValue);
                    int stageGlobalOffset = islandTracking.getCurrentOffset();
                    this.wireInlets(islandTracking, mod, logic);
                    this.wireOutlets(islandTracking, mod, logic, stageGlobalOffset, outToSlot);
                    if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(10).append("PUSH: ").append(matValue).append(" => ").append(matValueStack).toString());
                    }
                } else if (traversal instanceof Concat) {
                    Concat concat = Concat$.MODULE$.unapply((Concat)traversal);
                    Traversal traversal2 = concat._1();
                    Traversal traversal3 = concat._2();
                    Traversal first = traversal2;
                    Traversal next = traversal3;
                    if (next != EmptyTraversal$.MODULE$) {
                        traversalStack.addLast(next);
                    }
                    nextStep = first;
                } else if (Pop$.MODULE$.equals(traversal)) {
                    Object popped = matValueStack.removeLast();
                    if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(9).append("POP: ").append(popped).append(" => ").append(matValueStack).toString());
                    }
                } else if (PushNotUsed$.MODULE$.equals(traversal)) {
                    matValueStack.addLast(NotUsed$.MODULE$);
                    if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(17).append("PUSH: NotUsed => ").append(matValueStack).toString());
                    }
                } else if (traversal instanceof Transform) {
                    Transform transform = (Transform)traversal;
                    Object prev = matValueStack.removeLast();
                    Object result = transform.apply(prev);
                    matValueStack.addLast(result);
                    if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(6).append("TRFM: ").append(matValueStack).toString());
                    }
                } else if (traversal instanceof Compose) {
                    Compose compose = (Compose)traversal;
                    Object second = matValueStack.removeLast();
                    Object first = matValueStack.removeLast();
                    Object result = compose.apply(first, second);
                    matValueStack.addLast(result);
                    if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(6).append("COMP: ").append(matValueStack).toString());
                    }
                } else if (traversal instanceof PushAttributes) {
                    Attributes attributes;
                    PushAttributes pushAttributes = PushAttributes$.MODULE$.unapply((PushAttributes)traversal);
                    Attributes attr = attributes = pushAttributes._1();
                    attributesStack.addLast(((Attributes)attributesStack.getLast()).and(attr));
                    if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                        Predef$.MODULE$.println((Object)new StringBuilder(11).append("ATTR PUSH: ").append(attr).toString());
                    }
                } else if (PopAttributes$.MODULE$.equals(traversal)) {
                    attributesStack.removeLast();
                    if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                        Predef$.MODULE$.println((Object)"ATTR POP");
                    }
                } else if (traversal instanceof EnterIsland) {
                    IslandTag islandTag;
                    EnterIsland enterIsland = EnterIsland$.MODULE$.unapply((EnterIsland)traversal);
                    IslandTag tag = islandTag = enterIsland._1();
                    islandTracking.enterIsland(tag, (Attributes)attributesStack.getLast());
                } else if (ExitIsland$.MODULE$.equals(traversal)) {
                    islandTracking.exitIsland();
                }
                current = nextStep;
            }
        }
        try {
            islandTracking.getCurrentPhase().onIslandReady();
            islandTracking.allNestedIslandsReady();
            if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                Predef$.MODULE$.println((Object)"--- Finished materialization");
            }
            e = matValueStack.peekLast();
        }
        finally {
            if (this.isShutdown()) {
                throw PhasedFusingActorMaterializer.shutdownWhileMaterializingFailure$1();
            }
        }
        return (Mat)e;
    }

    private void wireInlets(IslandTracking islandTracking, StreamLayout.AtomicModule<Shape, Object> mod, Object logic) {
        Seq<Inlet<?>> inlets = ((Shape)mod.shape()).inlets();
        if (inlets.nonEmpty()) {
            if (Shape$.MODULE$.hasOnePort(inlets)) {
                islandTracking.wireIn((InPort)inlets.head(), logic);
                return;
            }
            for (Inlet in : inlets) {
                islandTracking.wireIn(in, logic);
            }
            return;
        }
    }

    private void wireOutlets(IslandTracking islandTracking, StreamLayout.AtomicModule<Shape, Object> mod, Object logic, int stageGlobalOffset, int[] outToSlot) {
        Seq<Outlet<?>> outlets = ((Shape)mod.shape()).outlets();
        if (outlets.nonEmpty()) {
            if (Shape$.MODULE$.hasOnePort(outlets)) {
                Outlet out = (Outlet)outlets.head();
                int absoluteTargetSlot = stageGlobalOffset + outToSlot[out.id()];
                if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(17).append("  wiring offset: ").append(Predef$.MODULE$.wrapIntArray(outToSlot).mkString("[", ",", "]")).toString());
                }
                islandTracking.wireOut(out, absoluteTargetSlot, logic);
                return;
            }
            for (Outlet out : outlets) {
                int absoluteTargetSlot = stageGlobalOffset + outToSlot[out.id()];
                if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(17).append("  wiring offset: ").append(Predef$.MODULE$.wrapIntArray(outToSlot).mkString("[", ",", "]")).toString());
                }
                islandTracking.wireOut(out, absoluteTargetSlot, logic);
            }
            return;
        }
    }

    @Override
    public LoggingAdapter makeLogger(Class<Object> logSource) {
        return Logging$.MODULE$.apply(this.system(), logSource, LogSource$.MODULE$.fromAnyClass());
    }

    @Override
    @InternalApi
    public ActorRef actorOf(MaterializationContext context, Props props) {
        String string = props.dispatcher();
        Props effectiveProps = "pekko.actor.default-dispatcher".equals(string) ? props.withDispatcher(((ActorAttributes.Dispatcher)context.effectiveAttributes().mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.Dispatcher.class))).dispatcher()).withMailbox(PhasedFusingActorMaterializer$.MODULE$.MailboxConfigName()) : props;
        return this.actorOf(effectiveProps, context.islandName());
    }

    public PhasedFusingActorMaterializer copy(ActorSystem system, ActorMaterializerSettings settings, Attributes defaultAttributes, Dispatchers dispatchers, ActorRef supervisor, AtomicBoolean haveShutDown, SeqActorName flowNames) {
        return new PhasedFusingActorMaterializer(system, settings, defaultAttributes, dispatchers, supervisor, haveShutDown, flowNames);
    }

    public ActorSystem copy$default$1() {
        return this.system();
    }

    public ActorMaterializerSettings copy$default$2() {
        return this.settings();
    }

    public Attributes copy$default$3() {
        return this.defaultAttributes();
    }

    public Dispatchers copy$default$4() {
        return this.dispatchers();
    }

    public ActorRef copy$default$5() {
        return this.supervisor();
    }

    public AtomicBoolean copy$default$6() {
        return this.haveShutDown();
    }

    public SeqActorName copy$default$7() {
        return this.flowNames();
    }

    public ActorSystem _1() {
        return this.system();
    }

    public ActorMaterializerSettings _2() {
        return this.settings();
    }

    public Attributes _3() {
        return this.defaultAttributes();
    }

    public Dispatchers _4() {
        return this.dispatchers();
    }

    public ActorRef _5() {
        return this.supervisor();
    }

    public AtomicBoolean _6() {
        return this.haveShutDown();
    }

    public SeqActorName _7() {
        return this.flowNames();
    }

    private static final IllegalStateException shutdownWhileMaterializingFailure$1() {
        return new IllegalStateException("Materializer shutdown while materializing stream");
    }
}

