/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.JsonObjectParser$;
import org.apache.pekko.stream.scaladsl.Framing;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

@InternalApi
public class JsonObjectParser {
    private final int maximumObjectLength;
    private byte[] buffer;
    private int pos;
    private int start;
    private int depth;
    private boolean completedObject;
    private boolean inStringExpression;
    private boolean inBackslashEscape;
    private final byte[] outerChars;

    public static byte Backslash() {
        return JsonObjectParser$.MODULE$.Backslash();
    }

    public static byte Comma() {
        return JsonObjectParser$.MODULE$.Comma();
    }

    public static byte CurlyBraceEnd() {
        return JsonObjectParser$.MODULE$.CurlyBraceEnd();
    }

    public static byte CurlyBraceStart() {
        return JsonObjectParser$.MODULE$.CurlyBraceStart();
    }

    public static byte DoubleQuote() {
        return JsonObjectParser$.MODULE$.DoubleQuote();
    }

    public static int LineBreak() {
        return JsonObjectParser$.MODULE$.LineBreak();
    }

    public static int LineBreak2() {
        return JsonObjectParser$.MODULE$.LineBreak2();
    }

    public static int Space() {
        return JsonObjectParser$.MODULE$.Space();
    }

    public static byte SquareBraceEnd() {
        return JsonObjectParser$.MODULE$.SquareBraceEnd();
    }

    public static byte SquareBraceStart() {
        return JsonObjectParser$.MODULE$.SquareBraceStart();
    }

    public static int Tab() {
        return JsonObjectParser$.MODULE$.Tab();
    }

    public static boolean isWhitespace(byte by) {
        return JsonObjectParser$.MODULE$.isWhitespace(by);
    }

    public static int $lessinit$greater$default$1() {
        return JsonObjectParser$.MODULE$.$lessinit$greater$default$1();
    }

    public JsonObjectParser(int maximumObjectLength) {
        this.maximumObjectLength = maximumObjectLength;
        this.buffer = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE));
        this.pos = 0;
        this.start = 0;
        this.depth = 0;
        this.completedObject = false;
        this.inStringExpression = false;
        this.inBackslashEscape = false;
        this.outerChars = (byte[])Array$.MODULE$.tabulate(256, (Function1 & Serializable)i -> JsonObjectParser.$init$$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    public void offer(ByteString input) {
        byte[] oldBuffer = this.buffer;
        this.buffer = new byte[oldBuffer.length - this.start + input.size()];
        System.arraycopy(oldBuffer, this.start, this.buffer, 0, oldBuffer.length - this.start);
        input.copyToArray((Object)this.buffer, oldBuffer.length - this.start);
        this.pos -= this.start;
        this.start = 0;
    }

    public boolean isEmpty() {
        Object object = Predef$.MODULE$.byteArrayOps(this.buffer);
        return ArrayOps$.MODULE$.isEmpty$extension(object);
    }

    public boolean canComplete() {
        return this.depth == 0;
    }

    public Option<ByteString> poll() {
        None$ none$;
        try {
            boolean foundObject = this.seekObject();
            if (!foundObject) {
                none$ = None$.MODULE$;
            } else {
                int n = this.pos;
                if (-1 == n || 0 == n) {
                    none$ = None$.MODULE$;
                } else if (this.start == this.pos) {
                    none$ = None$.MODULE$;
                } else {
                    ByteString res = ByteString$.MODULE$.fromArrayUnsafe(this.buffer, this.start, this.pos - this.start);
                    this.start = this.pos;
                    none$ = Some$.MODULE$.apply((Object)res);
                }
            }
        }
        catch (ArithmeticException arithmeticException) {
            throw new Framing.FramingException(new StringBuilder(45).append("Invalid JSON encountered at position [").append(this.pos).append("] of [").append(ByteString$.MODULE$.apply(this.buffer).utf8String()).append("]").toString());
        }
        return none$;
    }

    private boolean seekObject() {
        this.completedObject = false;
        int bufSize = this.buffer.length;
        if (bufSize > 0) {
            int maxObjectLengthIndex;
            this.skipToNextObject(bufSize);
            int n = maxObjectLengthIndex = this.pos + this.maximumObjectLength < 0 ? Integer.MAX_VALUE : this.pos + this.maximumObjectLength;
            while (this.pos < bufSize && this.pos < maxObjectLengthIndex && !this.completedObject) {
                byte input = this.buffer[this.pos];
                this.proceed(input);
                ++this.pos;
            }
            if (this.pos >= maxObjectLengthIndex) {
                throw new Framing.FramingException(new StringBuilder(51).append("JSON element exceeded maximumObjectLength (").append(this.maximumObjectLength).append(" bytes)!").toString());
            }
            return this.completedObject;
        }
        return false;
    }

    private void skipToNextObject(int bufSize) {
        while (this.pos != -1 && this.pos < bufSize && this.depth == 0) {
            byte outer = this.outerChars[this.buffer[this.pos] & 0xFF];
            this.start += outer & 1;
            this.depth = (outer & 2) >> 1;
            int cfr_ignored_0 = 1 / outer;
            ++this.pos;
        }
    }

    private void proceed(byte input) {
        if (this.inStringExpression) {
            byte by = input;
            if (JsonObjectParser$.MODULE$.DoubleQuote() == by) {
                this.inStringExpression = this.inBackslashEscape;
                this.inBackslashEscape = false;
                return;
            }
            if (JsonObjectParser$.MODULE$.Backslash() == by) {
                this.inBackslashEscape = !this.inBackslashEscape;
                return;
            }
            this.inBackslashEscape = false;
            return;
        }
        byte by = input;
        if (JsonObjectParser$.MODULE$.DoubleQuote() == by) {
            this.inStringExpression = true;
            return;
        }
        if (JsonObjectParser$.MODULE$.CurlyBraceStart() == by) {
            ++this.depth;
            return;
        }
        if (JsonObjectParser$.MODULE$.CurlyBraceEnd() == by) {
            --this.depth;
            this.completedObject = this.depth == 0;
            return;
        }
    }

    private static final /* synthetic */ byte $init$$$anonfun$1(int i) {
        byte by = (byte)i;
        if (JsonObjectParser$.MODULE$.CurlyBraceStart() == by) {
            return 2;
        }
        if (JsonObjectParser$.MODULE$.SquareBraceStart() == by || JsonObjectParser$.MODULE$.SquareBraceEnd() == by || JsonObjectParser$.MODULE$.Comma() == by) {
            return 1;
        }
        byte b = by;
        if (JsonObjectParser$.MODULE$.isWhitespace(b)) {
            return 1;
        }
        return 0;
    }
}

