/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.scaladsl;

import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.impl.TraversalBuilder;

public final class GenericGraphWithChangedAttributes<S extends Shape, Mat>
implements Graph<S, Mat> {
    private final Shape shape;
    private final TraversalBuilder originalTraversalBuilder;
    private final Attributes newAttributes;

    public GenericGraphWithChangedAttributes(S shape, TraversalBuilder originalTraversalBuilder, Attributes newAttributes) {
        this.shape = shape;
        this.originalTraversalBuilder = originalTraversalBuilder;
        this.newAttributes = newAttributes;
    }

    @Override
    public S shape() {
        return (S)this.shape;
    }

    @Override
    public TraversalBuilder traversalBuilder() {
        return this.originalTraversalBuilder.setAttributes(this.newAttributes);
    }

    public String toString() {
        return new StringBuilder(35).append("GenericGraphWithChangedAttributes(").append(this.shape()).append(")").toString();
    }

    @Override
    public Graph<S, Mat> withAttributes(Attributes attr) {
        return new GenericGraphWithChangedAttributes<S, Mat>(this.shape(), this.originalTraversalBuilder, attr);
    }
}

