// auto-generated by sbt-boilerplate
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2014-2022 Lightbend Inc. <https://www.lightbend.com>
 */

package org.apache.pekko.stream.scaladsl

import org.apache.pekko.stream._
import org.apache.pekko.stream.impl.ContextPropagation
import org.apache.pekko.stream.stage._

trait ZipWithApply {

  /**
   * Create a new `ZipWith` specialized for 2 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, O](zipper: (A1, A2) => O): ZipWith2[A1, A2, O] =
    new ZipWith2(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 3 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, O](zipper: (A1, A2, A3) => O): ZipWith3[A1, A2, A3, O] =
    new ZipWith3(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 4 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, O](zipper: (A1, A2, A3, A4) => O): ZipWith4[A1, A2, A3, A4, O] =
    new ZipWith4(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 5 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, O](zipper: (A1, A2, A3, A4, A5) => O): ZipWith5[A1, A2, A3, A4, A5, O] =
    new ZipWith5(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 6 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, O](zipper: (A1, A2, A3, A4, A5, A6) => O): ZipWith6[A1, A2, A3, A4, A5, A6, O] =
    new ZipWith6(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 7 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, O](zipper: (A1, A2, A3, A4, A5, A6, A7) => O): ZipWith7[A1, A2, A3, A4, A5, A6, A7, O] =
    new ZipWith7(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 8 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8) => O): ZipWith8[A1, A2, A3, A4, A5, A6, A7, A8, O] =
    new ZipWith8(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 9 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9) => O): ZipWith9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O] =
    new ZipWith9(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 10 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) => O): ZipWith10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O] =
    new ZipWith10(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 11 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) => O): ZipWith11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O] =
    new ZipWith11(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 12 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) => O): ZipWith12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O] =
    new ZipWith12(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 13 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) => O): ZipWith13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O] =
    new ZipWith13(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 14 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) => O): ZipWith14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O] =
    new ZipWith14(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 15 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) => O): ZipWith15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O] =
    new ZipWith15(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 16 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) => O): ZipWith16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O] =
    new ZipWith16(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 17 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) => O): ZipWith17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O] =
    new ZipWith17(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 18 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) => O): ZipWith18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O] =
    new ZipWith18(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 19 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) => O): ZipWith19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O] =
    new ZipWith19(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 20 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) => O): ZipWith20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O] =
    new ZipWith20(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 21 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) => O): ZipWith21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O] =
    new ZipWith21(zipper)
  

  /**
   * Create a new `ZipWith` specialized for 22 inputs.
   *
   * @param zipper zipping-function from the input values to the output value
   */
  def apply[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O](zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) => O): ZipWith22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O] =
    new ZipWith22(zipper)
  

}

/** `ZipWith` specialized for 2 inputs */
class ZipWith2[A1, A2, O] (val zipper: (A1, A2) => O) extends GraphStage[FanInShape2[A1, A2, O]] {
  override def initialAttributes = Attributes.name("ZipWith2")
  override val shape: FanInShape2[A1, A2, O] = new FanInShape2[A1, A2, O]("ZipWith2")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith2"

}

/** `ZipWith` specialized for 3 inputs */
class ZipWith3[A1, A2, A3, O] (val zipper: (A1, A2, A3) => O) extends GraphStage[FanInShape3[A1, A2, A3, O]] {
  override def initialAttributes = Attributes.name("ZipWith3")
  override val shape: FanInShape3[A1, A2, A3, O] = new FanInShape3[A1, A2, A3, O]("ZipWith3")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith3"

}

/** `ZipWith` specialized for 4 inputs */
class ZipWith4[A1, A2, A3, A4, O] (val zipper: (A1, A2, A3, A4) => O) extends GraphStage[FanInShape4[A1, A2, A3, A4, O]] {
  override def initialAttributes = Attributes.name("ZipWith4")
  override val shape: FanInShape4[A1, A2, A3, A4, O] = new FanInShape4[A1, A2, A3, A4, O]("ZipWith4")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith4"

}

/** `ZipWith` specialized for 5 inputs */
class ZipWith5[A1, A2, A3, A4, A5, O] (val zipper: (A1, A2, A3, A4, A5) => O) extends GraphStage[FanInShape5[A1, A2, A3, A4, A5, O]] {
  override def initialAttributes = Attributes.name("ZipWith5")
  override val shape: FanInShape5[A1, A2, A3, A4, A5, O] = new FanInShape5[A1, A2, A3, A4, A5, O]("ZipWith5")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith5"

}

/** `ZipWith` specialized for 6 inputs */
class ZipWith6[A1, A2, A3, A4, A5, A6, O] (val zipper: (A1, A2, A3, A4, A5, A6) => O) extends GraphStage[FanInShape6[A1, A2, A3, A4, A5, A6, O]] {
  override def initialAttributes = Attributes.name("ZipWith6")
  override val shape: FanInShape6[A1, A2, A3, A4, A5, A6, O] = new FanInShape6[A1, A2, A3, A4, A5, A6, O]("ZipWith6")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith6"

}

/** `ZipWith` specialized for 7 inputs */
class ZipWith7[A1, A2, A3, A4, A5, A6, A7, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7) => O) extends GraphStage[FanInShape7[A1, A2, A3, A4, A5, A6, A7, O]] {
  override def initialAttributes = Attributes.name("ZipWith7")
  override val shape: FanInShape7[A1, A2, A3, A4, A5, A6, A7, O] = new FanInShape7[A1, A2, A3, A4, A5, A6, A7, O]("ZipWith7")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith7"

}

/** `ZipWith` specialized for 8 inputs */
class ZipWith8[A1, A2, A3, A4, A5, A6, A7, A8, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8) => O) extends GraphStage[FanInShape8[A1, A2, A3, A4, A5, A6, A7, A8, O]] {
  override def initialAttributes = Attributes.name("ZipWith8")
  override val shape: FanInShape8[A1, A2, A3, A4, A5, A6, A7, A8, O] = new FanInShape8[A1, A2, A3, A4, A5, A6, A7, A8, O]("ZipWith8")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith8"

}

/** `ZipWith` specialized for 9 inputs */
class ZipWith9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9) => O) extends GraphStage[FanInShape9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O]] {
  override def initialAttributes = Attributes.name("ZipWith9")
  override val shape: FanInShape9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O] = new FanInShape9[A1, A2, A3, A4, A5, A6, A7, A8, A9, O]("ZipWith9")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith9"

}

/** `ZipWith` specialized for 10 inputs */
class ZipWith10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) => O) extends GraphStage[FanInShape10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O]] {
  override def initialAttributes = Attributes.name("ZipWith10")
  override val shape: FanInShape10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O] = new FanInShape10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, O]("ZipWith10")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith10"

}

/** `ZipWith` specialized for 11 inputs */
class ZipWith11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) => O) extends GraphStage[FanInShape11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O]] {
  override def initialAttributes = Attributes.name("ZipWith11")
  override val shape: FanInShape11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O] = new FanInShape11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, O]("ZipWith11")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith11"

}

/** `ZipWith` specialized for 12 inputs */
class ZipWith12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) => O) extends GraphStage[FanInShape12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O]] {
  override def initialAttributes = Attributes.name("ZipWith12")
  override val shape: FanInShape12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O] = new FanInShape12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, O]("ZipWith12")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith12"

}

/** `ZipWith` specialized for 13 inputs */
class ZipWith13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) => O) extends GraphStage[FanInShape13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O]] {
  override def initialAttributes = Attributes.name("ZipWith13")
  override val shape: FanInShape13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O] = new FanInShape13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, O]("ZipWith13")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11), grab(in12)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
      pull(in12)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in12, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (12 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in12)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith13"

}

/** `ZipWith` specialized for 14 inputs */
class ZipWith14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) => O) extends GraphStage[FanInShape14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O]] {
  override def initialAttributes = Attributes.name("ZipWith14")
  override val shape: FanInShape14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O] = new FanInShape14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, O]("ZipWith14")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11), grab(in12), grab(in13)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
      pull(in12)
      pull(in13)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in12, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (12 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in12)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in13, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (13 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in13)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith14"

}

/** `ZipWith` specialized for 15 inputs */
class ZipWith15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) => O) extends GraphStage[FanInShape15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O]] {
  override def initialAttributes = Attributes.name("ZipWith15")
  override val shape: FanInShape15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O] = new FanInShape15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, O]("ZipWith15")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11), grab(in12), grab(in13), grab(in14)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
      pull(in12)
      pull(in13)
      pull(in14)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in12, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (12 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in12)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in13, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (13 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in13)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in14, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (14 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in14)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith15"

}

/** `ZipWith` specialized for 16 inputs */
class ZipWith16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) => O) extends GraphStage[FanInShape16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O]] {
  override def initialAttributes = Attributes.name("ZipWith16")
  override val shape: FanInShape16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O] = new FanInShape16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, O]("ZipWith16")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11), grab(in12), grab(in13), grab(in14), grab(in15)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
      pull(in12)
      pull(in13)
      pull(in14)
      pull(in15)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in12, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (12 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in12)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in13, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (13 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in13)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in14, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (14 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in14)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in15, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (15 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in15)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith16"

}

/** `ZipWith` specialized for 17 inputs */
class ZipWith17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) => O) extends GraphStage[FanInShape17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O]] {
  override def initialAttributes = Attributes.name("ZipWith17")
  override val shape: FanInShape17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O] = new FanInShape17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, O]("ZipWith17")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11), grab(in12), grab(in13), grab(in14), grab(in15), grab(in16)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
      pull(in12)
      pull(in13)
      pull(in14)
      pull(in15)
      pull(in16)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in12, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (12 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in12)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in13, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (13 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in13)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in14, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (14 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in14)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in15, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (15 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in15)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in16, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (16 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in16)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith17"

}

/** `ZipWith` specialized for 18 inputs */
class ZipWith18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) => O) extends GraphStage[FanInShape18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O]] {
  override def initialAttributes = Attributes.name("ZipWith18")
  override val shape: FanInShape18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O] = new FanInShape18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, O]("ZipWith18")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16
  val in17: Inlet[A18] = shape.in17

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11), grab(in12), grab(in13), grab(in14), grab(in15), grab(in16), grab(in17)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
        pull(in17)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
      pull(in12)
      pull(in13)
      pull(in14)
      pull(in15)
      pull(in16)
      pull(in17)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in12, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (12 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in12)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in13, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (13 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in13)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in14, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (14 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in14)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in15, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (15 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in15)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in16, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (16 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in16)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in17, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (17 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in17)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith18"

}

/** `ZipWith` specialized for 19 inputs */
class ZipWith19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19) => O) extends GraphStage[FanInShape19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O]] {
  override def initialAttributes = Attributes.name("ZipWith19")
  override val shape: FanInShape19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O] = new FanInShape19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, O]("ZipWith19")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16
  val in17: Inlet[A18] = shape.in17
  val in18: Inlet[A19] = shape.in18

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11), grab(in12), grab(in13), grab(in14), grab(in15), grab(in16), grab(in17), grab(in18)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
        pull(in17)
        pull(in18)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
      pull(in12)
      pull(in13)
      pull(in14)
      pull(in15)
      pull(in16)
      pull(in17)
      pull(in18)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in12, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (12 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in12)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in13, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (13 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in13)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in14, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (14 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in14)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in15, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (15 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in15)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in16, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (16 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in16)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in17, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (17 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in17)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in18, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (18 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in18)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith19"

}

/** `ZipWith` specialized for 20 inputs */
class ZipWith20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20) => O) extends GraphStage[FanInShape20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O]] {
  override def initialAttributes = Attributes.name("ZipWith20")
  override val shape: FanInShape20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O] = new FanInShape20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, O]("ZipWith20")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16
  val in17: Inlet[A18] = shape.in17
  val in18: Inlet[A19] = shape.in18
  val in19: Inlet[A20] = shape.in19

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11), grab(in12), grab(in13), grab(in14), grab(in15), grab(in16), grab(in17), grab(in18), grab(in19)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
        pull(in17)
        pull(in18)
        pull(in19)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
      pull(in12)
      pull(in13)
      pull(in14)
      pull(in15)
      pull(in16)
      pull(in17)
      pull(in18)
      pull(in19)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in12, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (12 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in12)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in13, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (13 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in13)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in14, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (14 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in14)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in15, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (15 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in15)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in16, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (16 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in16)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in17, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (17 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in17)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in18, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (18 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in18)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in19, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (19 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in19)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith20"

}

/** `ZipWith` specialized for 21 inputs */
class ZipWith21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21) => O) extends GraphStage[FanInShape21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O]] {
  override def initialAttributes = Attributes.name("ZipWith21")
  override val shape: FanInShape21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O] = new FanInShape21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, O]("ZipWith21")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16
  val in17: Inlet[A18] = shape.in17
  val in18: Inlet[A19] = shape.in18
  val in19: Inlet[A20] = shape.in19
  val in20: Inlet[A21] = shape.in20

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11), grab(in12), grab(in13), grab(in14), grab(in15), grab(in16), grab(in17), grab(in18), grab(in19), grab(in20)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
        pull(in17)
        pull(in18)
        pull(in19)
        pull(in20)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
      pull(in12)
      pull(in13)
      pull(in14)
      pull(in15)
      pull(in16)
      pull(in17)
      pull(in18)
      pull(in19)
      pull(in20)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in12, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (12 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in12)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in13, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (13 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in13)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in14, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (14 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in14)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in15, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (15 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in15)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in16, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (16 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in16)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in17, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (17 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in17)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in18, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (18 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in18)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in19, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (19 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in19)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in20, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (20 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in20)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith21"

}

/** `ZipWith` specialized for 22 inputs */
class ZipWith22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O] (val zipper: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22) => O) extends GraphStage[FanInShape22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O]] {
  override def initialAttributes = Attributes.name("ZipWith22")
  override val shape: FanInShape22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O] = new FanInShape22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22, O]("ZipWith22")
  def out: Outlet[O] = shape.out
  val in0: Inlet[A1] = shape.in0
  val in1: Inlet[A2] = shape.in1
  val in2: Inlet[A3] = shape.in2
  val in3: Inlet[A4] = shape.in3
  val in4: Inlet[A5] = shape.in4
  val in5: Inlet[A6] = shape.in5
  val in6: Inlet[A7] = shape.in6
  val in7: Inlet[A8] = shape.in7
  val in8: Inlet[A9] = shape.in8
  val in9: Inlet[A10] = shape.in9
  val in10: Inlet[A11] = shape.in10
  val in11: Inlet[A12] = shape.in11
  val in12: Inlet[A13] = shape.in12
  val in13: Inlet[A14] = shape.in13
  val in14: Inlet[A15] = shape.in14
  val in15: Inlet[A16] = shape.in15
  val in16: Inlet[A17] = shape.in16
  val in17: Inlet[A18] = shape.in17
  val in18: Inlet[A19] = shape.in18
  val in19: Inlet[A20] = shape.in19
  val in20: Inlet[A21] = shape.in20
  val in21: Inlet[A22] = shape.in21

  override def createLogic(inheritedAttributes: Attributes): GraphStageLogic = new GraphStageLogic(shape) {
    var pending = 0
    // Without this field the completion signalling would take one extra pull
    var willShutDown = false
    private val contextPropagation = ContextPropagation()

    private def pushAll(): Unit = {
      contextPropagation.resumeContext()
      push(out, zipper(grab(in0), grab(in1), grab(in2), grab(in3), grab(in4), grab(in5), grab(in6), grab(in7), grab(in8), grab(in9), grab(in10), grab(in11), grab(in12), grab(in13), grab(in14), grab(in15), grab(in16), grab(in17), grab(in18), grab(in19), grab(in20), grab(in21)))
      if (willShutDown) completeStage()
      else {
        pull(in0)
        pull(in1)
        pull(in2)
        pull(in3)
        pull(in4)
        pull(in5)
        pull(in6)
        pull(in7)
        pull(in8)
        pull(in9)
        pull(in10)
        pull(in11)
        pull(in12)
        pull(in13)
        pull(in14)
        pull(in15)
        pull(in16)
        pull(in17)
        pull(in18)
        pull(in19)
        pull(in20)
        pull(in21)
      }
    }

    override def preStart(): Unit = {
      pull(in0)
      pull(in1)
      pull(in2)
      pull(in3)
      pull(in4)
      pull(in5)
      pull(in6)
      pull(in7)
      pull(in8)
      pull(in9)
      pull(in10)
      pull(in11)
      pull(in12)
      pull(in13)
      pull(in14)
      pull(in15)
      pull(in16)
      pull(in17)
      pull(in18)
      pull(in19)
      pull(in20)
      pull(in21)
    }

    setHandler(in0, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (0 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in0)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in1, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (1 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in1)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in2, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (2 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in2)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in3, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (3 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in3)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in4, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (4 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in4)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in5, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (5 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in5)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in6, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (6 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in6)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in7, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (7 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in7)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in8, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (8 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in8)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in9, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (9 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in9)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in10, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (10 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in10)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in11, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (11 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in11)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in12, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (12 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in12)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in13, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (13 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in13)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in14, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (14 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in14)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in15, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (15 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in15)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in16, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (16 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in16)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in17, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (17 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in17)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in18, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (18 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in18)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in19, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (19 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in19)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in20, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (20 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in20)) completeStage()
        willShutDown = true
      }

    })
    setHandler(in21, new InHandler {
      override def onPush(): Unit = {
        // Only one context can be propagated. Picked the first element as an arbitrary but deterministic choice.
        if (21 == 0) contextPropagation.suspendContext()
        pending -= 1
        if (pending == 0) pushAll()
      }

      override def onUpstreamFinish(): Unit = {
        if (!isAvailable(in21)) completeStage()
        willShutDown = true
      }

    })

    setHandler(out, new OutHandler {
      override def onPull(): Unit = {
        pending += shape.inlets.size
        if (pending == 0) pushAll()
      }
    })
  }

  override def toString = "ZipWith22"

}

