// auto-generated by sbt-boilerplate
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2015-2022 Lightbend Inc. <https://www.lightbend.com>
 */

package org.apache.pekko.stream.javadsl

import org.apache.pekko.stream.scaladsl
import org.apache.pekko.stream.{ Shape, Graph }
import org.apache.pekko.japi.function
import org.apache.pekko.NotUsed

private[stream] abstract class GraphCreate {
  /**
   * Creates a new [[Graph]] of the given [[Shape]] by passing a [[GraphDSL.Builder]] to the given create function.
   */
  def create[S <: Shape](block: function.Function[GraphDSL.Builder[NotUsed], S]): Graph[S, NotUsed] =
    scaladsl.GraphDSL.create() { b => block.apply(b.asJava) }

  /**
   * Creates a new [[Graph]] by importing the given graph `g1` and its [[Shape]]
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create[S1 <: Shape, S <: Shape, M](g1: Graph[S1, M],
      block: function.Function2[GraphDSL.Builder[M], S1, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1) { b => s => block.apply(b.asJava, s) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create[S1 <: Shape, S2 <: Shape, S <: Shape, M1, M2, M](g1: Graph[S1, M1], g2: Graph[S2, M2], combineMat: function.Function2[M1, M2, M],
      block: function.Function3[GraphDSL.Builder[M], S1, S2, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2)(combineMat.apply) { b => (s1, s2) => block.apply(b.asJava, s1, s2) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create3[S1 <: Shape, S2 <: Shape, S3 <: Shape, S <: Shape, M1, M2, M3, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], combineMat: function.Function3[M1, M2, M3, M],
      block: function.Function4[GraphDSL.Builder[M], S1, S2, S3, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3)(combineMat.apply) { b => (s1, s2, s3) => block.apply(b.asJava, s1, s2, s3) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create4[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S <: Shape, M1, M2, M3, M4, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], combineMat: function.Function4[M1, M2, M3, M4, M],
      block: function.Function5[GraphDSL.Builder[M], S1, S2, S3, S4, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4)(combineMat.apply) { b => (s1, s2, s3, s4) => block.apply(b.asJava, s1, s2, s3, s4) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create5[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], combineMat: function.Function5[M1, M2, M3, M4, M5, M],
      block: function.Function6[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5)(combineMat.apply) { b => (s1, s2, s3, s4, s5) => block.apply(b.asJava, s1, s2, s3, s4, s5) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create6[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], combineMat: function.Function6[M1, M2, M3, M4, M5, M6, M],
      block: function.Function7[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create7[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], combineMat: function.Function7[M1, M2, M3, M4, M5, M6, M7, M],
      block: function.Function8[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create8[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], combineMat: function.Function8[M1, M2, M3, M4, M5, M6, M7, M8, M],
      block: function.Function9[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create9[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], combineMat: function.Function9[M1, M2, M3, M4, M5, M6, M7, M8, M9, M],
      block: function.Function10[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create10[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], combineMat: function.Function10[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M],
      block: function.Function11[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create11[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], combineMat: function.Function11[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M],
      block: function.Function12[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create12[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], combineMat: function.Function12[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M],
      block: function.Function13[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11, g12)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create13[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], combineMat: function.Function13[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M],
      block: function.Function14[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11, g12, g13)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create14[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], combineMat: function.Function14[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M],
      block: function.Function15[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11, g12, g13, g14)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create15[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], combineMat: function.Function15[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M],
      block: function.Function16[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11, g12, g13, g14, g15)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create16[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], combineMat: function.Function16[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M],
      block: function.Function17[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11, g12, g13, g14, g15, g16)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create17[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17], combineMat: function.Function17[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M],
      block: function.Function18[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11, g12, g13, g14, g15, g16, g17)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create18[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape, S18 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17], g18: Graph[S18, M18], combineMat: function.Function18[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M],
      block: function.Function19[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11, g12, g13, g14, g15, g16, g17, g18)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create19[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape, S18 <: Shape, S19 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17], g18: Graph[S18, M18], g19: Graph[S19, M19], combineMat: function.Function19[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M],
      block: function.Function20[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18, S19, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11, g12, g13, g14, g15, g16, g17, g18, g19)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create20[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape, S18 <: Shape, S19 <: Shape, S20 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17], g18: Graph[S18, M18], g19: Graph[S19, M19], g20: Graph[S20, M20], combineMat: function.Function20[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M],
      block: function.Function21[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18, S19, S20, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11, g12, g13, g14, g15, g16, g17, g18, g19, g20)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20) }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def create21[S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape, S18 <: Shape, S19 <: Shape, S20 <: Shape, S21 <: Shape, S <: Shape, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M21, M](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17], g18: Graph[S18, M18], g19: Graph[S19, M19], g20: Graph[S20, M20], g21: Graph[S21, M21], combineMat: function.Function21[M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M21, M],
      block: function.Function22[GraphDSL.Builder[M], S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18, S19, S20, S21, S]): Graph[S, M] =
    scaladsl.GraphDSL.createGraph(g1, g2, g3, g4, g5, g6, g7, g8, g9, g10, g11, g12, g13, g14, g15, g16, g17, g18, g19, g20, g21)(combineMat.apply) { b => (s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21) => block.apply(b.asJava, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21) }
}
