/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.headers.Timeout;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple1;
import scala.Tuple1$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public interface TimeoutDirectives {
    public static Directive extractRequestTimeout$(TimeoutDirectives $this) {
        return $this.extractRequestTimeout();
    }

    default public Directive<Tuple1<Duration>> extractRequestTimeout() {
        return Directive$.MODULE$.apply((Function1 & Serializable)inner -> (Function1 & Serializable)ctx -> {
            Duration.Infinite infinite;
            Option option = ctx.request().header(ClassTag$.MODULE$.apply(Timeout.minusAccess.class));
            if (option instanceof Some) {
                Timeout.minusAccess t = (Timeout.minusAccess)((Some)option).value();
                infinite = t.timeoutAccess().getTimeout();
            } else {
                ctx.log().warning("extractRequestTimeout was used in route however no request-timeout is set!");
                infinite = Duration$.MODULE$.Inf();
            }
            Duration.Infinite timeout = infinite;
            return (Future)((Function1)inner.apply((Object)Tuple1$.MODULE$.apply((Object)timeout))).apply(ctx);
        }, Tuple$.MODULE$.forTuple1());
    }

    public static Directive withoutRequestTimeout$(TimeoutDirectives $this) {
        return $this.withoutRequestTimeout();
    }

    default public Directive<BoxedUnit> withoutRequestTimeout() {
        return this.withRequestTimeout((Duration)Duration$.MODULE$.Inf());
    }

    public static Directive withRequestTimeout$(TimeoutDirectives $this, Duration timeout) {
        return $this.withRequestTimeout(timeout);
    }

    default public Directive<BoxedUnit> withRequestTimeout(Duration timeout) {
        return this.withRequestTimeout(timeout, (Option<Function1<HttpRequest, HttpResponse>>)None$.MODULE$);
    }

    public static Directive withRequestTimeout$(TimeoutDirectives $this, Duration timeout, Function1 handler) {
        return $this.withRequestTimeout(timeout, (Function1<HttpRequest, HttpResponse>)handler);
    }

    default public Directive<BoxedUnit> withRequestTimeout(Duration timeout, Function1<HttpRequest, HttpResponse> handler) {
        return this.withRequestTimeout(timeout, (Option<Function1<HttpRequest, HttpResponse>>)Some$.MODULE$.apply(handler));
    }

    public static Directive withRequestTimeout$(TimeoutDirectives $this, Duration timeout, Option handler) {
        return $this.withRequestTimeout(timeout, (Option<Function1<HttpRequest, HttpResponse>>)handler);
    }

    default public Directive<BoxedUnit> withRequestTimeout(Duration timeout, Option<Function1<HttpRequest, HttpResponse>> handler) {
        return Directive$.MODULE$.apply((Function1 & Serializable)inner -> (Function1 & Serializable)ctx -> {
            Option option = ctx.request().header(ClassTag$.MODULE$.apply(Timeout.minusAccess.class));
            if (option instanceof Some) {
                Timeout.minusAccess t = (Timeout.minusAccess)((Some)option).value();
                Option option2 = handler;
                if (option2 instanceof Some) {
                    Function1 h = (Function1)((Some)option2).value();
                    t.timeoutAccess().update(timeout, h);
                } else {
                    t.timeoutAccess().updateTimeout(timeout);
                }
            } else {
                ctx.log().warning("withRequestTimeout was used in route however no request-timeout is set!");
            }
            return (Future)((Function1)inner.apply((Object)BoxedUnit.UNIT)).apply(ctx);
        }, Tuple$.MODULE$.forUnit());
    }

    public static Directive withRequestTimeoutResponse$(TimeoutDirectives $this, Function1 handler) {
        return $this.withRequestTimeoutResponse((Function1<HttpRequest, HttpResponse>)handler);
    }

    default public Directive<BoxedUnit> withRequestTimeoutResponse(Function1<HttpRequest, HttpResponse> handler) {
        return Directive$.MODULE$.apply((Function1 & Serializable)inner -> (Function1 & Serializable)ctx -> {
            Option option = ctx.request().header(ClassTag$.MODULE$.apply(Timeout.minusAccess.class));
            if (option instanceof Some) {
                Timeout.minusAccess t = (Timeout.minusAccess)((Some)option).value();
                t.timeoutAccess().updateHandler(handler);
            } else {
                ctx.log().warning("withRequestTimeoutResponse was used in route however no request-timeout is set!");
            }
            return (Future)((Function1)inner.apply((Object)BoxedUnit.UNIT)).apply(ctx);
        }, Tuple$.MODULE$.forUnit());
    }
}

