/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.Serializable;
import org.apache.pekko.http.scaladsl.model.headers.Authorization;
import org.apache.pekko.http.scaladsl.model.headers.Authorization$;
import org.apache.pekko.http.scaladsl.model.headers.BasicHttpCredentials;
import org.apache.pekko.http.scaladsl.model.headers.HttpChallenge;
import org.apache.pekko.http.scaladsl.model.headers.HttpChallenges$;
import org.apache.pekko.http.scaladsl.model.headers.HttpCredentials;
import org.apache.pekko.http.scaladsl.model.headers.ModeledCompanion;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken$;
import org.apache.pekko.http.scaladsl.server.AuthenticationFailedRejection;
import org.apache.pekko.http.scaladsl.server.AuthenticationFailedRejection$;
import org.apache.pekko.http.scaladsl.server.AuthenticationFailedRejection$CredentialsMissing$;
import org.apache.pekko.http.scaladsl.server.AuthenticationFailedRejection$CredentialsRejected$;
import org.apache.pekko.http.scaladsl.server.AuthorizationFailedRejection$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directive$SingleValueTransformers$;
import org.apache.pekko.http.scaladsl.server.Directives$;
import org.apache.pekko.http.scaladsl.server.Rejection;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.StandardRoute$;
import org.apache.pekko.http.scaladsl.server.directives.AuthenticationDirective;
import org.apache.pekko.http.scaladsl.server.directives.AuthenticationDirective$;
import org.apache.pekko.http.scaladsl.server.directives.AuthenticationResult$;
import org.apache.pekko.http.scaladsl.server.directives.BasicDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.Credentials;
import org.apache.pekko.http.scaladsl.server.directives.Credentials$;
import org.apache.pekko.http.scaladsl.server.directives.FutureDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.HeaderDirectives$;
import org.apache.pekko.http.scaladsl.server.directives.HeaderMagnet$;
import org.apache.pekko.http.scaladsl.server.directives.OnSuccessMagnet$;
import org.apache.pekko.http.scaladsl.server.directives.ParameterDirectives$ParamSpec$;
import org.apache.pekko.http.scaladsl.server.directives.RouteDirectives$;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import org.apache.pekko.http.scaladsl.server.util.Tupler$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.http.scaladsl.util.FastFuture;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple1;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public interface SecurityDirectives {
    public static Directive extractCredentials$(SecurityDirectives $this) {
        return $this.extractCredentials();
    }

    default public Directive<Tuple1<Option<HttpCredentials>>> extractCredentials() {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(HeaderDirectives$.MODULE$.optionalHeaderValueByType(HeaderMagnet$.MODULE$.fromCompanionNormalHeader((ModeledCompanion)Authorization$.MODULE$, ClassTag$.MODULE$.apply(Authorization.class))));
        return Directive$SingleValueTransformers$.MODULE$.map$extension(directive, (Function1 & Serializable)_$1 -> _$1.map((Function1 & Serializable)_$2 -> _$2.credentials()), Tupler$.MODULE$.forAnyRef());
    }

    public static AuthenticationDirective authenticateBasic$(SecurityDirectives $this, String realm, Function1 authenticator) {
        return $this.authenticateBasic(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateBasic(String realm, Function1<Credentials, Option<T>> authenticator) {
        return this.authenticateBasicAsync(realm, (Function1 & Serializable)cred -> (Future)FastFuture$.MODULE$.successful().apply(authenticator.apply(cred)));
    }

    public static AuthenticationDirective authenticateBasicAsync$(SecurityDirectives $this, String realm, Function1 authenticator) {
        return $this.authenticateBasicAsync(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateBasicAsync(String realm, Function1<Credentials, Future<Option<T>>> authenticator) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractExecutionContext());
        return AuthenticationDirective$.MODULE$.apply(Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)ec -> (Directive)((Object)this.authenticateOrRejectWithChallenge((Function1 & Serializable)cred -> {
            Future future = FastFuture$.MODULE$.EnhancedFuture((Future)authenticator.apply((Object)Credentials$.MODULE$.apply((Option<HttpCredentials>)cred)));
            Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
            return FastFuture$.MODULE$.map$extension(future2, (Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    Object t = ((Some)option).value();
                    return AuthenticationResult$.MODULE$.success(t);
                }
                if (None$.MODULE$.equals(option)) {
                    return AuthenticationResult$.MODULE$.failWithChallenge(HttpChallenges$.MODULE$.basic(realm));
                }
                throw new MatchError((Object)option);
            }, (ExecutionContext)ec);
        }, ClassTag$.MODULE$.apply(BasicHttpCredentials.class))), Tuple$.MODULE$.forTuple1()));
    }

    public static AuthenticationDirective authenticateBasicPF$(SecurityDirectives $this, String realm, PartialFunction authenticator) {
        return $this.authenticateBasicPF(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateBasicPF(String realm, PartialFunction<Credentials, T> authenticator) {
        return this.authenticateBasic(realm, authenticator.lift());
    }

    public static AuthenticationDirective authenticateBasicPFAsync$(SecurityDirectives $this, String realm, PartialFunction authenticator) {
        return $this.authenticateBasicPFAsync(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateBasicPFAsync(String realm, PartialFunction<Credentials, Future<T>> authenticator) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractExecutionContext());
        return AuthenticationDirective$.MODULE$.apply(Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)ec -> (Directive)((Object)this.authenticateBasicAsync(realm, (Function1 & Serializable)credentials -> {
            if (authenticator.isDefinedAt(credentials)) {
                Future future = FastFuture$.MODULE$.EnhancedFuture((Future)authenticator.apply(credentials));
                Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
                return FastFuture$.MODULE$.map$extension(future2, (Function1 & Serializable)_$3 -> Some$.MODULE$.apply(_$3), (ExecutionContext)ec);
            }
            return (Future)FastFuture$.MODULE$.successful().apply((Object)None$.MODULE$);
        })), Tuple$.MODULE$.forTuple1()));
    }

    public static AuthenticationDirective authenticateOAuth2$(SecurityDirectives $this, String realm, Function1 authenticator) {
        return $this.authenticateOAuth2(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateOAuth2(String realm, Function1<Credentials, Option<T>> authenticator) {
        return this.authenticateOAuth2Async(realm, (Function1 & Serializable)cred -> (Future)FastFuture$.MODULE$.successful().apply(authenticator.apply(cred)));
    }

    public static AuthenticationDirective authenticateOAuth2Async$(SecurityDirectives $this, String realm, Function1 authenticator) {
        return $this.authenticateOAuth2Async(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateOAuth2Async(String realm, Function1<Credentials, Future<Option<T>>> authenticator) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractExecutionContext());
        return AuthenticationDirective$.MODULE$.apply(Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)ec -> {
            Directive directive = Directive$.MODULE$.SingleValueTransformers(this.extractCredentials());
            Directive extractCreds = Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)x$1 -> {
                HttpCredentials httpCredentials;
                Option option = x$1;
                if (option instanceof Some && (httpCredentials = (HttpCredentials)((Some)option).value()) instanceof OAuth2BearerToken) {
                    OAuth2BearerToken c = (OAuth2BearerToken)httpCredentials;
                    return BasicDirectives$.MODULE$.provide(Some$.MODULE$.apply((Object)c));
                }
                return SecurityDirectives.extractAccessTokenParameterAsBearerToken$1();
            }, Tuple$.MODULE$.forTuple1());
            return (Directive)((Object)this.extractCredentialsAndAuthenticateOrRejectWithChallenge(extractCreds, (Function1 & Serializable)cred -> {
                Future future = FastFuture$.MODULE$.EnhancedFuture((Future)authenticator.apply((Object)Credentials$.MODULE$.apply((Option<HttpCredentials>)cred)));
                Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
                return FastFuture$.MODULE$.map$extension(future2, (Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        Object t = ((Some)option).value();
                        return AuthenticationResult$.MODULE$.success(t);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return AuthenticationResult$.MODULE$.failWithChallenge(HttpChallenges$.MODULE$.oAuth2(realm));
                    }
                    throw new MatchError((Object)option);
                }, (ExecutionContext)ec);
            }));
        }, Tuple$.MODULE$.forTuple1()));
    }

    public static AuthenticationDirective authenticateOAuth2PF$(SecurityDirectives $this, String realm, PartialFunction authenticator) {
        return $this.authenticateOAuth2PF(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateOAuth2PF(String realm, PartialFunction<Credentials, T> authenticator) {
        return this.authenticateOAuth2(realm, authenticator.lift());
    }

    public static AuthenticationDirective authenticateOAuth2PFAsync$(SecurityDirectives $this, String realm, PartialFunction authenticator) {
        return $this.authenticateOAuth2PFAsync(realm, authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateOAuth2PFAsync(String realm, PartialFunction<Credentials, Future<T>> authenticator) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractExecutionContext());
        return AuthenticationDirective$.MODULE$.apply(Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)ec -> (Directive)((Object)this.authenticateOAuth2Async(realm, (Function1 & Serializable)credentials -> {
            if (authenticator.isDefinedAt(credentials)) {
                Future future = FastFuture$.MODULE$.EnhancedFuture((Future)authenticator.apply(credentials));
                Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
                return FastFuture$.MODULE$.map$extension(future2, (Function1 & Serializable)_$5 -> Some$.MODULE$.apply(_$5), (ExecutionContext)ec);
            }
            return (Future)FastFuture$.MODULE$.successful().apply((Object)None$.MODULE$);
        })), Tuple$.MODULE$.forTuple1()));
    }

    private <C extends HttpCredentials, T> AuthenticationDirective<T> extractCredentialsAndAuthenticateOrRejectWithChallenge(Directive<Tuple1<Option<C>>> extractCredentials, Function1<Option<C>, Future<Either<HttpChallenge, T>>> authenticator) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(extractCredentials);
        return AuthenticationDirective$.MODULE$.apply(Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)cred -> {
            Directive directive = Directive$.MODULE$.SingleValueTransformers(FutureDirectives$.MODULE$.onSuccess(OnSuccessMagnet$.MODULE$.apply(() -> SecurityDirectives.extractCredentialsAndAuthenticateOrRejectWithChallenge$$anonfun$1$$anonfun$1(authenticator, cred), Tupler$.MODULE$.forAnyRef())));
            return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Right) {
                    Object user = ((Right)either).value();
                    return BasicDirectives$.MODULE$.provide(user);
                }
                if (either instanceof Left) {
                    HttpChallenge challenge = (HttpChallenge)((Left)either).value();
                    AuthenticationFailedRejection.Cause cause = (AuthenticationFailedRejection.Cause)(cred.isEmpty() ? AuthenticationFailedRejection$CredentialsMissing$.MODULE$ : AuthenticationFailedRejection$CredentialsRejected$.MODULE$);
                    return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{AuthenticationFailedRejection$.MODULE$.apply(cause, challenge)})), Tuple$.MODULE$.forTuple1());
                }
                throw new MatchError((Object)either);
            }, Tuple$.MODULE$.forTuple1());
        }, Tuple$.MODULE$.forTuple1()));
    }

    public static AuthenticationDirective authenticateOrRejectWithChallenge$(SecurityDirectives $this, Function1 authenticator) {
        return $this.authenticateOrRejectWithChallenge(authenticator);
    }

    default public <T> AuthenticationDirective<T> authenticateOrRejectWithChallenge(Function1<Option<HttpCredentials>, Future<Either<HttpChallenge, T>>> authenticator) {
        return this.extractCredentialsAndAuthenticateOrRejectWithChallenge(this.extractCredentials(), authenticator);
    }

    public static AuthenticationDirective authenticateOrRejectWithChallenge$(SecurityDirectives $this, Function1 authenticator, ClassTag evidence$1) {
        return $this.authenticateOrRejectWithChallenge(authenticator, evidence$1);
    }

    default public <C extends HttpCredentials, T> AuthenticationDirective<T> authenticateOrRejectWithChallenge(Function1<Option<C>, Future<Either<HttpChallenge, T>>> authenticator, ClassTag<C> evidence$1) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(this.extractCredentials());
        return this.extractCredentialsAndAuthenticateOrRejectWithChallenge(Directive$SingleValueTransformers$.MODULE$.map$extension(directive, (Function1 & Serializable)_$6 -> _$6.collect((PartialFunction)new Serializable(evidence$1){
            private final ClassTag evidence$1$2;
            {
                this.evidence$1$2 = evidence$1$3;
            }

            public final boolean isDefinedAt(HttpCredentials x) {
                Option option;
                HttpCredentials httpCredentials = x;
                if (httpCredentials != null && !(option = this.evidence$1$2.unapply((Object)httpCredentials)).isEmpty()) {
                    HttpCredentials httpCredentials2;
                    HttpCredentials c = httpCredentials2 = (HttpCredentials)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(HttpCredentials x, Function1 function1) {
                Option option;
                HttpCredentials httpCredentials = x;
                if (httpCredentials != null && !(option = this.evidence$1$2.unapply((Object)httpCredentials)).isEmpty()) {
                    HttpCredentials httpCredentials2;
                    HttpCredentials c = httpCredentials2 = (HttpCredentials)option.get();
                    return c;
                }
                return function1.apply((Object)x);
            }
        }), Tupler$.MODULE$.forAnyRef()), authenticator);
    }

    public static Directive authorize$(SecurityDirectives $this, Function0 check) {
        return $this.authorize((Function0<Object>)check);
    }

    default public Directive<BoxedUnit> authorize(Function0<Object> check) {
        return this.authorize((Function1<RequestContext, Object>)(Function1 & Serializable)_$7 -> check.apply$mcZ$sp());
    }

    public static Directive authorize$(SecurityDirectives $this, Function1 check) {
        return $this.authorize((Function1<RequestContext, Object>)check);
    }

    default public Directive<BoxedUnit> authorize(Function1<RequestContext, Object> check) {
        return this.authorizeAsync((Function1<RequestContext, Future<Object>>)(Function1 & Serializable)ctx -> Future$.MODULE$.successful(check.apply(ctx)));
    }

    public static Directive authorizeAsync$(SecurityDirectives $this, Function0 check) {
        return $this.authorizeAsync((Function0<Future<Object>>)check);
    }

    default public Directive<BoxedUnit> authorizeAsync(Function0<Future<Object>> check) {
        return this.authorizeAsync((Function1<RequestContext, Future<Object>>)(Function1 & Serializable)ctx -> (Future)check.apply());
    }

    public static Directive authorizeAsync$(SecurityDirectives $this, Function1 check) {
        return $this.authorizeAsync((Function1<RequestContext, Future<Object>>)check);
    }

    default public Directive<BoxedUnit> authorizeAsync(Function1<RequestContext, Future<Object>> check) {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extract((Function1)check));
        return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)fa -> {
            Directive directive = Directive$.MODULE$.SingleValueTransformers(FutureDirectives$.MODULE$.onComplete(() -> SecurityDirectives.authorizeAsync$$anonfun$2$$anonfun$1(fa)));
            return Directive$SingleValueTransformers$.MODULE$.flatMap$extension(directive, (Function1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success && BoxesRunTime.unboxToBoolean((Object)((Success)try_).value())) {
                    return BasicDirectives$.MODULE$.pass();
                }
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{AuthorizationFailedRejection$.MODULE$})), Tuple$.MODULE$.forUnit());
            }, Tuple$.MODULE$.forUnit());
        }, Tuple$.MODULE$.forUnit());
    }

    private static Directive extractAccessTokenParameterAsBearerToken$1() {
        Directive directive = Directive$.MODULE$.SingleValueTransformers(Directives$.MODULE$.parameter(ParameterDirectives$ParamSpec$.MODULE$.forNOR(Directives$.MODULE$._string2NR("access_token").optional(), Unmarshaller$.MODULE$.sourceOptionUnmarshaller(Unmarshaller$.MODULE$.identityUnmarshaller()))));
        return Directive$SingleValueTransformers$.MODULE$.map$extension(directive, (Function1 & Serializable)_$4 -> _$4.map((Function1 & Serializable)token -> OAuth2BearerToken$.MODULE$.apply(token)), Tupler$.MODULE$.forAnyRef());
    }

    private static Future extractCredentialsAndAuthenticateOrRejectWithChallenge$$anonfun$1$$anonfun$1(Function1 authenticator$12, Option cred$1) {
        return (Future)authenticator$12.apply((Object)cred$1);
    }

    private static Future authorizeAsync$$anonfun$2$$anonfun$1(Future fa$1) {
        return fa$1;
    }
}

