/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.server.directives;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.http.scaladsl.common.EntityStreamingSupport;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypeRange;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.server.directives.MarshallingDirectives;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$UnsupportedContentTypeException$;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.ScalaRunTime$;

public interface FramedEntityStreamingDirectives
extends MarshallingDirectives {
    public static Unmarshaller asSourceOf$(FramedEntityStreamingDirectives $this, Unmarshaller um, EntityStreamingSupport support) {
        return $this.asSourceOf(um, support);
    }

    default public <T> Unmarshaller<HttpRequest, Source<T, NotUsed>> asSourceOf(Unmarshaller<ByteString, T> um, EntityStreamingSupport support) {
        return this.asSourceOfInternal(um, support);
    }

    public static Unmarshaller asSourceOf$(FramedEntityStreamingDirectives $this, EntityStreamingSupport support, Unmarshaller um) {
        return $this.asSourceOf(support, um);
    }

    default public <T> Unmarshaller<HttpRequest, Source<T, NotUsed>> asSourceOf(EntityStreamingSupport support, Unmarshaller<ByteString, T> um) {
        return this.asSourceOfInternal(um, support);
    }

    private <T> Unmarshaller<HttpRequest, Source<T, NotUsed>> asSourceOfInternal(Unmarshaller<ByteString, T> um, EntityStreamingSupport support) {
        return Unmarshaller$.MODULE$.withMaterializer((Function1 & Serializable)ec -> (Function1 & Serializable)mat -> (Function1 & Serializable)req -> {
            RequestEntity entity = req.entity();
            if (support.supported().matches((org.apache.pekko.http.javadsl.model.ContentType)entity.contentType())) {
                Source bytes = entity.dataBytes();
                Source frames = bytes.via(support.framingDecoder());
                Flow marshalling = support.unordered() ? (Flow)Flow$.MODULE$.apply().mapAsyncUnordered(support.parallelism(), (Function1 & Serializable)bs -> um.apply((ByteString)bs, (ExecutionContext)ec, (Materializer)mat)) : (Flow)Flow$.MODULE$.apply().mapAsync(support.parallelism(), (Function1 & Serializable)bs -> um.apply((ByteString)bs, (ExecutionContext)ec, (Materializer)mat));
                Source elements = frames.viaMat((Graph)marshalling, Keep$.MODULE$.right());
                return (Future)FastFuture$.MODULE$.successful().apply((Object)elements);
            }
            return (Future)FastFuture$.MODULE$.failed().apply((Object)Unmarshaller$UnsupportedContentTypeException$.MODULE$.apply((Option<ContentType>)Some$.MODULE$.apply((Object)entity.contentType()), (Seq<ContentTypeRange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ContentTypeRange[]{support.supported()})));
        });
    }
}

