/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl.coding;

import java.util.zip.Deflater;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.scaladsl.coding.Compressor;
import org.apache.pekko.http.scaladsl.coding.DeflateCompressor$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import scala.Predef$;
import scala.math.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

@InternalApi
public class DeflateCompressor
extends Compressor {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DeflateCompressor.class.getDeclaredField("deflater$lzy1"));
    private final int compressionLevel;
    private volatile Object deflater$lzy1;

    public static int DefaultCompressionLevel() {
        return DeflateCompressor$.MODULE$.DefaultCompressionLevel();
    }

    public static int MinBufferSize() {
        return DeflateCompressor$.MODULE$.MinBufferSize();
    }

    public static ByteString drainDeflater(Deflater deflater, byte[] byArray, ByteStringBuilder byteStringBuilder) {
        return DeflateCompressor$.MODULE$.drainDeflater(deflater, byArray, byteStringBuilder);
    }

    public static ByteStringBuilder drainDeflater$default$3() {
        return DeflateCompressor$.MODULE$.drainDeflater$default$3();
    }

    public DeflateCompressor(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        Predef$.MODULE$.require(compressionLevel >= 0 && compressionLevel <= 9, DeflateCompressor::$init$$$anonfun$1);
    }

    public DeflateCompressor() {
        this(DeflateCompressor$.MODULE$.DefaultCompressionLevel());
    }

    public Deflater deflater() {
        Object object = this.deflater$lzy1;
        if (object instanceof Deflater) {
            return (Deflater)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Deflater)this.deflater$lzyINIT1();
    }

    private Object deflater$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.deflater$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Deflater deflater = null;
                    try {
                        deflater = new Deflater(this.compressionLevel, false);
                        object2 = deflater == null ? LazyVals.NullValue$.MODULE$ : deflater;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.deflater$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return deflater;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public final ByteString compressAndFlush(ByteString input) {
        byte[] buffer = this.newTempBuffer(input.size());
        return this.compressWithBuffer(input, buffer).$plus$plus(this.flushWithBuffer(buffer));
    }

    @Override
    public final ByteString compressAndFinish(ByteString input) {
        byte[] buffer = this.newTempBuffer(input.size());
        return this.compressWithBuffer(input, buffer).$plus$plus(this.finishWithBuffer(buffer));
    }

    @Override
    public final ByteString compress(ByteString input) {
        return this.compressWithBuffer(input, this.newTempBuffer(this.newTempBuffer$default$1()));
    }

    @Override
    public final ByteString flush() {
        return this.flushWithBuffer(this.newTempBuffer(this.newTempBuffer$default$1()));
    }

    @Override
    public final ByteString finish() {
        return this.finishWithBuffer(this.newTempBuffer(this.newTempBuffer$default$1()));
    }

    public ByteString compressWithBuffer(ByteString input, byte[] buffer) {
        Predef$.MODULE$.require(this.deflater().needsInput());
        this.deflater().setInput(input.toArrayUnsafe());
        return DeflateCompressor$.MODULE$.drainDeflater(this.deflater(), buffer, DeflateCompressor$.MODULE$.drainDeflater$default$3());
    }

    public ByteString flushWithBuffer(byte[] buffer) {
        int written = this.deflater().deflate(buffer, 0, buffer.length, 2);
        return ByteString$.MODULE$.fromArray(buffer, 0, written);
    }

    public ByteString finishWithBuffer(byte[] buffer) {
        this.deflater().finish();
        ByteString res = DeflateCompressor$.MODULE$.drainDeflater(this.deflater(), buffer, DeflateCompressor$.MODULE$.drainDeflater$default$3());
        this.deflater().end();
        return res;
    }

    private byte[] newTempBuffer(int size) {
        return new byte[package$.MODULE$.max(size, DeflateCompressor$.MODULE$.MinBufferSize())];
    }

    private int newTempBuffer$default$1() {
        return 65536;
    }

    private static final Object $init$$$anonfun$1() {
        return "Compression level needs to be between 0 and 9";
    }
}

