/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.util.ssl.SSLUtil;

public class SelfSignedTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager;

    public SelfSignedTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException, ConfigurationException {
        TrustManager[] trustManagers = SSLUtil.getTrustManagers(keystore);
        if (trustManagers.length == 0) {
            throw new ConfigurationException("No TrustManagers found in KeyStore.");
        }
        try {
            this.trustManager = (X509TrustManager)trustManagers[0];
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("X509 TrustManager not found in KeyStore.");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(x509Certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        if (x509Certificates != null && x509Certificates.length == 1) {
            x509Certificates[0].checkValidity();
        } else {
            this.trustManager.checkServerTrusted(x509Certificates, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

