/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XssUtil {
    private static Pattern ampPattern = Pattern.compile("&");
    private static Pattern quotePattern = Pattern.compile("[\"]");
    private static Pattern openTagPattern = Pattern.compile("[<]|(%3C)");
    private static Pattern closeTagPattern = Pattern.compile("[>]|(%3E)");

    private XssUtil() {
    }

    public static String escape(String text) {
        String replace = XssUtil.replace(ampPattern, text, "&amp;");
        replace = XssUtil.replace(quotePattern, replace, "&quot;");
        replace = XssUtil.replace(openTagPattern, replace, "&lt;");
        replace = XssUtil.replace(closeTagPattern, replace, "&gt;");
        return replace;
    }

    private static String replace(Pattern pattern, String text, String replacement) {
        Matcher m = pattern.matcher(text);
        if (m.find()) {
            return m.replaceAll(replacement);
        }
        return text;
    }
}

