/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.jboss.internal.soa.esb.util.FtpUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.util.FileUtil;
import org.jboss.soa.esb.util.RemoteFileSystemException;

public class FtpClientUtil {
    private static final String TMP_SUFFIX = ".rosettaPart";
    private ConfigTree m_oParms;
    private String m_sFtpServer;
    private String m_sUser;
    private String m_sPasswd;
    private String m_sRemoteDir;
    private String m_sLocalDir;
    private int m_iPort;
    private boolean m_bPassive;
    private FTPClient m_oConn = new FTPClient();
    private boolean m_bAsciiTransferType;
    private int renameRetry;

    public String getRemoteDir() {
        return this.m_sRemoteDir;
    }

    public FtpClientUtil(ConfigTree p_oP, boolean p_bConnect) throws RemoteFileSystemException, ConfigurationException {
        this.m_oParms = p_oP;
        this.initialize(p_bConnect);
    }

    public FtpClientUtil(List<KeyValuePair> attribs, boolean connect) throws RemoteFileSystemException, ConfigurationException {
        this.m_oParms = new ConfigTree("fromProps");
        for (KeyValuePair oCurr : attribs) {
            this.m_oParms.setAttribute(oCurr.getKey(), oCurr.getValue());
        }
        this.initialize(connect);
    }

    private void initialize(boolean bConnect) throws RemoteFileSystemException, ConfigurationException {
        this.checkParms();
        try {
            if (bConnect) {
                if (this.m_iPort > 0) {
                    this.m_oConn.connect(this.m_sFtpServer, this.m_iPort);
                } else {
                    this.m_oConn.connect(this.m_sFtpServer);
                }
                if (!this.m_oConn.isConnected()) {
                    throw new RemoteFileSystemException("Can't connect to FTP server");
                }
                if (!this.m_oConn.login(this.m_sUser, this.m_sPasswd)) {
                    this.m_oConn.logout();
                    throw new RemoteFileSystemException("Remote login failed: " + this.m_oConn.getReplyString());
                }
                this.m_oConn.setFileType(this.m_bAsciiTransferType ? 0 : 2);
                if (this.m_bPassive) {
                    this.m_oConn.enterLocalPassiveMode();
                }
            }
        }
        catch (IOException ioe) {
            if (this.m_oConn.isConnected()) {
                try {
                    this.m_oConn.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new RemoteFileSystemException(ioe);
        }
    }

    public void quit() {
        if (null != this.m_oConn) {
            try {
                this.m_oConn.quit();
                this.m_oConn.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void deleteRemoteFile(String p_sFile) throws RemoteFileSystemException {
        try {
            this.changeRemoteDirectory();
            if (!this.m_oConn.deleteFile(p_sFile)) {
                throw new RemoteFileSystemException("Failed to delete remote file: " + this.m_oConn.getReplyString());
            }
        }
        catch (IOException ex) {
            throw new RemoteFileSystemException(ex);
        }
    }

    public void remoteDelete(File p_oFile) throws RemoteFileSystemException {
        try {
            this.changeRemoteDirectory();
            if (!this.m_oConn.deleteFile(p_oFile.getName())) {
                throw new RemoteFileSystemException("Failed to delete remote file: " + this.m_oConn.getReplyString());
            }
        }
        catch (IOException ex) {
            throw new RemoteFileSystemException(ex);
        }
    }

    public String[] getFileListFromRemoteDir(String p_sSuffix) throws RemoteFileSystemException {
        String sSuffix = null == p_sSuffix ? "*" : "*" + p_sSuffix;
        try {
            this.changeRemoteDirectory();
            return this.m_oConn.listNames(sSuffix);
        }
        catch (IOException ex) {
            throw new RemoteFileSystemException(ex);
        }
    }

    public void setRemoteDir(String p_sDir) throws RemoteFileSystemException {
        this.m_sRemoteDir = p_sDir;
    }

    public void renameInRemoteDir(String p_sFrom, String p_sTo) throws RemoteFileSystemException {
        try {
            this.changeRemoteDirectory();
            if (!this.m_oConn.rename(p_sFrom, p_sTo)) {
                throw new RemoteFileSystemException("Failed to rename file: " + this.m_oConn.getReplyString());
            }
        }
        catch (IOException ioe) {
            throw new RemoteFileSystemException(ioe);
        }
    }

    public void remoteRename(File p_oFrom, File p_oTo) throws RemoteFileSystemException {
        try {
            if (!this.m_oConn.rename(FtpClientUtil.fileToFtpString(p_oFrom), FtpUtils.fileToFtpString(p_oTo))) {
                throw new RemoteFileSystemException("Failed to rename file: " + this.m_oConn.getReplyString());
            }
        }
        catch (IOException ioe) {
            throw new RemoteFileSystemException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(File p_oFile, String p_sRemoteName) throws RemoteFileSystemException {
        try {
            this.changeRemoteDirectory();
            String sRemoteTmp = p_sRemoteName + TMP_SUFFIX;
            OutputStream os = this.m_oConn.storeFileStream(sRemoteTmp);
            try {
                FileInputStream fis = new FileInputStream(p_oFile);
                try {
                    this.copyStream(fis, os);
                }
                finally {
                    fis.close();
                }
            }
            finally {
                os.flush();
                os.close();
            }
            if (!this.m_oConn.completePendingCommand()) {
                throw new RemoteFileSystemException("Failed to upload contents: " + this.m_oConn.getReplyString());
            }
            boolean retryProblem = true;
            for (int i = 0; i < this.renameRetry; ++i) {
                if (this.m_oConn.rename(sRemoteTmp, p_sRemoteName)) {
                    retryProblem = false;
                    break;
                }
                if (i + 1 >= this.renameRetry) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (retryProblem) {
                throw new RemoteFileSystemException("Failed to rename file: " + this.m_oConn.getReplyString());
            }
        }
        catch (IOException ex) {
            throw new RemoteFileSystemException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(String p_sFile, String p_sFinalName) throws RemoteFileSystemException {
        try {
            File toTmp;
            File oNewTmp;
            File oNew;
            File to = new File(p_sFinalName);
            File oLocalDir = new File(this.m_sLocalDir);
            File file = oNew = to.isAbsolute() ? to : new File(oLocalDir, p_sFinalName);
            if (oNew.exists()) {
                oNew.delete();
            }
            File file2 = oNewTmp = (toTmp = new File(p_sFinalName + TMP_SUFFIX)).isAbsolute() ? toTmp : new File(oLocalDir, p_sFinalName + TMP_SUFFIX);
            if (oNewTmp.exists()) {
                oNewTmp.delete();
            }
            this.changeRemoteDirectory();
            InputStream is = this.m_oConn.retrieveFileStream(p_sFile);
            if (is == null) {
                throw new RemoteFileSystemException("Could not download file: " + this.m_oConn.getReplyString());
            }
            try {
                FileOutputStream fos = new FileOutputStream(oNewTmp);
                try {
                    this.copyStream(is, fos);
                }
                finally {
                    fos.close();
                }
            }
            finally {
                is.close();
            }
            if (!this.m_oConn.completePendingCommand()) {
                oNewTmp.delete();
                throw new RemoteFileSystemException("Failed to download contents: " + this.m_oConn.getReplyString());
            }
            FileUtil.renameTo(oNewTmp, oNew);
        }
        catch (IOException ex) {
            throw new RemoteFileSystemException(ex);
        }
    }

    private void checkParms() throws ConfigurationException {
        String sAux;
        this.m_sFtpServer = this.m_oParms.getAttribute("ftpServer");
        if (null == this.m_sFtpServer) {
            throw new ConfigurationException("No FTP server specified");
        }
        this.m_sUser = this.m_oParms.getAttribute("ftpUser");
        if (null == this.m_sUser) {
            throw new ConfigurationException("No username specified for FTP");
        }
        this.m_sPasswd = this.m_oParms.getAttribute("ftpPassword");
        if (null == this.m_sPasswd) {
            throw new ConfigurationException("No password specified for FTP");
        }
        this.m_sRemoteDir = this.m_oParms.getAttribute("ftpRemoteDir");
        if (null == this.m_sRemoteDir) {
            this.m_sRemoteDir = "";
        }
        this.m_sLocalDir = this.m_oParms.getAttribute("ftpLocalDir");
        if (null == this.m_sLocalDir) {
            this.m_sLocalDir = ".";
        }
        this.m_iPort = null == (sAux = this.m_oParms.getAttribute("ftpPort")) ? 21 : Integer.parseInt(sAux);
        boolean bAscii = false;
        sAux = this.m_oParms.getAttribute("ftpAscii");
        if (null != sAux) {
            bAscii = Boolean.parseBoolean(sAux);
        }
        this.m_bAsciiTransferType = bAscii;
        this.m_bPassive = false;
        sAux = this.m_oParms.getAttribute("ftpPassive");
        this.m_bPassive = null != sAux && Boolean.parseBoolean(sAux);
        String renameRetryString = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.renameretry", null);
        if (renameRetryString != null) {
            try {
                this.renameRetry = Integer.parseInt(renameRetryString);
            }
            catch (Exception ex) {
                throw new ConfigurationException("Invalid rename retry limit: " + renameRetryString);
            }
        } else {
            this.renameRetry = 10;
        }
        if (this.renameRetry < 1) {
            this.renameRetry = 1;
        }
    }

    public static String fileToFtpString(File p_oF) {
        return null == p_oF ? null : p_oF.toString().replace("\\", "/");
    }

    private void changeRemoteDirectory() throws IOException, RemoteFileSystemException {
        String remoteDir = this.getRemoteDir();
        if (remoteDir != null && remoteDir.length() > 0 && !this.m_oConn.changeWorkingDirectory(remoteDir)) {
            throw new RemoteFileSystemException("Failed to change to remote directory: " + this.m_oConn.getReplyString());
        }
    }

    private void copyStream(InputStream is, OutputStream os) throws IOException {
        int count;
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        byte[] buffer = new byte[256];
        while ((count = bis.read(buffer)) > 0) {
            bos.write(buffer, 0, count);
        }
        bos.flush();
    }

    public static enum XFER_TYPE {
        ascii,
        binary;

    }
}

