/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.util.ClassUtil;

public class BeanConfigurator {
    private PropertyDescriptor[] descriptors;
    private Object bean;
    private Map<String, String> properties;
    private Collection<String> optionalFields = new ArrayList<String>();

    public BeanConfigurator() {
    }

    public BeanConfigurator(ConfigTree config, Object bean) {
        List<KeyValuePair> pairs = config.childPropertyList();
        this.properties = new HashMap<String, String>();
        for (KeyValuePair kvp : pairs) {
            this.properties.put(kvp.getKey(), kvp.getValue());
        }
        this.bean = bean;
    }

    public BeanConfigurator(Map<String, String> properties, Object bean) {
        this.properties = properties;
        this.bean = bean;
    }

    public void configure() throws IntrospectionException {
        Class<?> beanClass = this.bean.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        this.descriptors = beanInfo.getPropertyDescriptors();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            PropertyDescriptor descriptor = this.getPropertyDescriptor(key = Introspector.decapitalize(key));
            if (descriptor == null) {
                if (this.optionalFields.contains(key)) continue;
                throw new IllegalArgumentException("'" + key + "' property not found on " + beanClass.getName());
            }
            this.setProperty(descriptor, key, entry.getValue());
        }
    }

    protected void setProperty(PropertyDescriptor descriptor, String name, String value) {
        Method setter = descriptor.getWriteMethod();
        if (setter == null) {
            throw new IllegalArgumentException("No setter for property [" + name + "]");
        }
        Class<?> propertyType = descriptor.getPropertyType();
        PropertyEditor editor = PropertyEditorManager.findEditor(propertyType);
        if (editor == null) {
            throw new IllegalArgumentException("Unable to find suitable property editor for property=" + name + " type=" + propertyType.getName());
        }
        editor.setAsText(value);
        Object arg = editor.getValue();
        try {
            setter.invoke(this.bean, arg);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to set property named '+" + name + "'", ex);
        }
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (!name.equals(this.descriptors[i].getName())) continue;
            return this.descriptors[i];
        }
        return null;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setOptionalFields(Collection<String> optionalFields) {
        this.optionalFields = optionalFields;
    }

    static {
        try {
            ClassUtil.forName("org.jboss.util.propertyeditor.PropertyEditors", BeanConfigurator.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

