/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.smooks.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.lifecycle.LifecycleResource;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceFactory;
import org.milyn.Smooks;
import org.xml.sax.SAXException;

public class SmooksResource {
    private static Logger LOGGER = Logger.getLogger(SmooksResource.class);
    private static final LifecycleResourceFactory<IdentityHashMap<Smooks, Smooks>> lifecycleSmooksResourceFactory = new SmooksResourceFactory();
    private static final LifecycleResource<IdentityHashMap<Smooks, Smooks>> lifecycleSmooksResource = new LifecycleResource<IdentityHashMap<Smooks, Smooks>>(lifecycleSmooksResourceFactory, 150000);

    private SmooksResource() {
    }

    public static Smooks createSmooksResource() throws LifecycleResourceException {
        Smooks smooks = new Smooks();
        lifecycleSmooksResource.getLifecycleResource().put(smooks, smooks);
        return smooks;
    }

    public static Smooks createSmooksResource(String config) throws SAXException, IOException, LifecycleResourceException {
        Smooks smooks = new Smooks(config);
        lifecycleSmooksResource.getLifecycleResource().put(smooks, smooks);
        return smooks;
    }

    public static Smooks createSmooksResource(InputStream is) throws SAXException, IOException, LifecycleResourceException {
        Smooks smooks = new Smooks(is);
        lifecycleSmooksResource.getLifecycleResource().put(smooks, smooks);
        return smooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSmooksResource(Smooks smooks) {
        try {
            smooks.close();
        }
        finally {
            try {
                lifecycleSmooksResource.getLifecycleResource().remove(smooks);
            }
            catch (LifecycleResourceException lifecycleResourceException) {}
        }
    }

    private static class SmooksResourceFactory
    implements LifecycleResourceFactory<IdentityHashMap<Smooks, Smooks>> {
        private SmooksResourceFactory() {
        }

        @Override
        public IdentityHashMap<Smooks, Smooks> createLifecycleResource(String lifecycleIdentity) throws LifecycleResourceException {
            return new IdentityHashMap<Smooks, Smooks>();
        }

        @Override
        public void destroyLifecycleResource(IdentityHashMap<Smooks, Smooks> resource, String lifecycleIdentity) throws LifecycleResourceException {
            if (resource.size() > 0) {
                LOGGER.warn((Object)("Closing smooks resources for identity " + lifecycleIdentity));
                Iterator<Smooks> smooksIter = resource.keySet().iterator();
                while (smooksIter.hasNext()) {
                    Smooks smooks = smooksIter.next();
                    smooksIter.remove();
                    try {
                        smooks.close();
                    }
                    catch (Exception ex) {
                        LOGGER.warn((Object)"Unexpected exception closing smooks resource", (Throwable)ex);
                    }
                }
            }
        }
    }
}

