/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.util;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jboss.soa.esb.services.security.SecurityServiceException;

public final class CryptoUtil {
    private CryptoUtil() {
    }

    public static Cipher getCipher(String transformation) throws SecurityServiceException {
        try {
            return Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
    }

    public static Cipher getCipherForDecryption(String transformation, Key key) throws SecurityServiceException {
        Cipher cipher = CryptoUtil.getCipher(transformation);
        try {
            cipher.init(2, key);
        }
        catch (InvalidKeyException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        return cipher;
    }

    public static Cipher getCipherForEncryption(String transformation, Key key) throws SecurityServiceException {
        Cipher cipher = CryptoUtil.getCipher(transformation);
        try {
            cipher.init(1, key);
        }
        catch (InvalidKeyException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        return cipher;
    }

    public static byte[] decrypt(byte[] bytes, Key key, String transformation) throws SecurityServiceException {
        try {
            Cipher cipher = CryptoUtil.getCipher(transformation);
            cipher.init(2, key);
            return cipher.doFinal(bytes);
        }
        catch (InvalidKeyException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
    }

    public static byte[] encrypt(byte[] text, Key key, String transformation) throws SecurityServiceException {
        try {
            Cipher cipher = CryptoUtil.getCipher(transformation);
            cipher.init(1, key);
            return cipher.doFinal(text);
        }
        catch (InvalidKeyException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
    }

    public static byte[] copyBytes(byte[] bytes, int length) {
        byte[] newArr = null;
        if (bytes.length == length) {
            newArr = bytes;
        } else {
            newArr = new byte[length];
            for (int i = 0; i < length; ++i) {
                newArr[i] = bytes[i];
            }
        }
        return newArr;
    }
}

