/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import java.util.HashSet;
import java.util.Iterator;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequestImpl;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.auth.ws.BinarySecurityToken;
import org.jboss.soa.esb.services.security.auth.ws.SOAPExtractorUtil;
import org.jboss.soa.esb.services.security.auth.ws.UsernameToken;
import org.jboss.soa.esb.services.security.principals.User;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSecuritySoapExtractor
implements SecurityInfoExtractor<SOAPMessage> {
    private Logger log = Logger.getLogger(WSSecuritySoapExtractor.class);

    @Override
    public AuthenticationRequest extractSecurityInfo(SOAPMessage soap) {
        if (soap == null) {
            return null;
        }
        User user = null;
        HashSet<Object> credentials = new HashSet<Object>();
        try {
            SOAPHeaderElement securityHeader = SOAPExtractorUtil.extractSecurityHeader(soap.getSOAPPart().getEnvelope());
            if (securityHeader == null) {
                return null;
            }
            Iterator childElements = securityHeader.getChildElements();
            while (childElements.hasNext()) {
                char[] passwd;
                Node securityNode = (Node)childElements.next();
                if (securityNode.getNodeType() != 1) continue;
                String localName = securityNode.getLocalName();
                if ("BinarySecurityToken".equalsIgnoreCase(localName)) {
                    BinarySecurityToken binaryToken = this.createBinarySecurityToken(securityNode);
                    credentials.add(binaryToken.getKey());
                    continue;
                }
                if (!"UsernameToken".equalsIgnoreCase(localName)) continue;
                UsernameToken usernameToken = this.createUsernameToken(securityNode);
                String userName = usernameToken.getUserName();
                if (userName != null) {
                    user = new User(usernameToken.getUserName());
                }
                if ((passwd = usernameToken.getPassword()) == null) continue;
                credentials.add(passwd);
            }
            if (user != null || !credentials.isEmpty()) {
                return new AuthenticationRequestImpl.Builder(user, credentials).build();
            }
            return null;
        }
        catch (SOAPException e) {
            this.log.error((Object)"Caught a SOAPException while trying to extract security information: ", (Throwable)e);
            throw new SecurityException("Could not extract security info from SOAPMessage");
        }
    }

    private BinarySecurityToken createBinarySecurityToken(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node encodingTypeNode = attributes.getNamedItem("EncodingType");
        String encodingType = encodingTypeNode.getNodeValue();
        Node valueTypeNode = attributes.getNamedItem("ValueType");
        String valueType = valueTypeNode.getNodeValue();
        String certString = node.getFirstChild().getNodeValue();
        BinarySecurityToken binaryToken = new BinarySecurityToken();
        binaryToken.setEncodingType(encodingType);
        binaryToken.setValueType(valueType);
        binaryToken.setKey(certString);
        return binaryToken;
    }

    private UsernameToken createUsernameToken(Node node) {
        NodeList usernameElements = node.getChildNodes();
        int nrOfElements = usernameElements.getLength();
        UsernameToken usernameToken = new UsernameToken();
        for (int i = 0; i < nrOfElements; ++i) {
            Node element = usernameElements.item(i);
            String elLocalName = element.getLocalName();
            if ("Username".equalsIgnoreCase(elLocalName)) {
                usernameToken.setUserName(element.getFirstChild().getNodeValue());
                continue;
            }
            if (!"Password".equalsIgnoreCase(elLocalName)) continue;
            usernameToken.setPassword(element.getFirstChild().getNodeValue());
        }
        return usernameToken;
    }
}

