/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import java.io.StringReader;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequestImpl;
import org.jboss.soa.esb.services.security.auth.ExtractionException;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.auth.ws.SoapExtractionUtil;
import org.jboss.soa.esb.services.security.principals.User;

public class UsernameTokenExtractor
implements SecurityInfoExtractor<String> {
    private Logger log = Logger.getLogger(UsernameTokenExtractor.class);
    private static final XMLInputFactory XML_INPUT_FACTORY = UsernameTokenExtractor.getXmlInputFactory();
    private final QName usernameTokenQName;
    private final QName usernameQName;
    private final QName passwordQName;

    public UsernameTokenExtractor(String securityNS) {
        AssertArgument.isNotNullAndNotEmpty(securityNS, "securityNS");
        this.usernameTokenQName = new QName(securityNS, "UsernameToken");
        this.usernameQName = new QName(securityNS, "Username");
        this.passwordQName = new QName(securityNS, "Password");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuthenticationRequest extractSecurityInfo(String soap) throws ExtractionException {
        block15: {
            if (soap == null) return null;
            if (!soap.startsWith("<")) {
                return null;
            }
            xmlReader = null;
            user = null;
            credentials = new HashSet<Object>();
            try {
                xmlReader = UsernameTokenExtractor.XML_INPUT_FACTORY.createXMLEventReader(new StringReader(soap));
lbl9:
                // 2 sources

                while (xmlReader.hasNext()) {
                    xmlEvent = xmlReader.nextEvent();
                    if (!SoapExtractionUtil.isStartOfHeader(xmlEvent)) ** GOTO lbl-1000
lbl12:
                    // 2 sources

                    while (xmlReader.hasNext()) {
                        xmlEvent = xmlReader.nextEvent();
                        if (!this.isStartOfUsernameToken(xmlEvent)) ** GOTO lbl-1000
                        while (xmlReader.hasNext()) {
                            xmlEvent = xmlReader.nextEvent();
                            if (this.isStartOfUsername(xmlEvent) && (username = xmlReader.nextEvent()).isCharacters()) {
                                user = new User(((Characters)username).getData());
                            }
                            if (this.isStartOfPassword(xmlEvent) && (password = xmlReader.nextEvent()).isCharacters() && (data = (characters = (Characters)password).getData()) != null) {
                                credentials.add(characters.getData());
                            }
                            if (!this.isEndOfUsernameToken(xmlEvent)) continue;
                            if (credentials.isEmpty()) {
                                var6_7 = null;
                                this.close(xmlReader);
                                return var6_7;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl-1000
                }
                break block15;
            }
            catch (XMLStreamException e) {
                try {
                    throw new ExtractionException(e.getMessage(), e);
                }
                catch (Throwable var9_10) {
                    this.close(xmlReader);
                    throw var9_10;
                }
            }
lbl-1000:
            // 1 sources

            {
                var6_7 = new AuthenticationRequestImpl.Builder(user, credentials).build();
                this.close(xmlReader);
                return var6_7;
            }
lbl-1000:
            // 2 sources

            {
                if (!SoapExtractionUtil.isEndOfHeader(xmlEvent)) ** GOTO lbl12
                var6_7 = null;
                this.close(xmlReader);
                return var6_7;
            }
lbl-1000:
            // 2 sources

            {
                if (!SoapExtractionUtil.isStartOfBody(xmlEvent)) ** GOTO lbl9
                var6_7 = null;
                this.close(xmlReader);
                return var6_7;
            }
        }
        this.close(xmlReader);
        return null;
    }

    private boolean isStartOfUsername(XMLEvent event) {
        return event.isStartElement() && ((StartElement)event).getName().equals(this.usernameQName);
    }

    private boolean isStartOfPassword(XMLEvent event) {
        return event.isStartElement() && ((StartElement)event).getName().equals(this.passwordQName);
    }

    private boolean isStartOfUsernameToken(XMLEvent event) {
        return event.isStartElement() && ((StartElement)event).getName().equals(this.usernameTokenQName);
    }

    private boolean isEndOfUsernameToken(XMLEvent event) {
        return event.isEndElement() && ((EndElement)event).getName().equals(this.usernameTokenQName);
    }

    private static XMLInputFactory getXmlInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        return factory;
    }

    private void close(XMLEventReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (XMLStreamException ignore) {
                this.log.error((Object)"XMLStreamException caught while trying to close the XMLEventReader", (Throwable)ignore);
            }
        }
    }
}

