/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequestImpl;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.auth.ws.SoapExtractionUtil;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;

public class SamlAssertionExtractor
implements SecurityInfoExtractor<String> {
    private static final XMLInputFactory XML_INPUT_FACTORY = SamlAssertionExtractor.getXmlInputFactory();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = SamlAssertionExtractor.getXmlOutputFactory();
    private final QName assertionQName;

    public SamlAssertionExtractor() {
        this("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    public SamlAssertionExtractor(String namespace) {
        AssertArgument.isNotNullAndNotEmpty(namespace, "namespace");
        this.assertionQName = new QName(namespace, "Assertion");
    }

    @Override
    public AuthenticationRequest extractSecurityInfo(String soap) {
        String samlToken;
        if (soap == null || !soap.startsWith("<")) {
            return null;
        }
        try {
            samlToken = this.extractSamlAssertion(soap);
        }
        catch (XMLStreamException e) {
            throw new SecurityException("Could not extract saml token info from :" + soap, e);
        }
        if (samlToken != null) {
            Set<SamlCredential> credential = Collections.singleton(new SamlCredential(samlToken));
            return new AuthenticationRequestImpl.Builder(null, credential).build();
        }
        return null;
    }

    public String extractSamlAssertion(String soap) throws XMLStreamException {
        if (soap == null || !soap.startsWith("<")) {
            return null;
        }
        XMLEventReader xmlReader = XML_INPUT_FACTORY.createXMLEventReader(new StringReader(soap));
        StringWriter stringWriter = new StringWriter();
        XMLEventWriter xmlWriter = XML_OUTPUT_FACTORY.createXMLEventWriter(stringWriter);
        while (xmlReader.hasNext()) {
            XMLEvent event = xmlReader.nextEvent();
            if (SoapExtractionUtil.isStartOfHeader(event)) {
                while (xmlReader.hasNext()) {
                    event = xmlReader.nextEvent();
                    if (this.isStartOfAssertion(event)) {
                        xmlWriter.add(event);
                        while (xmlReader.hasNext()) {
                            XMLEvent nextEvent = xmlReader.nextEvent();
                            xmlWriter.add(nextEvent);
                            if (!this.isEndOfAssertion(nextEvent)) continue;
                            xmlWriter.flush();
                            return stringWriter.toString();
                        }
                    }
                    if (!SoapExtractionUtil.isEndOfHeader(event)) continue;
                    return null;
                }
            }
            if (!SoapExtractionUtil.isStartOfBody(event)) continue;
            return null;
        }
        return null;
    }

    private boolean isStartOfAssertion(XMLEvent event) {
        return event.isStartElement() && ((StartElement)event).getName().equals(this.assertionQName);
    }

    private boolean isEndOfAssertion(XMLEvent event) {
        return event.isEndElement() && ((EndElement)event).getName().equals(this.assertionQName);
    }

    private static XMLOutputFactory getXmlOutputFactory() {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        return factory;
    }

    private static XMLInputFactory getXmlInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        return factory;
    }
}

