/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import java.io.StringReader;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequestImpl;
import org.jboss.soa.esb.services.security.auth.ExtractionException;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.auth.ws.BinarySecurityToken;
import org.jboss.soa.esb.services.security.auth.ws.SoapExtractionUtil;

public class BinarySecurityTokenExtractor
implements SecurityInfoExtractor<String> {
    private static final XMLInputFactory XML_INPUT_FACTORY = BinarySecurityTokenExtractor.getXmlInputFactory();
    private Logger log = Logger.getLogger(BinarySecurityTokenExtractor.class);
    private QName binarySecurityTokenQName;
    private QName encodingTypeQName = new QName("EncodingType");
    private QName valueTypeQName = new QName("ValueType");

    public BinarySecurityTokenExtractor(String securityNS) {
        AssertArgument.isNotNullAndNotEmpty(securityNS, "securityNS");
        this.binarySecurityTokenQName = new QName(securityNS, "BinarySecurityToken");
    }

    @Override
    public AuthenticationRequest extractSecurityInfo(String soap) throws ExtractionException {
        if (soap == null || !soap.startsWith("<")) {
            return null;
        }
        BinarySecurityToken binarySecurityToken = this.extractBinarySecurityToken(soap);
        if (binarySecurityToken == null) {
            return null;
        }
        HashSet<Object> credentials = new HashSet<Object>();
        credentials.add(binarySecurityToken.getKey());
        return new AuthenticationRequestImpl.Builder(null, credentials).build();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BinarySecurityToken extractBinarySecurityToken(String soap) throws ExtractionException {
        block14: {
            block12: {
                block13: {
                    xmlReader = null;
                    try {
                        xmlReader = BinarySecurityTokenExtractor.XML_INPUT_FACTORY.createXMLEventReader(new StringReader(soap));
lbl4:
                        // 2 sources

                        while (xmlReader.hasNext()) {
                            xmlEvent = xmlReader.nextEvent();
                            if (SoapExtractionUtil.isStartOfHeader(xmlEvent)) lbl-1000:
                            // 2 sources

                            {
                                while (xmlReader.hasNext()) {
                                    xmlEvent = xmlReader.nextEvent();
                                    if (!this.isStartOfBinarySecurityToken(xmlEvent)) break block12;
                                    bstElement = (StartElement)xmlEvent;
                                    bst = new BinarySecurityToken();
                                    bst.setEncodingType(bstElement.getAttributeByName(this.encodingTypeQName).getValue());
                                    bst.setValueType(bstElement.getAttributeByName(this.valueTypeQName).getValue());
                                    data = new StringBuilder();
                                    break block13;
                                }
                            }
                            ** GOTO lbl-1000
                        }
                        break block14;
                    }
                    catch (XMLStreamException e) {
                        try {
                            throw new ExtractionException(e.getMessage(), e);
                        }
                        catch (Throwable var9_10) {
                            this.close(xmlReader);
                            throw var9_10;
                        }
                    }
                }
                while (xmlReader.hasNext()) {
                    nextEvent = xmlReader.nextEvent();
                    if (nextEvent.isCharacters()) {
                        characters = nextEvent.asCharacters();
                        data.append(characters.getData());
                    }
                    if (!this.isEndOfBinarySecurityToken(nextEvent)) continue;
                    bst.setKey(data.toString());
                    var8_9 = bst;
                    this.close(xmlReader);
                    return var8_9;
                }
            }
            if (!SoapExtractionUtil.isEndOfHeader(xmlEvent)) ** GOTO lbl-1000
            var4_5 = null;
            this.close(xmlReader);
            return var4_5;
lbl-1000:
            // 1 sources

            {
                if (!SoapExtractionUtil.isStartOfBody(xmlEvent)) ** GOTO lbl4
                var4_5 = null;
                this.close(xmlReader);
                return var4_5;
            }
        }
        this.close(xmlReader);
        return null;
    }

    private boolean isStartOfBinarySecurityToken(XMLEvent event) {
        return event.isStartElement() && ((StartElement)event).getName().equals(this.binarySecurityTokenQName);
    }

    private boolean isEndOfBinarySecurityToken(XMLEvent event) {
        return event.isEndElement() && ((EndElement)event).getName().equals(this.binarySecurityTokenQName);
    }

    private static XMLInputFactory getXmlInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        return factory;
    }

    private void close(XMLEventReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (XMLStreamException ignore) {
                this.log.error((Object)"XMLStreamException caught while trying to close the XMLEventReader", (Throwable)ignore);
            }
        }
    }
}

