/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.login;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.internal.soa.esb.services.security.EsbCallbackHandler;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;

public class CertCallbackHandler
implements EsbCallbackHandler {
    private String keyStoreAlias;
    private char[] keyPassword;
    private AuthenticationRequest authRequest;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callbacks[i];
                nameCallback.setName(this.keyStoreAlias);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callbacks[i];
                passwordCallback.setPassword(this.keyPassword);
                continue;
            }
            if (!(callbacks[i] instanceof ObjectCallback)) continue;
            ObjectCallback objectCallback = (ObjectCallback)callbacks[i];
            objectCallback.setCredential(this.authRequest.getCredentials());
        }
    }

    @Override
    public void setAuthenticationRequest(AuthenticationRequest authRequest) {
        this.authRequest = authRequest;
    }

    @Override
    public void setSecurityConfig(SecurityConfig config) {
        if (config != null) {
            Map<String, String> properties = config.getProperties();
            this.keyStoreAlias = properties.get("alias");
            String keyPass = properties.get("keyPassword");
            if (keyPass != null) {
                this.keyPassword = keyPass.toCharArray();
            }
            Object var3_3 = null;
        }
    }
}

