/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security.auth.http;

import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequestImpl;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.principals.User;

public class JbrHttpSecurityInfoExtractor
implements SecurityInfoExtractor<Map<String, Object>> {
    private Logger log = Logger.getLogger(JbrHttpSecurityInfoExtractor.class);
    public static final String USERNAME_KEY = "http.basic.username";
    public static final String PASSWORD_KEY = "http.basic.password";

    @Override
    public AuthenticationRequest extractSecurityInfo(Map<String, Object> request) {
        AuthenticationRequest authRequest = null;
        String username = (String)request.get(USERNAME_KEY);
        if (username != null) {
            User user = new User(username);
            HashSet<Object> credentials = new HashSet<Object>();
            String passwd = (String)request.get(PASSWORD_KEY);
            if (passwd != null) {
                credentials.add(passwd.toCharArray());
                Object remove = request.remove(PASSWORD_KEY);
                if (remove == null) {
                    this.log.warn((Object)"Could not remove the password from the request map");
                }
            }
            authRequest = new AuthenticationRequestImpl.Builder(user, credentials).build();
        }
        return authRequest;
    }
}

