/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityConfig {
    private final String runAs;
    private final List<String> rolesAllowed;
    private final String useCallerIdentity;
    private final String moduleName;
    private final String callbackHandler;
    private Map<String, String> properties = new HashMap<String, String>();

    private SecurityConfig(String runAs, List<String> rolesAllowed, String useCallerIdentity, String moduleName, String callbackHandler, Map<String, String> properties) {
        this.runAs = runAs;
        this.rolesAllowed = rolesAllowed;
        this.useCallerIdentity = useCallerIdentity;
        this.moduleName = moduleName;
        this.callbackHandler = callbackHandler;
        this.properties = properties;
    }

    public String getCallbackHandler() {
        return this.callbackHandler;
    }

    public String getRunAs() {
        return this.runAs;
    }

    public String getUseCallerIdentity() {
        return this.useCallerIdentity;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public boolean hasRunAs() {
        return this.runAs != null;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<String> getRolesAllowed() {
        return this.rolesAllowed;
    }

    public String toString() {
        return "[SecurityConfigInfo : runAs=" + this.runAs + ", useCallerIdentity=" + this.useCallerIdentity + ", moduleName=" + this.moduleName + ", callbackHandler=" + this.callbackHandler + ", properties=" + this.properties + ", rolesAllowed=" + this.rolesAllowed + "]";
    }

    public static class Builder {
        private String runAs;
        private String rolesAllowed;
        private String useCallerIdentity;
        private final String moduleName;
        private String callbackHandler;
        private final Map<String, String> properties = new HashMap<String, String>();

        public Builder(String moduleName) {
            this.moduleName = moduleName;
        }

        public Builder runAs(String runAs) {
            this.runAs = runAs;
            return this;
        }

        public Builder rolesAllowed(String rolesAllowed) {
            this.rolesAllowed = rolesAllowed;
            return this;
        }

        public Builder useCallerIdentity(String useCallerIdentity) {
            this.useCallerIdentity = useCallerIdentity;
            return this;
        }

        public Builder callBackhandler(String callbackHandler) {
            this.callbackHandler = callbackHandler;
            return this;
        }

        public Builder property(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public SecurityConfig build() {
            ArrayList<String> rolesAllowedList = new ArrayList<String>();
            if (this.rolesAllowed != null) {
                String[] split = this.rolesAllowed.split(",");
                List<String> asList = Arrays.asList(split);
                for (String roleName : asList) {
                    if ("".equals(roleName)) continue;
                    rolesAllowedList.add(roleName.trim());
                }
            }
            List unmodifiableRoles = Collections.unmodifiableList(rolesAllowedList);
            Map<String, String> unmodifiableProperties = Collections.unmodifiableMap(this.properties);
            SecurityConfig securityConfig = new SecurityConfig(this.runAs, unmodifiableRoles, this.useCallerIdentity, this.moduleName, this.callbackHandler, unmodifiableProperties);
            return securityConfig;
        }
    }
}

