/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.routing.MessageRouterException;

public abstract class MessageRouter {
    private static Logger logger = Logger.getLogger(MessageRouter.class);
    public static final String AGGEGRATOR_TAG = "aggregatorTag";
    public static final String SPLITTER_TIME_STAMP = "splitterTimeStamp";
    public static final String INTERNAL_SERVICE_CATEGORY = "JBossESB-Internal";
    public static final String DEAD_LETTER_SERVICE_NAME = "DeadLetterService";

    public abstract List<String> route(Message var1) throws MessageRouterException;

    public static synchronized void deliverMessage(String serviceCategory, String serviceName, Message message) throws MessageRouterException {
        try {
            ServiceInvoker serviceInvoker = new ServiceInvoker(serviceCategory, serviceName);
            serviceInvoker.deliverAsync(message);
        }
        catch (MessageDeliverException e) {
            throw new MessageRouterException(e);
        }
    }

    public static synchronized void deliverMessages(Collection<String[]> destinations, Message message) throws MessageRouterException {
        String uuId = UUID.randomUUID().toString();
        int counter = 0;
        Iterator<String[]> i = destinations.iterator();
        while (i.hasNext()) {
            if (destinations.size() > 1) {
                ArrayList<String> aggregatorTags = (ArrayList<String>)message.getProperties().getProperty(AGGEGRATOR_TAG);
                if (aggregatorTags == null) {
                    aggregatorTags = new ArrayList<String>();
                }
                String tag = uuId + ":" + ++counter + ":" + destinations.size() + ":" + new Date().getTime();
                aggregatorTags.add(tag);
                message.getProperties().setProperty(AGGEGRATOR_TAG, aggregatorTags);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("aggregatorTag=" + tag));
                }
            }
            String[] destination = i.next();
            MessageRouter.deliverMessage(destination[0], destination[1], message);
        }
    }
}

