/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.services.registry;

import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.registry.AbstractRegistryInterceptor;
import org.jboss.soa.esb.services.registry.Registry;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.registry.RegistryInterceptor;
import org.jboss.soa.esb.services.registry.ServiceNotFoundException;
import org.jboss.soa.esb.util.ClassUtil;

public class RegistryFactory {
    private static Logger logger = Logger.getLogger(RegistryFactory.class);
    private static Registry singleton;
    private static Registry currentRegistry;
    private static RegistryInterceptor[] interceptors;

    public static synchronized void setRegistry(Registry registry) {
        currentRegistry = registry;
        singleton = RegistryFactory.configureInterceptors(registry);
    }

    public static synchronized Registry getRegistrySingleton() {
        return currentRegistry;
    }

    public static synchronized Registry getRegistry() throws RegistryException {
        if (singleton != null) {
            return singleton;
        }
        RegistryFactory.setRegistry(RegistryFactory.createRegistry());
        return singleton;
    }

    public static synchronized Registry createRegistry() throws RegistryException {
        if (currentRegistry != null) {
            return currentRegistry;
        }
        Registry registry = null;
        String className = Configuration.getRegistryImplementationClass();
        logger.log((Priority)Level.DEBUG, (Object)("Going to load " + className));
        try {
            Class registryClass = ClassUtil.forName(className, RegistryFactory.class);
            registry = (Registry)registryClass.newInstance();
        }
        catch (ClassNotFoundException cnfex) {
            throw new RegistryException("Registry Implementation=" + className + " not found", cnfex);
        }
        catch (Exception e) {
            throw new RegistryException("Invocation exception. " + e.getLocalizedMessage(), e);
        }
        currentRegistry = registry;
        return registry;
    }

    private static Registry configureInterceptors(Registry registry) {
        if (interceptors != null) {
            int numInterceptors = interceptors.length;
            for (int count = 0; count < numInterceptors; ++count) {
                interceptors[count].setRegistry(null);
            }
            interceptors = null;
        }
        if (registry == null) {
            return null;
        }
        String registryInterceptorConfig = Configuration.getRegistryInterceptors();
        String[] registryInterceptorNames = registryInterceptorConfig == null ? null : registryInterceptorConfig.split(",");
        int numInterceptors = registryInterceptorNames == null ? 0 : registryInterceptorNames.length;
        RegistryInterceptor[] registryInterceptors = new RegistryInterceptor[numInterceptors + 1];
        Registry current = registry;
        try {
            for (int count = numInterceptors; count > 0; --count) {
                Object interceptor;
                Class interceptorClass;
                try {
                    interceptorClass = ClassUtil.forName(registryInterceptorNames[count - 1].trim(), RegistryFactory.class);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RegistryException("Failed to instantiate registry interceptor, disabling all interceptors", cnfe);
                }
                if (!RegistryInterceptor.class.isAssignableFrom(interceptorClass)) {
                    throw new RegistryException("Registry interceptor does not implement RegistryInterceptor interface: " + interceptorClass.getName());
                }
                try {
                    interceptor = interceptorClass.newInstance();
                }
                catch (Throwable th) {
                    throw new RegistryException("Failed to instantiate registry interceptor", th);
                }
                RegistryInterceptor registryInterceptor = (RegistryInterceptor)interceptor;
                registryInterceptor.setRegistry(current);
                registryInterceptors[count] = registryInterceptor;
                current = registryInterceptor;
            }
        }
        catch (RegistryException re) {
            for (int count = 1; count <= numInterceptors; ++count) {
                RegistryInterceptor interceptor = registryInterceptors[count];
                if (interceptor == null) continue;
                interceptor.setRegistry(null);
            }
            logger.error((Object)"Failed to create registry interceptors, falling back to registry implementation", (Throwable)re);
            return registry;
        }
        HeadRegistryInterceptor headInterceptor = new HeadRegistryInterceptor();
        headInterceptor.setRegistry(current);
        registryInterceptors[0] = headInterceptor;
        interceptors = registryInterceptors;
        return headInterceptor;
    }

    private static final class HeadRegistryInterceptor
    extends AbstractRegistryInterceptor {
        private HeadRegistryInterceptor() {
        }

        @Override
        public List<String> findAllServices() throws RegistryException {
            return this.getRegistry().findAllServices();
        }

        @Override
        public EPR findEPR(String serviceCategoryName, String serviceName) throws RegistryException, ServiceNotFoundException {
            return this.getRegistry().findEPR(serviceCategoryName, serviceName);
        }

        @Override
        public List<EPR> findEPRs(String serviceCategoryName, String serviceName) throws RegistryException, ServiceNotFoundException {
            return this.getRegistry().findEPRs(serviceCategoryName, serviceName);
        }

        @Override
        public List<String> findServices(String serviceCategoryName) throws RegistryException {
            return this.getRegistry().findServices(serviceCategoryName);
        }

        @Override
        public void registerEPR(String serviceCategoryName, String serviceName, String serviceDescription, EPR epr, String eprDescription) throws RegistryException {
            this.getRegistry().registerEPR(serviceCategoryName, serviceName, serviceDescription, epr, eprDescription);
        }

        @Override
        public void unRegisterEPR(String serviceCategoryName, String serviceName, EPR epr) throws RegistryException, ServiceNotFoundException {
            this.getRegistry().unRegisterEPR(serviceCategoryName, serviceName, epr);
        }

        @Override
        public void unRegisterService(String category, String serviceName) throws RegistryException, ServiceNotFoundException {
            this.getRegistry().unRegisterService(category, serviceName);
        }
    }
}

