/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.schedule;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.lifecycle.LifecycleResource;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceFactory;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.schedule.SchedulingException;
import org.jboss.soa.esb.util.ClassUtil;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerResource {
    private static Logger LOGGER = Logger.getLogger(SchedulerResource.class);
    private static final LifecycleResourceFactory<SchedulerResource> lifecycleSchedulerFactory = new SchedulerFactory();
    private static final LifecycleResource<SchedulerResource> lifecycleSchedulerResource = new LifecycleResource<SchedulerResource>(lifecycleSchedulerFactory, 70000);
    public static final String INSTANCE_NAME = "org.quartz.scheduler.instanceName";
    public static final String THREAD_NAME = "org.quartz.scheduler.threadName";
    public static final String THREAD_COUNT = "org.quartz.threadPool.threadCount";
    private Scheduler scheduler;

    private SchedulerResource() {
    }

    synchronized void start(Trigger trigger, JobDetail jobDetail, Properties properties) throws SchedulingException {
        this.initScheduler(properties);
        try {
            try {
                this.scheduler.scheduleJob(jobDetail, trigger);
            }
            catch (ObjectAlreadyExistsException oaee) {
                this.scheduler.resumeTrigger(trigger.getName(), trigger.getGroup());
            }
        }
        catch (SchedulerException se) {
            throw new SchedulingException("Failed to start scheduled job", se);
        }
    }

    synchronized void pause(Trigger trigger) throws SchedulingException {
        if (this.scheduler != null) {
            try {
                if (this.scheduler.isShutdown()) {
                    throw new SchedulingException("Scheduler has been shutdown");
                }
                this.scheduler.pauseTrigger(trigger.getName(), trigger.getGroup());
            }
            catch (SchedulerException se) {
                throw new SchedulingException("Failed to pause scheduled job", se);
            }
        }
    }

    synchronized void destroy(Trigger trigger) throws SchedulingException {
        if (this.scheduler != null) {
            try {
                if (this.scheduler.isShutdown()) {
                    throw new SchedulingException("Scheduler has been shutdown");
                }
                this.scheduler.unscheduleJob(trigger.getName(), trigger.getGroup());
            }
            catch (SchedulerException se) {
                throw new SchedulingException("Failed to destroy scheduled job", se);
            }
        }
    }

    synchronized void shutdown() throws SchedulingException {
        if (this.scheduler != null) {
            try {
                if (!this.scheduler.isShutdown()) {
                    this.scheduler.shutdown();
                }
            }
            catch (SchedulerException se) {
                throw new SchedulingException("Failed to shutdown scheduler", se);
            }
        }
    }

    private void initScheduler(Properties properties) throws SchedulingException {
        if (this.scheduler == null) {
            Scheduler scheduler;
            InputStream quartzProperties = ClassUtil.getResourceAsStream("quartz.properties", SchedulerResource.class);
            if (quartzProperties == null) {
                throw new SchedulingException("Failed to locate the default scheduling properties");
            }
            Properties defaultProperties = new Properties();
            try {
                defaultProperties.load(quartzProperties);
            }
            catch (IOException ioe) {
                throw new SchedulingException("Failed to load the default scheduling properties");
            }
            if (properties != null) {
                defaultProperties.putAll((Map<?, ?>)properties);
            }
            String name = "ESBScheduler:" + this.getDeploymentName();
            defaultProperties.put(INSTANCE_NAME, name);
            defaultProperties.put(THREAD_NAME, name);
            if (!defaultProperties.containsKey(THREAD_COUNT)) {
                defaultProperties.put(THREAD_COUNT, "1");
            }
            try {
                scheduler = new StdSchedulerFactory(defaultProperties).getScheduler();
                scheduler.start();
            }
            catch (SchedulerException se) {
                throw new SchedulingException("Failed to initialise the scheduler", se);
            }
            this.scheduler = scheduler;
        }
    }

    private String getDeploymentName() {
        LifecycleResourceManager lifecycleResourceManager = LifecycleResourceManager.getSingleton();
        String[] associatedDeployments = lifecycleResourceManager.getAssociatedDeployments();
        String deployment = associatedDeployments != null && associatedDeployments.length == 1 ? associatedDeployments[0] : lifecycleResourceManager.getIdentity();
        return deployment;
    }

    static SchedulerResource getSchedulerResource() throws SchedulingException {
        try {
            return lifecycleSchedulerResource.getLifecycleResource();
        }
        catch (LifecycleResourceException lre) {
            throw new SchedulingException("Failed to obtain the contextualised scheduler resource", lre);
        }
    }

    private static class SchedulerFactory
    implements LifecycleResourceFactory<SchedulerResource> {
        private SchedulerFactory() {
        }

        @Override
        public SchedulerResource createLifecycleResource(String lifecycleIdentity) throws LifecycleResourceException {
            return new SchedulerResource();
        }

        @Override
        public void destroyLifecycleResource(SchedulerResource resource, String lifecycleIdentity) throws LifecycleResourceException {
            LOGGER.debug((Object)("Shutting down scheduler for identity " + lifecycleIdentity));
            try {
                resource.shutdown();
            }
            catch (SchedulingException se) {
                throw new LifecycleResourceException("Failed to shutdown the contextualised scheduler resource");
            }
        }
    }
}

