/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification.jms;

import java.net.URI;
import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;
import org.jboss.soa.esb.notification.jms.JMSPropertiesSetter;
import org.jboss.util.Strings;

public class DefaultJMSPropertiesSetter
implements JMSPropertiesSetter {
    private Logger log = Logger.getLogger(DefaultJMSPropertiesSetter.class);
    private static final String JMSX_GROUP_ID = "JMSXGroupID";
    private static final String JMSX_GROUP_SEQ = "JMSXGroupSeq";

    @Override
    public void setJMSProperties(Message fromESBMessage, javax.jms.Message toJMSMessage) throws JMSException {
        this.setJMSMessageID(fromESBMessage, toJMSMessage);
        this.setJMSCorrelationID(fromESBMessage, toJMSMessage);
        this.setJMSExpiration(fromESBMessage, toJMSMessage);
        this.setProperties(fromESBMessage, toJMSMessage);
    }

    private void setJMSCorrelationID(Message fromESBMessage, javax.jms.Message toJMSMessage) throws JMSException {
        URI correlationID = fromESBMessage.getHeader().getCall().getRelatesTo();
        if (correlationID != null) {
            this.log.debug((Object)("Setting outgoing JMSCorreletionID to : " + correlationID.getFragment()));
            toJMSMessage.setJMSCorrelationID(correlationID.getFragment());
        }
    }

    private void setJMSMessageID(Message fromESBMessage, javax.jms.Message toJMSMessage) throws JMSException {
        URI messageID = fromESBMessage.getHeader().getCall().getMessageID();
        if (messageID != null) {
            String msgID = messageID.toString();
            if (msgID.contains("&lt;")) {
                msgID = msgID.replace("&lt;", "<");
            }
            if (msgID.contains("&gt;")) {
                msgID = msgID.replace("&gt;", ">");
            }
            this.log.debug((Object)("Setting outgoing JMSCorreletionID to : " + msgID));
            toJMSMessage.setJMSCorrelationID(msgID);
        }
    }

    private void setJMSExpiration(Message fromESBMessage, javax.jms.Message toJMSMessage) throws JMSException {
        Object expirationObj = fromESBMessage.getProperties().getProperty("javax.jms.message.expiration");
        if (expirationObj instanceof Long) {
            Long expire = (Long)expirationObj;
            this.log.debug((Object)("Setting outgoing JMSExpiration to : " + expire));
            toJMSMessage.setJMSExpiration(expire.longValue());
        }
    }

    private void setProperties(Message fromESBMessage, javax.jms.Message toJMSMessage) throws JMSException {
        Properties properties = fromESBMessage.getProperties();
        for (String key : properties.getNames()) {
            if (!Strings.isValidJavaIdentifier((String)key) || (key.startsWith("JMSX") ? !JMSX_GROUP_ID.equals(key) && !JMSX_GROUP_SEQ.equals(key) : key.startsWith("JMS_"))) continue;
            Object value = properties.getProperty(key);
            this.log.debug((Object)("Setting outgoing JMSProperty, key : " + key + ", value : " + value));
            if (value instanceof String) {
                toJMSMessage.setStringProperty(key, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                toJMSMessage.setBooleanProperty(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Short) {
                toJMSMessage.setShortProperty(key, ((Short)value).shortValue());
                continue;
            }
            if (value instanceof Integer) {
                toJMSMessage.setIntProperty(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                toJMSMessage.setLongProperty(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Float) {
                toJMSMessage.setFloatProperty(key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                toJMSMessage.setDoubleProperty(key, ((Double)value).doubleValue());
                continue;
            }
            if (!(value instanceof Byte)) continue;
            toJMSMessage.setByteProperty(key, ((Byte)value).byteValue());
        }
    }
}

