/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.notification.PropertySubstituter;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.persist.JdbcCleanConn;
import org.jboss.soa.esb.helpers.persist.SimpleDataSource;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotificationTarget;

public class NotifySqlTable
extends NotificationTarget {
    private Logger log = Logger.getLogger(NotifySqlTable.class);
    public static final String CHILD_COLUMN = "column";
    public static final String ATT_TABLE = "table";
    public static final String ATT_DATA = "dataColumn";
    public static final String ATT_NAME = "name";
    public static final String ATT_VALUE = "value";
    protected String m_sDriver;
    protected String m_sURL;
    protected String m_sUser;
    protected String m_sPwd;
    protected String m_sTable;
    protected String m_sDataCol;
    protected Properties m_oCols;
    private MessagePayloadProxy payloadProxy;

    public NotifySqlTable(ConfigTree configTree) throws ConfigurationException {
        super(configTree);
        this.payloadProxy = new MessagePayloadProxy(configTree, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
    }

    private void setProperties(Message message) throws ConfigurationException {
        this.m_sDriver = this.getAttr("driver-class");
        this.m_sURL = this.getAttr("connection-url");
        this.m_sUser = this.getAttr("user-name");
        this.m_sPwd = this.getAttr("password");
        this.m_sTable = this.getAttr(ATT_TABLE);
        this.m_sDataCol = this.getAttr(ATT_DATA);
        this.m_oCols = new Properties();
        ConfigTree[] oaP = this.m_oParms.getChildren(CHILD_COLUMN);
        for (int i1 = 0; i1 < oaP.length; ++i1) {
            ConfigTree oCurr = oaP[i1];
            String sCol = oCurr.getAttribute(ATT_NAME);
            if (null == sCol || (sCol = sCol.trim()).length() < 1) continue;
            String sVal = oCurr.getAttribute(ATT_VALUE);
            if (null == sVal) {
                sVal = "";
            }
            sCol = PropertySubstituter.replaceArguments(sCol, message);
            sVal = PropertySubstituter.replaceArguments(sVal, message);
            this.m_oCols.setProperty(sCol, sVal);
        }
    }

    private String getAttr(String p_sAtt) throws ConfigurationException {
        String sRet = this.m_oParms.getAttribute(p_sAtt);
        if (null == sRet) {
            throw new ConfigurationException("Missing " + p_sAtt + " attribute");
        }
        sRet = sRet.trim();
        if (p_sAtt.equals("password")) {
            return sRet;
        }
        if (sRet.length() < 1) {
            throw new ConfigurationException("Empty " + p_sAtt + " attribute");
        }
        return sRet;
    }

    public String getInsertStmt() {
        String[] saCols = new String[this.m_oCols.size()];
        this.m_oCols.keySet().toArray(saCols);
        StringBuffer sbCol = new StringBuffer("insert into ").append(this.m_sTable).append(" ");
        StringBuffer sbPrm = new StringBuffer(" values ");
        for (int i1 = 0; i1 < saCols.length; ++i1) {
            String sIn = i1 == 0 ? "(" : ",";
            String sCurrCol = saCols[i1];
            sbCol.append(sIn).append(sCurrCol);
            sbPrm.append(sIn).append("'").append(this.m_oCols.getProperty(sCurrCol)).append("'");
        }
        return sbCol.append(")").append(sbPrm).append(")").toString();
    }

    @Override
    public void sendNotification(Message message) throws NotificationException {
        Object obj;
        try {
            obj = this.payloadProxy.getPayload(message);
            this.setProperties(message);
        }
        catch (MessageDeliverException e) {
            throw new NotificationException(e);
        }
        catch (ConfigurationException ce) {
            throw new NotificationException(ce);
        }
        String content = obj instanceof byte[] ? new String((byte[])obj) : obj.toString();
        this.m_oCols.setProperty(this.m_sDataCol, content);
        JdbcCleanConn oConn = null;
        Statement ps = null;
        try {
            oConn = this.createJdbcCleanConnection();
            ps = oConn.prepareStatement(this.getInsertStmt());
            oConn.execUpdWait((PreparedStatement)ps, 3);
            oConn.commit();
        }
        catch (SQLException e) {
            String errorMsg = "SqlException while trying to notify table. Insert statement : " + this.getInsertStmt();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new NotificationException(errorMsg, e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    this.log.error((Object)"SqlException while trying to close prepared statement PS", (Throwable)e);
                }
            }
            if (null != oConn) {
                oConn.release();
            }
        }
    }

    protected JdbcCleanConn createJdbcCleanConnection() {
        return new JdbcCleanConn(new SimpleDataSource(this.m_sDriver, this.m_sURL, this.m_sUser, this.m_sPwd));
    }
}

