/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPool;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;
import org.jboss.soa.esb.notification.NotifyJMS;

public class NotifyQueues
extends NotifyJMS {
    private Logger log = Logger.getLogger(NotifyQueues.class);
    public static final String CHILD_QUEUE = "queue";

    public NotifyQueues(ConfigTree p_oP) throws ConfigurationException, JMSException, ConnectionException {
        super(p_oP);
        this.setUpProducers(p_oP.getChildren(CHILD_QUEUE));
    }

    @Override
    protected void send(Message p_oMsg, MessageProducer msgProducer) throws JMSException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending to queue with DeliveryMode : " + msgProducer.getDeliveryMode()));
            this.log.debug((Object)("Sending to queue with Priority : " + msgProducer.getPriority()));
            this.log.debug((Object)("Sending to queue with TTL : " + msgProducer.getTimeToLive()));
        }
        msgProducer.send(p_oMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MessageProducer createProducer(JmsConnectionPool pool, String destinationName, Session session, Properties environment) throws NamingException, JMSException, ConnectionException {
        MessageProducer messageProducer;
        Context context = NamingContextPool.getNamingContext(environment);
        try {
            Destination destination = null;
            try {
                destination = (Destination)context.lookup(destinationName);
            }
            catch (NamingException ne) {
                context = NamingContextPool.replaceNamingContext(context, environment);
                try {
                    destination = (Destination)context.lookup(destinationName);
                }
                catch (NamingException nex) {
                    session.createTopic(destinationName);
                }
            }
            messageProducer = session.createProducer(destination);
        }
        catch (Throwable throwable) {
            try {
                NamingContextPool.releaseNamingContext(context);
                throw throwable;
            }
            catch (NamingContextException nce) {
                throw new ConnectionException("Unexpected exception while accessing Naming Context pool", nce);
            }
        }
        NamingContextPool.releaseNamingContext(context);
        return messageProducer;
    }
}

