/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.notification.PropertySubstituter;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotificationTarget;
import org.jboss.soa.esb.notification.NotifyUtil;

public class NotifyFiles
extends NotificationTarget {
    private Logger log = Logger.getLogger(NotifyFiles.class);
    public static final String CHILD_FILE = "file";
    public static final String ATT_URI = "URI";
    public static final String ATT_APPEND = "append";
    protected NotificationFile[] m_oaOutF;
    private MessagePayloadProxy payloadProxy;

    public NotifyFiles(ConfigTree configTree) {
        super(configTree);
        this.payloadProxy = new MessagePayloadProxy(configTree, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
    }

    protected void setFiles(Message message) {
        ConfigTree[] p_oaP = this.m_oParms.getChildren(CHILD_FILE);
        this.m_oaOutF = new NotificationFile[p_oaP.length];
        for (int i = 0; i < p_oaP.length; ++i) {
            String fileURIString = p_oaP[i].getAttribute(ATT_URI);
            String append = p_oaP[i].getAttribute(ATT_APPEND);
            if (null == fileURIString) {
                throw new IllegalArgumentException("Bad File Notification Configuration: Missing file URI attribute.");
            }
            fileURIString = fileURIString.replace('\\', '/');
            fileURIString = PropertySubstituter.replaceArguments(fileURIString, message);
            append = PropertySubstituter.replaceArguments(append, message);
            try {
                URI fileURI = new URI(fileURIString);
                if (CHILD_FILE.equalsIgnoreCase(fileURI.getScheme())) {
                    if (fileURI.getHost() != null) {
                        throw new IllegalArgumentException("Sorry, the NotifyFiles notifier doesn't support remote directories: '" + fileURIString + "'.  To reference a local dir, add a forward slash character before '" + fileURI.getAuthority() + "'.");
                    }
                    this.m_oaOutF[i] = new NotificationFile(fileURI, Boolean.valueOf(append));
                } else {
                    this.m_oaOutF[i] = new NotificationFile(fileURIString, (boolean)Boolean.valueOf(append));
                }
            }
            catch (URISyntaxException e) {
                this.m_oaOutF[i] = new NotificationFile(fileURIString, (boolean)Boolean.valueOf(append));
            }
            File parent = this.m_oaOutF[i].getAbsoluteFile().getParentFile();
            if (null != parent && parent.exists()) continue;
            throw new IllegalArgumentException("Bad File Notification Configuration: Parent folder for file [" + this.m_oaOutF[i].getAbsolutePath() + "] doesn't exist.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNotification(Message message) throws NotificationException {
        FileOutputStream fileOutStream = null;
        this.setFiles(message);
        StringBuilder exceptions = new StringBuilder();
        for (NotificationFile notificationFile : this.m_oaOutF) {
            try {
                fileOutStream = new FileOutputStream(notificationFile, notificationFile.append);
                Object obj = this.payloadProxy.getPayload(message);
                if (obj instanceof Serializable && !(obj instanceof byte[]) && !(obj instanceof String)) {
                    this.objectNotification(fileOutStream, this.payloadProxy.getPayload(message));
                    continue;
                }
                String content = null;
                content = obj instanceof byte[] ? new String((byte[])obj) : obj.toString();
                this.stringNotification(fileOutStream, content);
            }
            catch (IOException e) {
                this.handleException(notificationFile, e, exceptions);
            }
            catch (MessageDeliverException e) {
                this.handleException(notificationFile, e, exceptions);
            }
            finally {
                try {
                    if (fileOutStream != null) {
                        fileOutStream.close();
                    }
                }
                catch (IOException eCl) {
                    this.log.error((Object)"IOException while closing fileOutStream: ", (Throwable)eCl);
                }
            }
        }
        if (exceptions.length() > 0) {
            throw new NotificationException(exceptions.toString());
        }
    }

    private void handleException(NotificationFile notificationFile, Exception e, StringBuilder exceptions) {
        String msg = "[Exception while notifying file : " + notificationFile;
        this.log.error((Object)msg, (Throwable)e);
        exceptions.append(NotifyUtil.createExceptionErrorString(msg, e));
    }

    protected void stringNotification(FileOutputStream p_oF, String p_s) throws IOException {
        p_oF.write(p_s.getBytes());
        if (!p_s.endsWith("\n")) {
            p_oF.write("\n".getBytes());
        }
    }

    protected void objectNotification(FileOutputStream p_oF, Object p_o) throws IOException {
        ObjectOutputStream OS = new ObjectOutputStream(p_oF);
        OS.writeObject(p_o);
    }

    private static class NotificationFile
    extends File {
        private static final long serialVersionUID = 1L;
        private boolean append = false;

        private NotificationFile(URI fileURI, boolean append) {
            super(fileURI);
            this.append = append;
        }

        public NotificationFile(String file, boolean append) {
            super(file);
            this.append = append;
        }
    }
}

