/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotifyFTP;

public class NotifyFTPList
extends NotifyFTP {
    private Logger log = Logger.getLogger(NotifyFTPList.class);
    public static final String FILE_LOCATION = NotifyFTPList.class.getName() + "#filename";
    private boolean listFiles;
    private boolean deleteListFile;

    public NotifyFTPList(ConfigTree config) throws NotificationException {
        super(config);
        ConfigTree ftpConfig = this.getFtpConfig();
        this.listFiles = ftpConfig.getBooleanAttribute("listFiles", false);
        this.deleteListFile = ftpConfig.getBooleanAttribute("deleteListFile", false);
    }

    @Override
    public void sendNotification(Message message) throws NotificationException {
        Object object = message.getBody().get();
        if (object instanceof List) {
            List files = (List)object;
            for (String fileName : files) {
                this.send(fileName, message);
            }
        } else if (object instanceof String) {
            String fileName = (String)object;
            this.send(fileName, message);
        }
    }

    private void send(String fileName, Message message) throws NotificationException {
        File file = new File(fileName);
        if (this.listFiles) {
            this.sendFiles(file, message);
        } else {
            this.sendFile(file, message);
        }
    }

    private void sendFile(File file, Message message) throws NotificationException {
        this.log.info((Object)("Sending file [" + file.getAbsolutePath() + "]"));
        message.getBody().add(FILE_LOCATION, file);
        this.send(message);
    }

    private void sendFiles(File listFile, Message message) throws NotificationException {
        boolean deleted;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(listFile));
            String fileName = null;
            this.log.info((Object)("Sending from listFile [" + listFile.getAbsolutePath() + "]"));
            while ((fileName = reader.readLine()) != null) {
                message.getBody().add(FILE_LOCATION, new File(fileName));
                this.send(message);
            }
            this.log.info((Object)("Done sending from listFile [" + listFile.getAbsolutePath() + "]"));
        }
        catch (FileNotFoundException e) {
            throw new NotificationException("Could not find file [" + listFile.getAbsolutePath() + "]", e);
        }
        catch (IOException e) {
            throw new NotificationException("Could not read from file [" + listFile.getAbsolutePath() + "]", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"IOException while trying to close reader :", (Throwable)e);
                }
            }
        }
        if (this.deleteListFile && !(deleted = listFile.delete())) {
            this.log.warn((Object)("Could not delete listFile [" + listFile.getAbsolutePath() + "]"));
        }
    }

    protected void send(Message message) throws NotificationException {
        super.sendNotification(message);
    }

    @Override
    protected File getFileToSend(Message message) {
        return (File)message.getBody().get(FILE_LOCATION);
    }

    @Override
    protected String getFileName(Message message) throws NotificationException {
        File file = (File)message.getBody().get(FILE_LOCATION);
        if (file == null) {
            throw new NotificationException("Could not find a file in the file location");
        }
        return file.getName();
    }
}

