/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.notification.PropertySubstituter;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.ListenerUtil;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotificationTarget;
import org.jboss.soa.esb.util.RemoteFileSystem;
import org.jboss.soa.esb.util.RemoteFileSystemException;
import org.jboss.soa.esb.util.RemoteFileSystemFactory;

public class NotifyFTP
extends NotificationTarget {
    private Logger log = Logger.getLogger(NotifyFTP.class);
    private ConfigTree config;
    private FTPEpr epr;
    private String fileName;
    public static final String CHILD_FTP = "ftp";
    public static final String ATTR_FILENAME = "filename";
    public static final String TEMP_FILE_BASE = "jbossesb-NotifyFTP";
    private MessagePayloadProxy payloadProxy;

    public NotifyFTP(ConfigTree config) {
        this.config = config;
        this.payloadProxy = new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.content.bytes"});
    }

    protected ConfigTree getFtpConfig() throws NotificationException {
        ConfigTree[] ftps = this.config.getChildren(CHILD_FTP);
        if (ftps.length != 1) {
            throw new NotificationException("NotifyFTP requires exactly one 'ftp' element.");
        }
        return ftps[0];
    }

    protected String getFileName(Message message) throws NotificationException {
        if (this.fileName == null) {
            ConfigTree ftpConfig = this.getFtpConfig();
            this.fileName = ftpConfig.getAttribute(ATTR_FILENAME);
            if (StringUtils.isEmpty((String)this.fileName)) {
                throw new NotificationException("NotifyFTP: Filename attribute is required.");
            }
            this.fileName = PropertySubstituter.replaceArguments(this.fileName, message);
        }
        return this.fileName;
    }

    protected FTPEpr getFtpEpr() throws NotificationException {
        if (this.epr == null) {
            ConfigTree ftpConfig = this.getFtpConfig();
            String url = ftpConfig.getAttribute("URL");
            try {
                this.epr = (FTPEpr)ListenerUtil.fileEprFromElement(ftpConfig);
            }
            catch (ConfigurationException ex) {
                throw new NotificationException(ex);
            }
            catch (ClassCastException ex) {
                throw new NotificationException("Not an FTPEpr!", ex);
            }
        }
        return this.epr;
    }

    @Override
    public void sendNotification(Message message) throws NotificationException {
        File fileToSend = null;
        RemoteFileSystem rfs = null;
        try {
            fileToSend = this.getFileToSend(message);
            rfs = RemoteFileSystemFactory.getRemoteFileSystem(this.getFtpEpr(), true);
            rfs.uploadFile(fileToSend, this.getFileName(message));
        }
        catch (RemoteFileSystemException e) {
            throw new NotificationException("Could not complete FTP notification", e);
        }
        catch (IOException e) {
            throw new NotificationException("Could not complete FTP notification", e);
        }
        finally {
            if (fileToSend != null) {
                fileToSend.delete();
            }
            if (rfs != null) {
                rfs.quit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File getFileToSend(Message message) throws IOException {
        FileOutputStream stream = null;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile(TEMP_FILE_BASE, null);
            stream = new FileOutputStream(tmpFile);
            Object payload = this.payloadProxy.getPayload(message);
            if (payload instanceof byte[]) {
                IOUtils.write((byte[])((byte[])payload), (OutputStream)stream);
            } else {
                IOUtils.write((String)payload.toString(), (OutputStream)stream);
            }
            stream.close();
            if (stream == null) return tmpFile;
        }
        catch (MessageDeliverException e) {
            try {
                this.log.error((Object)("MessageDeliveryException while calling getPayLoad : " + e));
                if (stream == null) return tmpFile;
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)stream);
            return tmpFile;
        }
        IOUtils.closeQuietly((OutputStream)stream);
        return tmpFile;
    }
}

