/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.notification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.routing.email.Emailer;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.Email;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;
import org.jboss.soa.esb.notification.NotificationException;
import org.jboss.soa.esb.notification.NotificationTarget;

public class NotifyEmail
extends NotificationTarget {
    private Emailer emailer;
    @Deprecated
    private static final String MESSAGE_ATTACHMENT_NAME = "msgAttachmentName";

    public NotifyEmail(ConfigTree configTree) throws ConfigurationException {
        this(configTree, new Emailer(configTree));
    }

    public NotifyEmail(ConfigTree config, Emailer emailer) {
        super(config);
        this.emailer = emailer;
    }

    @Override
    public void sendNotification(Message message) throws NotificationException {
        try {
            this.emailer.sendEmail(message);
        }
        catch (MessageDeliverException e) {
            throw new NotificationException("Exception while trying to send email", e);
        }
    }

    protected void overrideSmtpProperties(Message message, ConfigTree configTree) {
        Properties properties = message.getProperties();
        this.override("host", properties, configTree);
        this.override("port", properties, configTree);
        this.override("username", properties, configTree);
        this.override("password", properties, configTree);
        this.override("auth", properties, configTree);
        this.override("from", properties, configTree);
        this.override("sendTo", properties, configTree);
        this.override("ccTo", properties, configTree);
        this.override("subject", properties, configTree);
        this.override(MESSAGE_ATTACHMENT_NAME, properties, configTree);
    }

    private void override(String key, Properties properties, ConfigTree configTree) {
        String value = (String)properties.getProperty(key);
        if (value != null) {
            configTree.setAttribute(key, value);
        }
    }

    protected void sendEmailNotification(ConfigTree messageParams, byte[] msgPayload) throws AddressException, MessagingException, IOException {
        Email esbMail = this.createEmailInstance(messageParams);
        esbMail.setSendTo(messageParams.getAttribute("sendTo"));
        esbMail.setFrom(messageParams.getAttribute("from"));
        esbMail.setCopyTo(messageParams.getAttribute("ccTo"));
        esbMail.setSubject(messageParams.getAttribute("subject"));
        esbMail.setAttachments(messageParams.getTextChildren("attachment"));
        if (messageParams.getAttribute(MESSAGE_ATTACHMENT_NAME) != null) {
            esbMail.addAttachment(new ByteArrayInputStream(msgPayload), messageParams.getAttribute(MESSAGE_ATTACHMENT_NAME));
        } else {
            esbMail.setMessage(messageParams.getAttribute("message"));
        }
        esbMail.sendMessage();
    }

    private Email createEmailInstance(ConfigTree configTree) throws AddressException, MessagingException {
        int port;
        String portStr = configTree.getAttribute("port");
        if (portStr == null) {
            portStr = Configuration.getSmtpPort();
        }
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            throw new MessagingException("Could not parse port '" + portStr + "'");
        }
        String host = configTree.getAttribute("host", Configuration.getSmtpHost());
        String username = configTree.getAttribute("username", Configuration.getSmtpUsername());
        String password = configTree.getAttribute("password", Configuration.getSmtpPassword());
        boolean auth = configTree.getBooleanAttribute("auth", false);
        return new Email(host, port, username, password, auth);
    }
}

